/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzavU;
    private final DataType zzavT;
    private final long zzaxo;
    private final long zzaBl;
    private final long zzaBk;
    private final int zzaxp;
    private final LocationRequest zzaBp;
    private final long zzaBq;

    private SensorRequest(Builder builder) {
        this.zzavU = builder.zzavU;
        this.zzavT = builder.zzavT;
        this.zzaxo = builder.zzaxo;
        this.zzaBl = builder.zzaBl;
        this.zzaBk = builder.zzaBk;
        this.zzaxp = builder.zzaxp;
        this.zzaBp = null;
        this.zzaBq = builder.zzaBq;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzaBp = locationRequest;
        this.zzaxo = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzaBl = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzaBk = this.zzaxo;
        this.zzavT = dataSource.getDataType();
        this.zzaxp = SensorRequest.zza(locationRequest);
        this.zzavU = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzaBq = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzavU;
    }

    public DataType getDataType() {
        return this.zzavT;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaxo, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaBl, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaBk, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzaxp;
    }

    public long zzvc() {
        return this.zzaBq;
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("dataSource", (Object)this.zzavU).zzg("dataType", (Object)this.zzavT).zzg("samplingRateMicros", (Object)this.zzaxo).zzg("deliveryLatencyMicros", (Object)this.zzaBk).zzg("timeOutMicros", (Object)this.zzaBq).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.zza((SensorRequest)that);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzw.equal((Object)this.zzavU, (Object)sensorRequest.zzavU) && zzw.equal((Object)this.zzavT, (Object)sensorRequest.zzavT) && this.zzaxo == sensorRequest.zzaxo && this.zzaBl == sensorRequest.zzaBl && this.zzaBk == sensorRequest.zzaBk && this.zzaxp == sensorRequest.zzaxp && zzw.equal((Object)this.zzaBp, (Object)sensorRequest.zzaBp) && this.zzaBq == sensorRequest.zzaBq;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzavU, this.zzavT, this.zzaxo, this.zzaBl, this.zzaBk, this.zzaxp, this.zzaBp, this.zzaBq});
    }

    public static int zzfB(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return n;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource zzavU;
        private DataType zzavT;
        private long zzaxo = -1L;
        private long zzaBl = 0L;
        private long zzaBk = 0L;
        private boolean zzaBr = false;
        private int zzaxp = 2;
        private long zzaBq = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzavU = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzavT = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            zzx.zzb((interval >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzaxo = unit.toMicros(interval);
            if (!this.zzaBr) {
                this.zzaBl = this.zzaxo / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            zzx.zzb((fastestInterval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzaBr = true;
            this.zzaBl = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            zzx.zzb((interval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzaBk = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.zzaxp = SensorRequest.zzfB(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            zzx.zzb((timeout > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{timeout});
            zzx.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzaBq = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            zzx.zza((this.zzavU != null || this.zzavT != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzx.zza((this.zzavT == null || this.zzavU == null || this.zzavT.equals(this.zzavU.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

