/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.fitness.data.BleDevice;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zza;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BleDevicesResult
implements Result,
SafeParcelable {
    private final int mVersionCode;
    private final List<BleDevice> zzaBE;
    private final Status zzUX;
    public static final Parcelable.Creator<BleDevicesResult> CREATOR = new zza();

    BleDevicesResult(int versionCode, List<BleDevice> bleDevices, Status status) {
        this.mVersionCode = versionCode;
        this.zzaBE = Collections.unmodifiableList(bleDevices);
        this.zzUX = status;
    }

    public BleDevicesResult(List<BleDevice> bleDevices, Status status) {
        this.mVersionCode = 3;
        this.zzaBE = Collections.unmodifiableList(bleDevices);
        this.zzUX = status;
    }

    public static BleDevicesResult zzQ(Status status) {
        return new BleDevicesResult(Collections.emptyList(), status);
    }

    public List<BleDevice> getClaimedBleDevices() {
        return this.zzaBE;
    }

    public List<BleDevice> getClaimedBleDevices(DataType dataType) {
        ArrayList<BleDevice> arrayList = new ArrayList<BleDevice>();
        for (BleDevice bleDevice : this.zzaBE) {
            if (!bleDevice.getDataTypes().contains(dataType)) continue;
            arrayList.add(bleDevice);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzUX;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof BleDevicesResult && this.zzb((BleDevicesResult)that);
    }

    private boolean zzb(BleDevicesResult bleDevicesResult) {
        return this.zzUX.equals((Object)bleDevicesResult.zzUX) && zzw.equal(this.zzaBE, bleDevicesResult.zzaBE);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzUX, this.zzaBE});
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("status", (Object)this.zzUX).zzg("bleDevices", this.zzaBE).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }
}

