/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.zzi;
import com.google.android.gms.internal.zznv;
import com.google.android.gms.internal.zzoz;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int mVersionCode;
    private final String zzawI;
    private final String zzawJ;
    private final String zzadc;
    private final String zzawK;
    private final int zzabB;
    private final int zzawL;
    public static final Parcelable.Creator<Device> CREATOR = new zzi();

    public static Device getLocalDevice(Context context) {
        int n = zznv.zzaG(context);
        String string = Device.zzaC(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, string, n, 2);
    }

    private static String zzaC(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(manufacturer, model, "", uid, type, 0);
    }

    public Device(String manufacturer, String model, String version, String uid, int type, int platformType) {
        this(1, manufacturer, model, "", uid, type, platformType);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type, int platformType) {
        this.mVersionCode = versionCode;
        this.zzawI = (String)zzx.zzz((Object)manufacturer);
        this.zzawJ = (String)zzx.zzz((Object)model);
        this.zzadc = "";
        this.zzawK = (String)zzx.zzz((Object)uid);
        this.zzabB = type;
        this.zzawL = platformType;
    }

    public String getManufacturer() {
        return this.zzawI;
    }

    public String getModel() {
        return this.zzawJ;
    }

    public String getVersion() {
        return this.zzadc;
    }

    public String getUid() {
        return this.zzawK;
    }

    public int getType() {
        return this.zzabB;
    }

    public int zzur() {
        return this.zzawL;
    }

    private boolean zzus() {
        return this.zzur() == 1;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.zzawI, this.zzawJ, this.zzawK);
    }

    public String zzut() {
        return this.zzus() ? this.zzawK : zzoz.zzdF(this.zzawK);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s:%s}", this.getStreamIdentifier(), this.zzadc, this.zzabB, this.zzawL);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.zza((Device)that);
    }

    private boolean zza(Device device) {
        return zzw.equal((Object)this.zzawI, (Object)device.zzawI) && zzw.equal((Object)this.zzawJ, (Object)device.zzawJ) && zzw.equal((Object)this.zzadc, (Object)device.zzadc) && zzw.equal((Object)this.zzawK, (Object)device.zzawK) && this.zzabB == device.zzabB && this.zzawL == device.zzawL;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzawI, this.zzawJ, this.zzadc, this.zzawK, this.zzabB});
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzi.zza(this, parcel, flags);
    }
}

