/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.internal.service.FitnessDataSourcesRequest;
import com.google.android.gms.fitness.internal.service.FitnessUnregistrationRequest;
import com.google.android.gms.fitness.internal.service.zzc;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzne;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzow;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzaBP;

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzaBP = new zza(this);
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                Log.d((String)"FitnessSensorService", (String)("Intent " + intent + " received by " + ((Object)((Object)this)).getClass().getName()));
            }
            return this.zzaBP.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    @TargetApi(value=19)
    protected void zzvr() throws SecurityException {
        int n = Binder.getCallingUid();
        String string = "com.google.android.gms";
        if (zzne.zzsk()) {
            AppOpsManager appOpsManager = (AppOpsManager)this.getSystemService("appops");
            appOpsManager.checkPackage(n, "com.google.android.gms");
            return;
        }
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string2.equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    private static class zza
    extends zzc.zza {
        private final FitnessSensorService zzaBQ;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzaBQ = fitnessSensorService;
        }

        @Override
        public void zza(FitnessDataSourcesRequest fitnessDataSourcesRequest, zzoi zzoi2) throws RemoteException {
            this.zzaBQ.zzvr();
            List<DataSource> list = this.zzaBQ.onFindDataSources(fitnessDataSourcesRequest.getDataTypes());
            zzoi2.zza(new DataSourcesResult(list, Status.zzagC));
        }

        @Override
        public void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzow zzow2) throws RemoteException {
            this.zzaBQ.zzvr();
            if (this.zzaBQ.onRegister(fitnessSensorServiceRequest)) {
                zzow2.zzp(Status.zzagC);
            } else {
                zzow2.zzp(new Status(13));
            }
        }

        @Override
        public void zza(FitnessUnregistrationRequest fitnessUnregistrationRequest, zzow zzow2) throws RemoteException {
            this.zzaBQ.zzvr();
            if (this.zzaBQ.onUnregister(fitnessUnregistrationRequest.getDataSource())) {
                zzow2.zzp(Status.zzagC);
            } else {
                zzow2.zzp(new Status(13));
            }
        }
    }
}

