/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.SessionInsertRequest;
import com.google.android.gms.fitness.request.SessionReadRequest;
import com.google.android.gms.fitness.result.SessionReadResult;
import com.google.android.gms.fitness.result.SessionStopResult;

public interface SessionsApi {
    public PendingResult<Status> startSession(GoogleApiClient var1, Session var2);

    public PendingResult<SessionStopResult> stopSession(GoogleApiClient var1, String var2);

    public PendingResult<Status> insertSession(GoogleApiClient var1, SessionInsertRequest var2);

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.BODY_SENSORS"}, conditional=true)
    public PendingResult<SessionReadResult> readSession(GoogleApiClient var1, SessionReadRequest var2);

    public PendingResult<Status> registerForSessions(GoogleApiClient var1, PendingIntent var2);

    public PendingResult<Status> unregisterForSessions(GoogleApiClient var1, PendingIntent var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private Session zzaCL;
        private String zzaCK;
        private boolean zzaCM = false;

        public ViewIntentBuilder(Context context) {
            this.mContext = context;
        }

        public ViewIntentBuilder setSession(Session session) {
            this.zzaCL = session;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String string) {
            this.zzaCK = string;
            this.zzaCM = true;
            return this;
        }

        public Intent build() {
            zzaa.zza((this.zzaCL != null ? 1 : 0) != 0, (Object)"Session must be set");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(Session.getMimeType(this.zzaCL.getActivity()));
            zzc.zza((SafeParcelable)this.zzaCL, (Intent)intent, (String)"vnd.google.fitness.session");
            if (!this.zzaCM) {
                this.zzaCK = this.zzaCL.getAppPackageName();
            }
            return this.zzk(intent);
        }

        private Intent zzk(Intent intent) {
            if (this.zzaCK == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzaCK);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzaCK, string));
                return intent2;
            }
            return intent;
        }
    }
}

