/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzd;
import com.google.android.gms.internal.zzql;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final DataSource zzaCI;
    private long zzaCX;
    private long zzaCY;
    private final Value[] zzaCZ;
    private DataSource zzaDa;
    private long zzaDb;
    private long zzaDc;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzd();

    DataPoint(int n, DataSource dataSource, long l, long l2, Value[] valueArray, DataSource dataSource2, long l3, long l4) {
        this.mVersionCode = n;
        this.zzaCI = dataSource;
        this.zzaDa = dataSource2;
        this.zzaCX = l;
        this.zzaCY = l2;
        this.zzaCZ = valueArray;
        this.zzaDb = l3;
        this.zzaDc = l4;
    }

    DataPoint(List<DataSource> list, RawDataPoint rawDataPoint) {
        this(DataPoint.zza(list, rawDataPoint.zzaDU), DataPoint.zza(list, rawDataPoint.zzaDV), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource dataSource2, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzaCX, 0L), DataPoint.zza(rawDataPoint.zzaCY, 0L), rawDataPoint.zzaCZ, dataSource2, DataPoint.zza(rawDataPoint.zzaDb, 0L), DataPoint.zza(rawDataPoint.zzaDc, 0L));
    }

    private static DataSource zza(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.mVersionCode = 4;
        this.zzaCI = (DataSource)((Object)zzaa.zzb((Object)((Object)dataSource), (Object)"Data source cannot be null"));
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzaCZ = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzaCZ[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzc.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long l, TimeUnit timeUnit) {
        this.zzaCX = timeUnit.toNanos(l);
        if (this.zzxo() && zzql.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzaCX = zzql.zza(this.zzaCX, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzxo() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long l, long l2, TimeUnit timeUnit) {
        this.zzaCY = timeUnit.toNanos(l);
        this.zzaCX = timeUnit.toNanos(l2);
        return this;
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzaCZ[n];
    }

    public Value[] zzxp() {
        return this.zzaCZ;
    }

    public DataPoint setFloatValues(float ... fArray) {
        this.zzfe(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.zzaCZ[i].setFloat(fArray[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... nArray) {
        this.zzfe(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.zzaCZ[i].setInt(nArray[i]);
        }
        return this;
    }

    private void zzfe(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzaa.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public DataType getDataType() {
        return this.zzaCI.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzaCI;
    }

    public DataSource getOriginalDataSource() {
        return this.zzaDa != null ? this.zzaDa : this.zzaCI;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaCX, TimeUnit.NANOSECONDS);
    }

    public long zzxq() {
        return this.zzaDb;
    }

    public long zzxr() {
        return this.zzaDc;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaCY, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaCX, TimeUnit.NANOSECONDS);
    }

    public void zzxs() {
        DataSource dataSource = this.getDataSource();
        zzaa.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzaa.zzb((this.zzaCX > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzaa.zzb((this.zzaCY <= this.zzaCX ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataPoint && this.zza((DataPoint)((Object)object));
    }

    private boolean zza(DataPoint dataPoint) {
        return zzz.equal((Object)((Object)this.zzaCI), (Object)((Object)dataPoint.zzaCI)) && this.zzaCX == dataPoint.zzaCX && this.zzaCY == dataPoint.zzaCY && Arrays.equals((Object[])this.zzaCZ, (Object[])dataPoint.zzaCZ) && zzz.equal((Object)((Object)this.getOriginalDataSource()), (Object)((Object)dataPoint.getOriginalDataSource()));
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaCI, this.zzaCX, this.zzaCY});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString((Object[])this.zzaCZ), this.zzaCY, this.zzaCX, this.zzaDb, this.zzaDc, this.zzaCI.toDebugString(), this.zzaDa != null ? this.zzaDa.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public long getTimestampNanos() {
        return this.zzaCX;
    }

    public long zzxt() {
        return this.zzaCY;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

