/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.zzh;
import java.util.concurrent.TimeUnit;

public class DataUpdateNotification
extends AbstractSafeParcelable {
    public static final String ACTION = "com.google.android.gms.fitness.DATA_UPDATE_NOTIFICATION";
    public static final int OPERATION_INSERT = 1;
    public static final int OPERATION_DELETE = 2;
    public static final int OPERATION_UPDATE = 3;
    public static final String EXTRA_DATA_UPDATE_NOTIFICATION = "vnd.google.fitness.data_udpate_notification";
    final int mVersionCode;
    private final long zzaDt;
    private final long zzaDu;
    private final int zzaDv;
    private final DataSource zzaCI;
    private final DataType zzaCH;
    public static final Parcelable.Creator<DataUpdateNotification> CREATOR = new zzh();

    DataUpdateNotification(int n, long l, long l2, int n2, DataSource dataSource, DataType dataType) {
        this.mVersionCode = n;
        this.zzaDt = l;
        this.zzaDu = l2;
        this.zzaDv = n2;
        this.zzaCI = dataSource;
        this.zzaCH = dataType;
    }

    public static DataUpdateNotification getDataUpdateNotification(Intent intent) {
        return (DataUpdateNotification)zzc.zza((Intent)intent, (String)EXTRA_DATA_UPDATE_NOTIFICATION, CREATOR);
    }

    public long zzxz() {
        return this.zzaDt;
    }

    public long zzxA() {
        return this.zzaDu;
    }

    public long getUpdateStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaDt, TimeUnit.NANOSECONDS);
    }

    public long getUpdateEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaDu, TimeUnit.NANOSECONDS);
    }

    public int getOperationType() {
        return this.zzaDv;
    }

    public DataSource getDataSource() {
        return this.zzaCI;
    }

    public DataType getDataType() {
        return this.zzaCH;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataUpdateNotification && this.zza((DataUpdateNotification)((Object)object));
    }

    private boolean zza(DataUpdateNotification dataUpdateNotification) {
        return this.zzaDt == dataUpdateNotification.zzaDt && this.zzaDu == dataUpdateNotification.zzaDu && this.zzaDv == dataUpdateNotification.zzaDv && zzz.equal((Object)((Object)this.zzaCI), (Object)((Object)dataUpdateNotification.zzaCI)) && zzz.equal((Object)((Object)this.zzaCH), (Object)((Object)dataUpdateNotification.zzaCH));
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaDt, this.zzaDu, this.zzaDv, this.zzaCI, this.zzaCH});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("updateStartTimeNanos", (Object)this.zzaDt).zzg("updateEndTimeNanos", (Object)this.zzaDu).zzg("operationType", (Object)this.zzaDv).zzg("dataSource", (Object)this.zzaCI).zzg("dataType", (Object)this.zzaCH).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }
}

