/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzn;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@KeepName
public final class RawBucket
extends AbstractSafeParcelable {
    final int mVersionCode;
    public final long zzXy;
    public final long zzaCJ;
    public final Session zzaCL;
    public final int zzaDT;
    public final List<RawDataSet> zzaCU;
    public final int zzaCV;
    public final boolean zzaCW;
    public static final Parcelable.Creator<RawBucket> CREATOR = new zzn();

    public RawBucket(int n, long l, long l2, Session session, int n2, List<RawDataSet> list, int n3, boolean bl) {
        this.mVersionCode = n;
        this.zzXy = l;
        this.zzaCJ = l2;
        this.zzaCL = session;
        this.zzaDT = n2;
        this.zzaCU = list;
        this.zzaCV = n3;
        this.zzaCW = bl;
    }

    public RawBucket(Bucket bucket, List<DataSource> list, List<DataType> list2) {
        this.mVersionCode = 2;
        this.zzXy = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.zzaCJ = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.zzaCL = bucket.getSession();
        this.zzaDT = bucket.zzxl();
        this.zzaCV = bucket.getBucketType();
        this.zzaCW = bucket.zzxm();
        List<DataSet> list3 = bucket.getDataSets();
        this.zzaCU = new ArrayList<RawDataSet>(list3.size());
        for (DataSet dataSet : list3) {
            this.zzaCU.add(new RawDataSet(dataSet, list, list2));
        }
    }

    public boolean equals(Object object) {
        return this == object || object instanceof RawBucket && this.zza((RawBucket)((Object)object));
    }

    private boolean zza(RawBucket rawBucket) {
        return this.zzXy == rawBucket.zzXy && this.zzaCJ == rawBucket.zzaCJ && this.zzaDT == rawBucket.zzaDT && zzz.equal(this.zzaCU, rawBucket.zzaCU) && this.zzaCV == rawBucket.zzaCV && this.zzaCW == rawBucket.zzaCW;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzXy, this.zzaCJ, this.zzaCV});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("startTime", (Object)this.zzXy).zzg("endTime", (Object)this.zzaCJ).zzg("activity", (Object)this.zzaDT).zzg("dataSets", this.zzaCU).zzg("bucketType", (Object)this.zzaCV).zzg("serverHasMoreData", (Object)this.zzaCW).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzn.zza(this, parcel, n);
    }
}

