/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.zzq;
import java.util.concurrent.TimeUnit;

public class Session
extends AbstractSafeParcelable {
    public static final String EXTRA_SESSION = "vnd.google.fitness.session";
    public static final String MIME_TYPE_PREFIX = "vnd.google.fitness.session/";
    private final int mVersionCode;
    private final long zzXy;
    private final long zzaCJ;
    private final String mName;
    private final String zzaDY;
    private final String zzVw;
    private final int zzaCT;
    private final Application zzaDg;
    private final Long zzaDZ;
    public static final Parcelable.Creator<Session> CREATOR = new zzq();

    Session(int n, long l, long l2, String string, String string2, String string3, int n2, Application application, Long l3) {
        this.mVersionCode = n;
        this.zzXy = l;
        this.zzaCJ = l2;
        this.mName = string;
        this.zzaDY = string2;
        this.zzVw = string3;
        this.zzaCT = n2;
        this.zzaDg = application;
        this.zzaDZ = l3;
    }

    public Session(long l, long l2, String string, String string2, String string3, int n, Application application, Long l3) {
        this(3, l, l2, string, string2, string3, n, application, l3);
    }

    private Session(Builder builder) {
        this(builder.zzXy, builder.zzaCJ, builder.mName, builder.zzaDY, builder.zzVw, builder.zzaCT, Builder.zzg(builder), builder.zzaDZ);
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (Session)zzc.zza((Intent)intent, (String)EXTRA_SESSION, CREATOR);
    }

    public static String getMimeType(String string) {
        String string2 = String.valueOf(MIME_TYPE_PREFIX);
        String string3 = String.valueOf(string);
        return string3.length() != 0 ? string2.concat(string3) : new String(string2);
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzXy, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaCJ, TimeUnit.MILLISECONDS);
    }

    public long getActiveTime(TimeUnit timeUnit) {
        zzaa.zza((this.zzaDZ != null ? 1 : 0) != 0, (Object)"Active time is not set");
        return timeUnit.convert(this.zzaDZ, TimeUnit.MILLISECONDS);
    }

    public boolean hasActiveTime() {
        return this.zzaDZ != null;
    }

    public boolean isOngoing() {
        return this.zzaCJ == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.zzaDY;
    }

    public String getDescription() {
        return this.zzVw;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzaCT);
    }

    public int zzxl() {
        return this.zzaCT;
    }

    public Application zzxw() {
        return this.zzaDg;
    }

    public String getAppPackageName() {
        return this.zzaDg == null ? null : this.zzaDg.getPackageName();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Session && this.zza((Session)((Object)object));
    }

    private boolean zza(Session session) {
        return this.zzXy == session.zzXy && this.zzaCJ == session.zzaCJ && zzz.equal((Object)this.mName, (Object)session.mName) && zzz.equal((Object)this.zzaDY, (Object)session.zzaDY) && zzz.equal((Object)this.zzVw, (Object)session.zzVw) && zzz.equal((Object)((Object)this.zzaDg), (Object)((Object)session.zzaDg)) && this.zzaCT == session.zzaCT;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzXy, this.zzaCJ, this.zzaDY});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("startTime", (Object)this.zzXy).zzg("endTime", (Object)this.zzaCJ).zzg("name", (Object)this.mName).zzg("identifier", (Object)this.zzaDY).zzg("description", (Object)this.zzVw).zzg("activity", (Object)this.zzaCT).zzg("application", (Object)this.zzaDg).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzoq() {
        return this.zzXy;
    }

    public long zzxn() {
        return this.zzaCJ;
    }

    public Long zzxG() {
        return this.zzaDZ;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzq.zza(this, parcel, n);
    }

    public static class Builder {
        private long zzXy = 0L;
        private long zzaCJ = 0L;
        private String mName = null;
        private String zzaDY;
        private String zzVw;
        private int zzaCT = 4;
        private Long zzaDZ;

        public Builder setStartTime(long l, TimeUnit timeUnit) {
            zzaa.zza((l > 0L ? 1 : 0) != 0, (Object)"Start time should be positive.");
            this.zzXy = timeUnit.toMillis(l);
            return this;
        }

        public Builder setEndTime(long l, TimeUnit timeUnit) {
            zzaa.zza((l >= 0L ? 1 : 0) != 0, (Object)"End time should be positive.");
            this.zzaCJ = timeUnit.toMillis(l);
            return this;
        }

        public Builder setName(String string) {
            zzaa.zzb((string.length() <= 100 ? 1 : 0) != 0, (String)"Session name cannot exceed %d characters", (Object[])new Object[]{100});
            this.mName = string;
            return this;
        }

        public Builder setIdentifier(String string) {
            zzaa.zzaj((string != null && TextUtils.getTrimmedLength((CharSequence)string) > 0 ? 1 : 0) != 0);
            this.zzaDY = string;
            return this;
        }

        public Builder setDescription(String string) {
            zzaa.zzb((string.length() <= 1000 ? 1 : 0) != 0, (String)"Session description cannot exceed %d characters", (Object[])new Object[]{1000});
            this.zzVw = string;
            return this;
        }

        public Builder setActivity(String string) {
            return this.zzfq(FitnessActivities.zzdN(string));
        }

        public Builder zzfq(int n) {
            this.zzaCT = n;
            return this;
        }

        public Builder setActiveTime(long l, TimeUnit timeUnit) {
            this.zzaDZ = timeUnit.toMillis(l);
            return this;
        }

        public Session build() {
            zzaa.zza((this.zzXy > 0L ? 1 : 0) != 0, (Object)"Start time should be specified.");
            zzaa.zza((this.zzaCJ == 0L || this.zzaCJ > this.zzXy ? 1 : 0) != 0, (Object)"End time should be later than start time.");
            if (this.zzaDY == null) {
                String string = this.mName == null ? "" : this.mName;
                long l = this.zzXy;
                this.zzaDY = new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString();
            }
            return new Session(this);
        }

        static /* synthetic */ Application zzg(Builder builder) {
            return null;
        }
    }
}

