/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zzrc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final String mName;
    private final List<Field> zzaDs;
    private final zzrc zzaHN;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new zzi();

    DataTypeCreateRequest(int n, String string, List<Field> list, IBinder iBinder) {
        this.mVersionCode = n;
        this.mName = string;
        this.zzaDs = Collections.unmodifiableList(list);
        this.zzaHN = zzrc.zza.zzbM(iBinder);
    }

    private DataTypeCreateRequest(Builder builder) {
        this(builder.mName, builder.zzaDs, null);
    }

    public DataTypeCreateRequest(DataTypeCreateRequest dataTypeCreateRequest, zzrc zzrc2) {
        this(dataTypeCreateRequest.mName, dataTypeCreateRequest.zzaDs, zzrc2);
    }

    public DataTypeCreateRequest(String string, List<Field> list, zzrc zzrc2) {
        this.mVersionCode = 3;
        this.mName = string;
        this.zzaDs = Collections.unmodifiableList(list);
        this.zzaHN = zzrc2;
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.zzaDs;
    }

    public IBinder getCallbackBinder() {
        return this.zzaHN == null ? null : this.zzaHN.asBinder();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DataTypeCreateRequest && this.zzb((DataTypeCreateRequest)((Object)object));
    }

    private boolean zzb(DataTypeCreateRequest dataTypeCreateRequest) {
        return zzz.equal((Object)this.mName, (Object)dataTypeCreateRequest.mName) && zzz.equal(this.zzaDs, dataTypeCreateRequest.zzaDs);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.mName, this.zzaDs});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("name", (Object)this.mName).zzg("fields", this.zzaDs).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }

    public static class Builder {
        private String mName;
        private List<Field> zzaDs = new ArrayList<Field>();

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.zzaDs.contains((Object)field)) {
                this.zzaDs.add(field);
            }
            return this;
        }

        public Builder addField(String string, int n) {
            zzaa.zzb((string != null && !string.isEmpty() ? 1 : 0) != 0, (Object)"Invalid name specified");
            Field field = Field.zzl(string, n);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            zzaa.zza((this.mName != null ? 1 : 0) != 0, (Object)"Must set the name");
            zzaa.zza((!this.zzaDs.isEmpty() ? 1 : 0) != 0, (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

