/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzx;
import com.google.android.gms.internal.zzql;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzrp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final Session zzaCL;
    private final List<DataSet> zzaCU;
    private final List<DataPoint> zzaIf;
    private final zzrp zzaHq;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzx();

    SessionInsertRequest(int n, Session session, List<DataSet> list, List<DataPoint> list2, IBinder iBinder) {
        this.mVersionCode = n;
        this.zzaCL = session;
        this.zzaCU = Collections.unmodifiableList(list);
        this.zzaIf = Collections.unmodifiableList(list2);
        this.zzaHq = zzrp.zza.zzbZ(iBinder);
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzaCL, builder.zzaCU, builder.zzaIf, null);
    }

    public SessionInsertRequest(SessionInsertRequest sessionInsertRequest, zzrp zzrp2) {
        this(sessionInsertRequest.zzaCL, sessionInsertRequest.zzaCU, sessionInsertRequest.zzaIf, zzrp2);
    }

    public SessionInsertRequest(Session session, List<DataSet> list, List<DataPoint> list2, zzrp zzrp2) {
        this.mVersionCode = 3;
        this.zzaCL = session;
        this.zzaCU = Collections.unmodifiableList(list);
        this.zzaIf = Collections.unmodifiableList(list2);
        this.zzaHq = zzrp2;
    }

    public Session getSession() {
        return this.zzaCL;
    }

    public List<DataSet> getDataSets() {
        return this.zzaCU;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzaIf;
    }

    public IBinder getCallbackBinder() {
        return this.zzaHq == null ? null : this.zzaHq.asBinder();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)((Object)object));
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return zzz.equal((Object)((Object)this.zzaCL), (Object)((Object)sessionInsertRequest.zzaCL)) && zzz.equal(this.zzaCU, sessionInsertRequest.zzaCU) && zzz.equal(this.zzaIf, sessionInsertRequest.zzaIf);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaCL, this.zzaCU, this.zzaIf});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("session", (Object)this.zzaCL).zzg("dataSets", this.zzaCU).zzg("aggregateDataPoints", this.zzaIf).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzx.zza(this, parcel, n);
    }

    public static class Builder {
        private Session zzaCL;
        private List<DataSet> zzaCU = new ArrayList<DataSet>();
        private List<DataPoint> zzaIf = new ArrayList<DataPoint>();
        private List<DataSource> zzaIg = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzaCL = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzaa.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzaa.zza((!this.zzaIg.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            zzaa.zzb((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzaIg.add(dataSource);
            this.zzaCU.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint dataPoint) {
            zzaa.zzb((dataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            DataSource dataSource = dataPoint.getDataSource();
            zzaa.zza((!this.zzaIg.contains((Object)dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            zzqp.zze(dataPoint);
            this.zzaIg.add(dataSource);
            this.zzaIf.add(dataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzaa.zza((this.zzaCL != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzaa.zza((this.zzaCL.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzyn();
            return new SessionInsertRequest(this);
        }

        private void zzf(DataPoint dataPoint) {
            this.zzh(dataPoint);
            this.zzg(dataPoint);
        }

        private void zzg(DataPoint dataPoint) {
            long l = this.zzaCL.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzaCL.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzql.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzaa.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzh(DataPoint dataPoint) {
            long l = this.zzaCL.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzaCL.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzql.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzaa.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzyn() {
            for (DataSet abstractSafeParcelable : this.zzaCU) {
                for (DataPoint dataPoint : abstractSafeParcelable.getDataPoints()) {
                    this.zzf(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzaIf) {
                this.zzf(dataPoint);
            }
        }
    }
}

