/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzad;
import com.google.android.gms.fitness.request.zzq;
import com.google.android.gms.internal.zzrp;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
extends AbstractSafeParcelable {
    private final int mVersionCode;
    private final List<DataType> zzaCS;
    private final zzq zzaIn;
    private final int zzaIo;
    private final zzrp zzaHq;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzad();

    StartBleScanRequest(int n, List<DataType> list, IBinder iBinder, int n2, IBinder iBinder2) {
        this.mVersionCode = n;
        this.zzaCS = list;
        this.zzaIn = zzq.zza.zzcc(iBinder);
        this.zzaIo = n2;
        this.zzaHq = zzrp.zza.zzbZ(iBinder2);
    }

    private StartBleScanRequest(Builder builder) {
        this(zzb.zzb((Object[])builder.zzaHL), builder.zzaIn, builder.zzaIo, null);
    }

    public StartBleScanRequest(StartBleScanRequest startBleScanRequest, zzrp zzrp2) {
        this(startBleScanRequest.zzaCS, startBleScanRequest.zzaIn, startBleScanRequest.zzaIo, zzrp2);
    }

    public StartBleScanRequest(List<DataType> list, zzq zzq2, int n, zzrp zzrp2) {
        this.mVersionCode = 4;
        this.zzaCS = list;
        this.zzaIn = zzq2;
        this.zzaIo = n;
        this.zzaHq = zzrp2;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzaCS);
    }

    public int getTimeoutSecs() {
        return this.zzaIo;
    }

    public IBinder zzyq() {
        return this.zzaIn.asBinder();
    }

    public IBinder getCallbackBinder() {
        return this.zzaHq == null ? null : this.zzaHq.asBinder();
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("dataTypes", this.zzaCS).zzg("timeoutSecs", (Object)this.zzaIo).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzad.zza(this, parcel, n);
    }

    public static class Builder {
        private DataType[] zzaHL = new DataType[0];
        private zzq zzaIn;
        private int zzaIo = 10;

        public Builder setDataTypes(DataType ... dataTypeArray) {
            this.zzaHL = dataTypeArray;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzxT().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzq zzq2) {
            this.zzaIn = zzq2;
            return this;
        }

        public Builder setTimeoutSecs(int n) {
            zzaa.zzb((n > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzaa.zzb((n <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzaIo = n;
            return this;
        }

        public StartBleScanRequest build() {
            zzaa.zza((this.zzaIn != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

