/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.BleDevice;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.result.zza;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BleDevicesResult
extends AbstractSafeParcelable
implements Result {
    private final int mVersionCode;
    private final List<BleDevice> zzaIr;
    private final Status zzaaO;
    public static final Parcelable.Creator<BleDevicesResult> CREATOR = new zza();

    BleDevicesResult(int n, List<BleDevice> list, Status status) {
        this.mVersionCode = n;
        this.zzaIr = Collections.unmodifiableList(list);
        this.zzaaO = status;
    }

    public BleDevicesResult(List<BleDevice> list, Status status) {
        this.mVersionCode = 3;
        this.zzaIr = Collections.unmodifiableList(list);
        this.zzaaO = status;
    }

    public static BleDevicesResult zzU(Status status) {
        return new BleDevicesResult(Collections.emptyList(), status);
    }

    public List<BleDevice> getClaimedBleDevices() {
        return this.zzaIr;
    }

    public List<BleDevice> getClaimedBleDevices(DataType dataType) {
        ArrayList<BleDevice> arrayList = new ArrayList<BleDevice>();
        for (BleDevice bleDevice : this.zzaIr) {
            if (!bleDevice.getDataTypes().contains((Object)dataType)) continue;
            arrayList.add(bleDevice);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Status getStatus() {
        return this.zzaaO;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof BleDevicesResult && this.zzb((BleDevicesResult)((Object)object));
    }

    private boolean zzb(BleDevicesResult bleDevicesResult) {
        return this.zzaaO.equals((Object)bleDevicesResult.zzaaO) && zzz.equal(this.zzaIr, bleDevicesResult.zzaIr);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaaO, this.zzaIr});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("status", (Object)this.zzaaO).zzg("bleDevices", this.zzaIr).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }
}

