/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
extends AbstractSafeParcelable
implements Result {
    private final int mVersionCode;
    private final List<DataSet> zzaCU;
    private final Status zzaaO;
    private final List<Bucket> zzaIs;
    private int zzaIt;
    private final List<DataSource> zzaDe;
    private final List<DataType> zzaIu;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int n, List<RawDataSet> list, Status status, List<RawBucket> list2, int n2, List<DataSource> list3, List<DataType> list4) {
        this.mVersionCode = n;
        this.zzaaO = status;
        this.zzaIt = n2;
        this.zzaDe = list3;
        this.zzaIu = list4;
        this.zzaCU = new ArrayList<DataSet>(list.size());
        for (RawDataSet abstractSafeParcelable : list) {
            this.zzaCU.add(new DataSet(abstractSafeParcelable, list3));
        }
        this.zzaIs = new ArrayList<Bucket>(list2.size());
        for (RawBucket rawBucket : list2) {
            this.zzaIs.add(new Bucket(rawBucket, list3));
        }
    }

    public DataReadResult(List<DataSet> list, List<Bucket> list2, Status status) {
        this.mVersionCode = 5;
        this.zzaCU = list;
        this.zzaaO = status;
        this.zzaIs = list2;
        this.zzaIt = 1;
        this.zzaDe = new ArrayList<DataSource>();
        this.zzaIu = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource abstractSafeParcelable : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(abstractSafeParcelable));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzaCU) {
            if (!dataType.equals((Object)dataSet.getDataType())) continue;
            return dataSet;
        }
        return DataSet.create(new DataSource.Builder().setDataType(dataType).setType(1).build());
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzaCU) {
            if (!dataSource.equals((Object)dataSet.getDataSource())) continue;
            return dataSet;
        }
        return DataSet.create(dataSource);
    }

    public List<DataSet> getDataSets() {
        return this.zzaCU;
    }

    public List<Bucket> getBuckets() {
        return this.zzaIs;
    }

    public int zzyt() {
        return this.zzaIt;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet abstractSafeParcelable : dataReadResult.getDataSets()) {
            this.zza(abstractSafeParcelable, this.zzaCU);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzaIs);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals((Object)dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzaIs.add(bucket);
    }

    public Status getStatus() {
        return this.zzaaO;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataReadResult && this.zzc((DataReadResult)((Object)object));
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzaaO.equals((Object)dataReadResult.zzaaO) && zzz.equal(this.zzaCU, dataReadResult.zzaCU) && zzz.equal(this.zzaIs, dataReadResult.zzaIs);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaaO, this.zzaCU, this.zzaIs});
    }

    public String toString() {
        Object object;
        Object object2;
        int n;
        zzz.zza zza2 = zzz.zzy((Object)((Object)this)).zzg("status", (Object)this.zzaaO);
        if (this.zzaCU.size() > 5) {
            n = this.zzaCU.size();
            object2 = new StringBuilder(21).append(n).append(" data sets").toString();
        } else {
            object2 = this.zzaCU;
        }
        zzz.zza zza3 = zza2.zzg("dataSets", object2);
        if (this.zzaIs.size() > 5) {
            n = this.zzaIs.size();
            object = new StringBuilder(19).append(n).append(" buckets").toString();
        } else {
            object = this.zzaIs;
        }
        return zza3.zzg("buckets", object).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawBucket> zzyu() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzaIs.size());
        for (Bucket bucket : this.zzaIs) {
            arrayList.add(new RawBucket(bucket, this.zzaDe, this.zzaIu));
        }
        return arrayList;
    }

    List<RawDataSet> zzyv() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzaCU.size());
        for (DataSet dataSet : this.zzaCU) {
            arrayList.add(new RawDataSet(dataSet, this.zzaDe, this.zzaIu));
        }
        return arrayList;
    }

    List<DataSource> zzxv() {
        return this.zzaDe;
    }

    List<DataType> zzyw() {
        return this.zzaIu;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }
}

