/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.SessionDataSet;
import com.google.android.gms.fitness.result.zzj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
extends AbstractSafeParcelable
implements Result {
    private final int mVersionCode;
    private final List<Session> zzaHt;
    private final List<SessionDataSet> zzaIB;
    private final Status zzaaO;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzj();

    SessionReadResult(int n, List<Session> list, List<SessionDataSet> list2, Status status) {
        this.mVersionCode = n;
        this.zzaHt = list;
        this.zzaIB = Collections.unmodifiableList(list2);
        this.zzaaO = status;
    }

    public SessionReadResult(List<Session> list, List<SessionDataSet> list2, Status status) {
        this.mVersionCode = 3;
        this.zzaHt = list;
        this.zzaIB = Collections.unmodifiableList(list2);
        this.zzaaO = status;
    }

    public static SessionReadResult zzY(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<SessionDataSet> arrayList2 = new ArrayList<SessionDataSet>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzaHt;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzaa.zzb((boolean)this.zzaHt.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzaIB) {
            if (!zzz.equal((Object)((Object)session), (Object)((Object)sessionDataSet.getSession())) || !dataType.equals((Object)sessionDataSet.getDataSet().getDataType())) continue;
            arrayList.add(sessionDataSet.getDataSet());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzaa.zzb((boolean)this.zzaHt.contains((Object)session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzaIB) {
            if (!zzz.equal((Object)((Object)session), (Object)((Object)sessionDataSet.getSession()))) continue;
            arrayList.add(sessionDataSet.getDataSet());
        }
        return arrayList;
    }

    public List<SessionDataSet> zzyz() {
        return this.zzaIB;
    }

    public Status getStatus() {
        return this.zzaaO;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof SessionReadResult && this.zzb((SessionReadResult)((Object)object));
    }

    private boolean zzb(SessionReadResult sessionReadResult) {
        return this.zzaaO.equals((Object)sessionReadResult.zzaaO) && zzz.equal(this.zzaHt, sessionReadResult.zzaHt) && zzz.equal(this.zzaIB, sessionReadResult.zzaIB);
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaaO, this.zzaHt, this.zzaIB});
    }

    public String toString() {
        return zzz.zzy((Object)((Object)this)).zzg("status", (Object)this.zzaaO).zzg("sessions", this.zzaHt).zzg("sessionDataSets", this.zzaIB).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzj.zza(this, parcel, n);
    }
}

