/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.service;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.internal.service.FitnessDataSourcesRequest;
import com.google.android.gms.fitness.internal.service.FitnessUnregistrationRequest;
import com.google.android.gms.fitness.internal.service.zzc;
import com.google.android.gms.fitness.result.DataSourcesResult;
import com.google.android.gms.fitness.service.FitnessSensorServiceRequest;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.internal.zzrp;
import java.util.List;

public abstract class FitnessSensorService
extends Service {
    public static final String SERVICE_INTERFACE = "com.google.android.gms.fitness.service.FitnessSensorService";
    private zza zzaIC;

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzaIC = new zza(this);
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            if (Log.isLoggable((String)"FitnessSensorService", (int)3)) {
                String string = String.valueOf(intent);
                String string2 = String.valueOf(((Object)((Object)this)).getClass().getName());
                Log.d((String)"FitnessSensorService", (String)new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Intent ").append(string).append(" received by ").append(string2).toString());
            }
            return this.zzaIC.asBinder();
        }
        return null;
    }

    public abstract List<DataSource> onFindDataSources(List<DataType> var1);

    public abstract boolean onRegister(FitnessSensorServiceRequest var1);

    public abstract boolean onUnregister(DataSource var1);

    @TargetApi(value=19)
    protected void zzyB() throws SecurityException {
        int n = Binder.getCallingUid();
        String string = "com.google.android.gms";
        if (zzs.zzve()) {
            AppOpsManager appOpsManager = (AppOpsManager)this.getSystemService("appops");
            appOpsManager.checkPackage(n, "com.google.android.gms");
            return;
        }
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string2.equals("com.google.android.gms")) continue;
                return;
            }
        }
        throw new SecurityException("Unauthorized caller");
    }

    private static class zza
    extends zzc.zza {
        private final FitnessSensorService zzaID;

        private zza(FitnessSensorService fitnessSensorService) {
            this.zzaID = fitnessSensorService;
        }

        @Override
        public void zza(FitnessDataSourcesRequest fitnessDataSourcesRequest, zzrb zzrb2) throws RemoteException {
            this.zzaID.zzyB();
            List<DataSource> list = this.zzaID.onFindDataSources(fitnessDataSourcesRequest.getDataTypes());
            zzrb2.zza(new DataSourcesResult(list, Status.zzalw));
        }

        @Override
        public void zza(FitnessSensorServiceRequest fitnessSensorServiceRequest, zzrp zzrp2) throws RemoteException {
            this.zzaID.zzyB();
            if (this.zzaID.onRegister(fitnessSensorServiceRequest)) {
                zzrp2.zzo(Status.zzalw);
            } else {
                zzrp2.zzo(new Status(13));
            }
        }

        @Override
        public void zza(FitnessUnregistrationRequest fitnessUnregistrationRequest, zzrp zzrp2) throws RemoteException {
            this.zzaID.zzyB();
            if (this.zzaID.onUnregister(fitnessUnregistrationRequest.getDataSource())) {
                zzrp2.zzo(Status.zzalw);
            } else {
                zzrp2.zzo(new Status(13));
            }
        }
    }
}

