/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.internal.zzqm;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqq;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class zzqp {
    private static final Set<String> zzaGq = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(zzqm.zzaEv.name, zzqm.zzaEJ.name)));

    public static String zzd(DataPoint dataPoint) {
        DataType dataType = dataPoint.getDataType();
        if (!zzqn.zzee(dataType.getName())) {
            return null;
        }
        for (Field field : dataType.getFields()) {
            double d;
            Value value = dataPoint.getValue(field);
            if (!value.isSet()) {
                if (zzaGq.contains(field.getName())) continue;
                return String.valueOf(field.getName()).concat(" not set");
            }
            if (field.getFormat() == 1) {
                d = value.asInt();
            } else {
                if (field.getFormat() != 2) continue;
                d = value.asFloat();
            }
            zzqq.zza zza2 = zzqq.zzxQ().zzef(field.getName());
            if (zza2 != null && !zza2.zzh(d)) {
                return "Field out of range";
            }
            zza2 = zzqq.zzxQ().zzI(dataType.getName(), field.getName());
            if (zza2 == null) continue;
            long l = dataPoint.getTimestampNanos() - dataPoint.zzxt();
            if (l == 0L) {
                if (d == 0.0) {
                    return null;
                }
                return "DataPoint out of range";
            }
            double d2 = d / (double)l;
            if (zza2.zzh(d2)) continue;
            return "DataPoint out of range";
        }
        return null;
    }

    public static void zze(DataPoint dataPoint) throws IllegalArgumentException {
        String string = zzqp.zzd(dataPoint);
        if (string != null) {
            String string2 = String.valueOf((Object)dataPoint);
            Log.w((String)"Fitness", (String)new StringBuilder(20 + String.valueOf(string2).length()).append("Invalid data point: ").append(string2).toString());
            throw new IllegalArgumentException(string);
        }
    }
}

