/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DailyTotalRequest;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataInsertRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.request.DataUpdateRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzqu;
import com.google.android.gms.internal.zzqz;
import com.google.android.gms.internal.zzra;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.internal.zzsa;

public class zzrv
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient googleApiClient, DataSet dataSet) {
        return this.zza(googleApiClient, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzaa.zzb((Object)((Object)dataSet), (Object)"Must set the data set");
        zzaa.zza((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"Cannot use an empty data set");
        zzaa.zzb((Object)((Object)dataSet.getDataSource().zzxw()), (Object)"Must set the app package name for the data source");
        return googleApiClient.zzc((zznt.zza)new zzqu.zzc(googleApiClient){

            protected void zza(zzqu zzqu2) throws RemoteException {
                zzsa zzsa2 = new zzsa((zznt.zzb<Status>)this);
                ((zzrf)zzqu2.zztm()).zza(new DataInsertRequest(dataSet, zzsa2, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient googleApiClient, final DataDeleteRequest dataDeleteRequest) {
        return googleApiClient.zzc((zznt.zza)new zzqu.zzc(googleApiClient){

            protected void zza(zzqu zzqu2) throws RemoteException {
                zzsa zzsa2 = new zzsa((zznt.zzb<Status>)this);
                ((zzrf)zzqu2.zztm()).zza(new DataDeleteRequest(dataDeleteRequest, zzsa2));
            }
        });
    }

    @Override
    public PendingResult<Status> updateData(GoogleApiClient googleApiClient, final DataUpdateRequest dataUpdateRequest) {
        zzaa.zzb((Object)((Object)dataUpdateRequest.getDataSet()), (Object)"Must set the data set");
        zzaa.zza((long)dataUpdateRequest.zzoq(), (Object)"Must set a non-zero value for startTimeMillis/startTime");
        zzaa.zza((long)dataUpdateRequest.zzxn(), (Object)"Must set a non-zero value for endTimeMillis/endTime");
        return googleApiClient.zzc((zznt.zza)new zzqu.zzc(googleApiClient){

            protected void zza(zzqu zzqu2) throws RemoteException {
                zzsa zzsa2 = new zzsa((zznt.zzb<Status>)this);
                ((zzrf)zzqu2.zztm()).zza(new DataUpdateRequest(dataUpdateRequest, (IBinder)zzsa2));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient googleApiClient, final DataReadRequest dataReadRequest) {
        return googleApiClient.zzc((zznt.zza)new zzqu.zza<DataReadResult>(googleApiClient){

            protected void zza(zzqu zzqu2) throws RemoteException {
                zza zza2 = new zza((zznt.zzb)this);
                ((zzrf)zzqu2.zztm()).zza(new DataReadRequest(dataReadRequest, zza2));
            }

            protected DataReadResult zzO(Status status) {
                return DataReadResult.zza(status, dataReadRequest);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzO(status);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient googleApiClient, final DataType dataType) {
        return googleApiClient.zzc((zznt.zza)new zzqu.zza<DailyTotalResult>(googleApiClient){

            protected void zza(zzqu zzqu2) throws RemoteException {
                zzqz.zza zza2 = new zzqz.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.zzb(dailyTotalResult);
                    }
                };
                DailyTotalRequest dailyTotalRequest = new DailyTotalRequest(zza2, dataType);
                ((zzrf)zzqu2.zztm()).zza(dailyTotalRequest);
            }

            protected DailyTotalResult zzP(Status status) {
                return DailyTotalResult.zza(status, dataType);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzP(status);
            }
        });
    }

    private static class zza
    extends zzra.zza {
        private final zznt.zzb<DataReadResult> zzasz;
        private int zzaGP = 0;
        private DataReadResult zzaGQ = null;

        private zza(zznt.zzb<DataReadResult> zzb2) {
            this.zzasz = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                if (Log.isLoggable((String)"Fitness", (int)2)) {
                    int n = this.zzaGP;
                    Log.v((String)"Fitness", (String)new StringBuilder(33).append("Received batch result ").append(n).toString());
                }
                if (this.zzaGQ == null) {
                    this.zzaGQ = dataReadResult;
                } else {
                    this.zzaGQ.zzb(dataReadResult);
                }
                ++this.zzaGP;
                if (this.zzaGP == this.zzaGQ.zzyt()) {
                    this.zzasz.setResult((Object)this.zzaGQ);
                }
            }
        }
    }
}

