/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.flags;

import android.os.RemoteException;
import com.google.android.gms.flags.IFlagProvider;
import com.google.android.gms.flags.Singletons;
import com.google.android.gms.flags.zza;

public abstract class Flag<T> {
    private final int zzacb;
    private final String mKey;
    private final T mDefaultValue;

    private Flag(int n, String string, T t) {
        this.zzacb = n;
        this.mKey = string;
        this.mDefaultValue = t;
        Singletons.flagRegistry().registerFlag(this);
    }

    public String getKey() {
        return this.mKey;
    }

    public T getDefault() {
        return this.mDefaultValue;
    }

    public T get() {
        return Singletons.flagValueProvider().getFlagValue(this);
    }

    public static BooleanFlag define(int n, String string, Boolean bl) {
        return new BooleanFlag(n, string, bl);
    }

    public static IntegerFlag define(int n, String string, int n2) {
        return new IntegerFlag(n, string, n2);
    }

    public static LongFlag define(int n, String string, long l) {
        return new LongFlag(n, string, l);
    }

    public static StringFlag define(int n, String string, String string2) {
        return new StringFlag(n, string, string2);
    }

    public static StringFlag defineClientExperimentId(int n, String string) {
        StringFlag stringFlag = Flag.define(n, string, null);
        Singletons.flagRegistry().registerClientExperimentId(stringFlag);
        return stringFlag;
    }

    public static StringFlag defineServiceExperimentId(int n, String string) {
        StringFlag stringFlag = Flag.define(n, string, null);
        Singletons.flagRegistry().registerServiceExperimentId(stringFlag);
        return stringFlag;
    }

    public int getSource() {
        return this.zzacb;
    }

    protected abstract T get(IFlagProvider var1);

    /* synthetic */ Flag(int n, String string, Object object, zza zza2) {
        this(n, string, object);
    }

    public static class StringFlag
    extends Flag<String> {
        public StringFlag(int n, String string, String string2) {
            super(n, string, string2, null);
        }

        @Override
        public String get(IFlagProvider iFlagProvider) {
            try {
                return iFlagProvider.getStringFlagValue(this.getKey(), (String)this.getDefault(), this.getSource());
            }
            catch (RemoteException remoteException) {
                return (String)this.getDefault();
            }
        }
    }

    public static class LongFlag
    extends Flag<Long> {
        public LongFlag(int n, String string, Long l) {
            super(n, string, l, null);
        }

        @Override
        public Long get(IFlagProvider iFlagProvider) {
            try {
                return iFlagProvider.getLongFlagValue(this.getKey(), (Long)this.getDefault(), this.getSource());
            }
            catch (RemoteException remoteException) {
                return (Long)this.getDefault();
            }
        }
    }

    public static class IntegerFlag
    extends Flag<Integer> {
        public IntegerFlag(int n, String string, Integer n2) {
            super(n, string, n2, null);
        }

        @Override
        public Integer get(IFlagProvider iFlagProvider) {
            try {
                return iFlagProvider.getIntFlagValue(this.getKey(), (Integer)this.getDefault(), this.getSource());
            }
            catch (RemoteException remoteException) {
                return (Integer)this.getDefault();
            }
        }
    }

    public static class BooleanFlag
    extends Flag<Boolean> {
        public BooleanFlag(int n, String string, Boolean bl) {
            super(n, string, bl, null);
        }

        @Override
        public Boolean get(IFlagProvider iFlagProvider) {
            try {
                return iFlagProvider.getBooleanFlagValue(this.getKey(), (Boolean)this.getDefault(), this.getSource());
            }
            catch (RemoteException remoteException) {
                return (Boolean)this.getDefault();
            }
        }
    }
}

