/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzbda;
    private final String zzbdb;
    private final String zzbdc;
    private final long zzbdd;
    private final long zzbde;
    private final String zzbdf;
    private final Uri zzbdg;
    private final Uri zzbdh;
    private final PlayerEntity zzbdi;
    private final String zzbdj;
    private final String zzbdk;
    private final String zzbdl;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzbda = leaderboardScore.getRank();
        this.zzbdb = (String)zzac.zzw((Object)leaderboardScore.getDisplayRank());
        this.zzbdc = (String)zzac.zzw((Object)leaderboardScore.getDisplayScore());
        this.zzbdd = leaderboardScore.getRawScore();
        this.zzbde = leaderboardScore.getTimestampMillis();
        this.zzbdf = leaderboardScore.getScoreHolderDisplayName();
        this.zzbdg = leaderboardScore.getScoreHolderIconImageUri();
        this.zzbdh = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzbdi = player == null ? null : (PlayerEntity)player.freeze();
        this.zzbdj = leaderboardScore.getScoreTag();
        this.zzbdk = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzbdl = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzbda;
    }

    @Override
    public String getDisplayRank() {
        return this.zzbdb;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzbdb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDisplayScore() {
        return this.zzbdc;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzbdc, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getRawScore() {
        return this.zzbdd;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzbde;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzbdi == null) {
            return this.zzbdf;
        }
        return this.zzbdi.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzbdi == null) {
            zzg.zzb((String)this.zzbdf, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzbdi.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzbdi == null) {
            return this.zzbdg;
        }
        return this.zzbdi.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzbdi == null) {
            return this.zzbdk;
        }
        return this.zzbdi.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzbdi == null) {
            return this.zzbdh;
        }
        return this.zzbdi.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzbdi == null) {
            return this.zzbdl;
        }
        return this.zzbdi.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzbdi;
    }

    @Override
    public String getScoreTag() {
        return this.zzbdj;
    }

    public LeaderboardScore zzFB() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzaa.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzaa.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzaa.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzaa.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzaa.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzaa.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzaa.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzaa.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzaa.zzv((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzFB();
    }
}

