/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzbcV;
    private final String zzaiX;
    private final Uri zzaWW;
    private final int zzbcW;
    private final ArrayList<LeaderboardVariantEntity> zzbcX;
    private final Game zzbcY;
    private final String zzaXh;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzbcV = leaderboard.getLeaderboardId();
        this.zzaiX = leaderboard.getDisplayName();
        this.zzaWW = leaderboard.getIconImageUri();
        this.zzaXh = leaderboard.getIconImageUrl();
        this.zzbcW = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzbcY = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzbcX = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbcX.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.zzbcV;
    }

    @Override
    public String getDisplayName() {
        return this.zzaiX;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaiX, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaWW;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaXh;
    }

    @Override
    public int getScoreOrder() {
        return this.zzbcW;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzbcX);
    }

    @Override
    public Game getGame() {
        return this.zzbcY;
    }

    public Leaderboard zzFz() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return zzaa.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzaa.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzaa.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzaa.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzaa.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzaa.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzaa.zzv((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzFz();
    }
}

