/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.games.video.VideoConfigurationCreator;

public final class VideoConfiguration
extends zza {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new VideoConfigurationCreator();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int mVersionCode;
    private final int zzbft;
    private final int zzbfm;
    private final String zzbfu;
    private final String zzbfv;
    private final String zzbfw;
    private final String zzbfx;
    private final boolean zzbfy;

    private VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        this(2, n, n2, string, string2, string3, string4, bl);
    }

    public VideoConfiguration(int n, int n2, int n3, String string, String string2, String string3, String string4, boolean bl) {
        this.mVersionCode = n;
        zzac.zzas((boolean)VideoConfiguration.isValidQualityLevel(n2, false));
        zzac.zzas((boolean)VideoConfiguration.isValidCaptureMode(n3, false));
        this.zzbft = n2;
        this.zzbfm = n3;
        this.zzbfy = bl;
        if (n3 == 1) {
            this.zzbfv = string2;
            this.zzbfu = string;
            this.zzbfw = string3;
            this.zzbfx = string4;
        } else {
            zzac.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
            zzac.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
            zzac.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
            zzac.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
            this.zzbfv = null;
            this.zzbfu = null;
            this.zzbfw = null;
            this.zzbfx = null;
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getQualityLevel() {
        return this.zzbft;
    }

    public int getCaptureMode() {
        return this.zzbfm;
    }

    public String zzFR() {
        return this.zzbfv;
    }

    public String getStreamUrl() {
        return this.zzbfu;
    }

    public String zzFS() {
        return this.zzbfw;
    }

    public String zzFT() {
        return this.zzbfx;
    }

    public boolean zzFU() {
        return this.zzbfy;
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoConfigurationCreator.zza(this, parcel, n);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzbft;
        private int zzbfm;
        private boolean zzbfy;
        private String zzbfu;
        private String zzbfv;
        private String zzbfw;
        private String zzbfx;

        public Builder(int n, int n2) {
            this.zzbft = n;
            this.zzbfm = n2;
            this.zzbfy = true;
            this.zzbfu = null;
            this.zzbfv = null;
            this.zzbfw = null;
            this.zzbfx = null;
        }

        public Builder setQualityLevel(int n) {
            this.zzbft = n;
            return this;
        }

        public Builder setCaptureMode(int n) {
            this.zzbfm = n;
            return this;
        }

        public VideoConfiguration build() {
            return new VideoConfiguration(this.zzbft, this.zzbfm, null, null, null, null, this.zzbfy);
        }
    }
}

