/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.AbstractGamesClient;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.PopupLocationInfoParcelable;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.game.GameSearchSuggestionBuffer;
import com.google.android.gms.games.internal.player.ProfileSettingsEntity;
import com.google.android.gms.games.internal.player.StockProfileImageBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.social.OnSocialInviteUpdateReceivedListener;
import com.google.android.gms.games.social.Social;
import com.google.android.gms.games.social.SocialInvite;
import com.google.android.gms.games.social.SocialInviteBuffer;
import com.google.android.gms.games.social.SocialInviteEntity;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.PlayerStatsEntity;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoBuffer;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.VideoConfiguration;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzaaf;
import com.google.android.gms.internal.zzaag;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzaxy;
import com.google.android.gms.internal.zzzv;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends zzl<IGamesService> {
    EventIncrementManager zzaYP = new EventIncrementManager(){

        @Override
        public EventIncrementCache zzEz() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String zzaYQ;
    private PlayerEntity zzaYR;
    private GameEntity zzaYS;
    private final PopupManager zzaYT;
    private boolean zzaYU = false;
    private final Binder zzaYV;
    private final long zzaYW;
    private final Games.GamesOptions zzaYX;

    public GamesClientImpl(Context context, Looper looper, zzg zzg2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzaYQ = zzg2.zzxh();
        this.zzaYV = new Binder();
        this.zzaYT = PopupManager.zza(this, zzg2.zzxd());
        this.zzaYW = ((Object)((Object)this)).hashCode();
        this.zzaYX = gamesOptions;
        this.zzv(zzg2.zzxj());
    }

    public boolean zzqD() {
        return true;
    }

    public void zza(@NonNull IGamesService iGamesService) {
        super.zza((IInterface)iGamesService);
        if (this.zzaYU) {
            this.zzaYT.zzEN();
            this.zzaYU = false;
        }
        this.zzb(iGamesService);
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzaYU = false;
    }

    public void zziy(int n) {
        this.zzaYT.setGravity(n);
    }

    public void zzv(View view) {
        this.zzaYT.zzw(view);
    }

    protected Set<Scope> zzc(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            zzac.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            zzac.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public void zza(zzf.zzf zzf2) {
        this.zzEa();
        super.zza(zzf2);
    }

    public void disconnect() {
        this.zzaYU = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.zzwW();
                iGamesService.zzEy();
                this.zzaYP.flush();
                iGamesService.zzM(this.zzaYW);
            }
            catch (RemoteException remoteException) {
                GamesLog.zzE("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected String zzeu() {
        return "com.google.android.gms.games.service.START";
    }

    protected String zzev() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService zzcP(IBinder iBinder) {
        return IGamesService.Stub.zzcS(iBinder);
    }

    public Bundle zzud() {
        try {
            Bundle bundle = ((IGamesService)this.zzwW()).zzud();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return null;
        }
    }

    private void zzEa() {
        this.zzaYR = null;
        this.zzaYS = null;
    }

    protected Bundle zzql() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzaYX.zzDb();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzaYQ);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzaYT.zzEP()));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 4);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzaxy.zza((zzg)this.zzxp()));
        return bundle;
    }

    public void zzb(IGamesService iGamesService) {
        try {
            PopupLocationInfoBinderCallbacks popupLocationInfoBinderCallbacks = new PopupLocationInfoBinderCallbacks(this.zzaYT);
            iGamesService.zza(popupLocationInfoBinderCallbacks, this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public String zzEb() {
        try {
            return ((IGamesService)this.zzwW()).zzEb();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return null;
        }
    }

    public void zzf(zzzv.zzb<Games.GetTokenResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzj(new GetAuthTokenBinderCallbacks(zzb2));
    }

    public void zzb(String string, zzzv.zzb<Games.GetServerAuthCodeResult> zzb2) throws RemoteException {
        zzac.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((IGamesService)this.zzwW()).zza(string, new GetServerAuthCodeBinderCallbacks(zzb2));
    }

    public String zzax(boolean bl) {
        if (bl && this.zzaYR != null) {
            return this.zzaYR.getPlayerId();
        }
        try {
            return ((IGamesService)this.zzwW()).zzEA();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player zzEc() {
        this.zzwV();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaYR == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.zzwW()).zzEB());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzaYR = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzd(remoteException);
                }
            }
        }
        return this.zzaYR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game zzEd() {
        this.zzwV();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzaYS == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.zzwW()).zzED());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzaYS = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    this.zzd(remoteException);
                }
            }
        }
        return this.zzaYS;
    }

    public void zza(zzzv.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzf((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzzv.zzb<Players.LoadPlayersResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), stringArray);
    }

    public void zza(zzzv.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zza(zzzv.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzwW()).zzd(new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zza(zzzv.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "circled": 
            case "connected_1p": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                String string3 = String.valueOf(string);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid player collection: ".concat(string3) : new String("Invalid player collection: "));
            }
        }
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zza(zzzv.zzb<Players.LoadPlayersResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), bl);
    }

    public Intent zzEe() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzEe();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzl(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzm(string, n, n2);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzb(zzzv.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), bl);
    }

    public void zzb(zzzv.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzzv.zzb<Leaderboards.LoadPlayerScoreResult> zzb2, String string, String string2, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(zzb2), string, string2, n, n2);
    }

    public void zza(zzzv.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zzb(zzzv.zzb<Leaderboards.LoadScoresResult> zzb2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, n, n2, n3, bl);
    }

    public void zza(zzzv.zzb<Leaderboards.LoadScoresResult> zzb2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), leaderboardScoreBuffer.zzFA().asBundle(), n, n2);
    }

    public void zza(zzzv.zzb<Leaderboards.SubmitScoreResult> zzb2, String string, long l, String string2) throws RemoteException {
        SubmitScoreBinderCallbacks submitScoreBinderCallbacks = zzb2 == null ? null : new SubmitScoreBinderCallbacks(zzb2);
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)submitScoreBinderCallbacks, string, l, string2);
    }

    public Intent zzEf() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzEf();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzc(zzzv.zzb<Achievements.LoadAchievementsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzzv.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaYT.zzEP(), this.zzaYT.zzEO());
    }

    public void zzb(zzzv.zzb<Achievements.UpdateAchievementResult> zzb2, String string) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.zzaYT.zzEP(), this.zzaYT.zzEO());
    }

    public void zza(zzzv.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaYT.zzEP(), this.zzaYT.zzEO());
    }

    public void zzb(zzzv.zzb<Achievements.UpdateAchievementResult> zzb2, String string, int n) throws RemoteException {
        AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = zzb2 == null ? null : new AchievementUpdatedBinderCallback(zzb2);
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)achievementUpdatedBinderCallback, string, n, this.zzaYT.zzEP(), this.zzaYT.zzEO());
    }

    public void zzd(zzzv.zzb<Events.LoadEventsResult> zzb2, boolean bl) throws RemoteException {
        this.zzaYP.flush();
        ((IGamesService)this.zzwW()).zzf((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzzv.zzb<Events.LoadEventsResult> zzb2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzaYP.flush();
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new EventsLoadedBinderCallback(zzb2), bl, stringArray);
    }

    public void zzo(String string, int n) {
        this.zzaYP.zzo(string, n);
    }

    public Intent zzEg() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzEg();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzEh() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzEh();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzaaz<OnInvitationReceivedListener> zzaaz2) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(zzaaz2);
            ((IGamesService)this.zzwW()).zza((IGamesCallbacks)invitationReceivedBinderCallback, this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzEi() {
        try {
            ((IGamesService)this.zzwW()).zzN(this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzb(zzaaz<OnTurnBasedMatchUpdateReceivedListener> zzaaz2) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(zzaaz2);
            ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzEj() {
        try {
            ((IGamesService)this.zzwW()).zzO(this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzc(zzaaz<QuestUpdateListener> zzaaz2) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(zzaaz2);
            ((IGamesService)this.zzwW()).zzd((IGamesCallbacks)questUpdateBinderCallback, this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzEk() {
        try {
            ((IGamesService)this.zzwW()).zzQ(this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzd(zzaaz<OnRequestReceivedListener> zzaaz2) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(zzaaz2);
            ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)requestReceivedBinderCallback, this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzEl() {
        try {
            ((IGamesService)this.zzwW()).zzP(this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzEm() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzEm();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzEn() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzEn();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzg(zzzv.zzb<GamesMetadata.LoadGamesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzd(new GamesLoadedBinderCallback(zzb2));
    }

    public void zzh(zzzv.zzb<Status> zzb2) throws RemoteException {
        this.zzaYP.flush();
        ((IGamesService)this.zzwW()).zza(new SignOutCompleteBinderCallbacks(zzb2));
    }

    public int zzEo() {
        int n = 4368;
        try {
            n = ((IGamesService)this.zzwW()).zzEo();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public String zzjI() {
        try {
            return ((IGamesService)this.zzwW()).zzjI();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return null;
        }
    }

    public void zza(zzzv.zzb<Invitations.LoadInvitationsResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), n);
    }

    public void zzp(String string, int n) {
        try {
            ((IGamesService)this.zzwW()).zzp(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzq(String string, int n) {
        try {
            ((IGamesService)this.zzwW()).zzq(string, n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzzv.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzFG(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public void zzc(zzzv.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzk((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public void zzd(zzzv.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzl((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string);
    }

    public int zzEp() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzwW()).zzEp();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public void zza(zzzv.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, string2, participantResultArray);
    }

    public void zza(zzzv.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(zzb2), string, byArray, participantResultArray);
    }

    public void zze(zzzv.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzn(new TurnBasedMatchLeftBinderCallbacks(zzb2), string);
    }

    public void zza(zzzv.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzzv.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzm((IGamesCallbacks)new TurnBasedMatchCanceledBinderCallbacks(zzb2), string);
    }

    public void zzeq(String string) {
        try {
            ((IGamesService)this.zzwW()).zzey(string);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zza(zzzv.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), n, nArray);
    }

    public void zzg(zzzv.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzo(new TurnBasedMatchLoadedBinderCallbacks(zzb2), string);
    }

    public Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zza(zzaaz<RoomUpdateListener> zzaaz2, zzaaz<RoomStatusUpdateListener> zzaaz3, zzaaz<RealTimeMessageReceivedListener> zzaaz4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzaaz2, zzaaz3, zzaaz4);
            ((IGamesService)this.zzwW()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaYV, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzb(zzaaz<RoomUpdateListener> zzaaz2, zzaaz<RoomStatusUpdateListener> zzaaz3, zzaaz<RealTimeMessageReceivedListener> zzaaz4, RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(zzaaz2, zzaaz3, zzaaz4);
            ((IGamesService)this.zzwW()).zza((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.zzaYV, roomConfig.getInvitationId(), false, this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zza(zzaaz<RoomUpdateListener> zzaaz2, String string) {
        try {
            ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)new RoomBinderCallbacks(zzaaz2), string);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public int zza(zzaaz<RealTimeMultiplayer.ReliableMessageSentCallback> zzaaz2, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(zzaaz2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return -1;
        }
    }

    public int zza(byte[] byArray, String string, String[] stringArray) {
        zzac.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.zzwW()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return -1;
        }
    }

    public int zze(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.zzwW()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            return -1;
        }
    }

    public void zziz(int n) {
        try {
            ((IGamesService)this.zzwW()).zziz(n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public Intent zzEq() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzEq();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zza(n, byArray, n2, string);
            zzac.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public int zzEr() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzwW()).zzEr();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public int zzEs() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzwW()).zzEs();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public void zzb(zzzv.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zzc(zzzv.zzb<Requests.UpdateRequestsResult> zzb2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), stringArray);
    }

    public void zza(zzzv.zzb<Requests.LoadRequestsResult> zzb2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), n, n2, n3);
    }

    public void zza(zzzv.zzb<AppContents.LoadAppContentResult> zzb2, int n, String string, String[] stringArray, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new AppContentLoadedBinderCallbacks(zzb2), n, string, stringArray, bl);
    }

    public void zze(zzzv.zzb<Stats.LoadPlayerStatsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzi((IGamesCallbacks)new PlayerStatsLoadedBinderCallbacks(zzb2), bl);
    }

    public Intent zzc(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzc(nArray);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public Intent zzer(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzer(string);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzh(zzzv.zzb<Quests.AcceptQuestResult> zzb2, String string) throws RemoteException {
        this.zzaYP.flush();
        ((IGamesService)this.zzwW()).zzt(new QuestAcceptedBinderCallbacks(zzb2), string);
    }

    public void zzb(zzzv.zzb<Quests.ClaimMilestoneResult> zzb2, String string, String string2) throws RemoteException {
        this.zzaYP.flush();
        ((IGamesService)this.zzwW()).zzf((IGamesCallbacks)new QuestMilestoneClaimBinderCallbacks(zzb2, string2), string, string2);
    }

    public void zza(zzzv.zzb<Quests.LoadQuestsResult> zzb2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaYP.flush();
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), nArray, n, bl);
    }

    public void zzb(zzzv.zzb<Quests.LoadQuestsResult> zzb2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaYP.flush();
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), stringArray, bl);
    }

    public void zzes(String string) {
        try {
            ((IGamesService)this.zzwW()).zza(string, this.zzaYT.zzEP(), this.zzaYT.zzEO());
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zza(zzzv.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzaYP.flush();
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, nArray, n, bl);
    }

    public void zza(zzzv.zzb<Quests.LoadQuestsResult> zzb2, String string, String string2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzaYP.flush();
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new QuestsLoadedBinderCallbacks(zzb2), string, string2, stringArray, bl);
    }

    public int zzEt() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzwW()).zzEt();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public int zzEu() {
        int n = -1;
        try {
            n = ((IGamesService)this.zzwW()).zzEu();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return n;
    }

    public Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzf(zzzv.zzb<Snapshots.LoadSnapshotsResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzd((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), bl);
    }

    public void zza(zzzv.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, boolean bl, int n) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, bl, n);
    }

    public void zza(zzzv.zzb<Snapshots.CommitSnapshotResult> zzb2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzac.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzFL();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzzB();
        snapshotContents.close();
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(zzb2), snapshot.getMetadata().getSnapshotId(), (SnapshotMetadataChangeEntity)snapshotMetadataChange, zzc2);
    }

    public void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        zzac.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzzB();
        snapshotContents.close();
        try {
            ((IGamesService)this.zzwW()).zza(zzc2);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzi(zzzv.zzb<Snapshots.DeleteSnapshotResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzq(new SnapshotDeletedBinderCallbacks(zzb2), string);
    }

    public void zza(zzzv.zzb<Snapshots.OpenSnapshotResult> zzb2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        zzac.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzFL();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzd(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzzB();
        snapshotContents.close();
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(zzb2), string, string2, (SnapshotMetadataChangeEntity)snapshotMetadataChange, zzc2);
    }

    public void zzi(zzzv.zzb<Videos.CaptureCapabilitiesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzl(new CaptureCapabilitiesBinderCallback(zzb2));
    }

    public Intent zzEv() {
        Intent intent;
        try {
            intent = ((IGamesService)this.zzwW()).zzEJ();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public void zzj(zzzv.zzb<Videos.CaptureStateResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzv(new CaptureStateBinderCallbacks(zzb2));
    }

    public void zzk(zzzv.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzs(new CaptureStreamingAvailabilityBinderCallback(zzb2));
    }

    public void zzl(zzzv.zzb<Videos.CaptureStreamingMetadataResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzq(new CaptureStreamingMetadataBinderCallback(zzb2));
    }

    public void zzm(zzzv.zzb<Videos.CaptureStreamingUrlResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzr(new CaptureStreamingUrlBinderCallback(zzb2));
    }

    public void zzn(zzzv.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzt(new HeadlessCaptureEnabledBinderCallback(zzb2));
    }

    public void zzb(zzzv.zzb<Videos.CaptureAvailableResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)new CaptureAvailableBinderCallback(zzb2), n);
    }

    public boolean zzEw() {
        boolean bl = false;
        try {
            bl = ((IGamesService)this.zzwW()).zzEw();
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
        return bl;
    }

    public void zzo(zzzv.zzb<Status> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzo(new CaptureStreamingEnabledBinderCallback(zzb2));
    }

    public void zza(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl, String string, VideoConfiguration videoConfiguration) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new CaptureLaunchGameAndOverlayBinderCallback(baseGamesApiMethodImpl), string, videoConfiguration);
    }

    public void zzp(zzzv.zzb<Videos.ListVideosResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzk(new ListVideosBinderCallback(zzb2));
    }

    public void zzc(zzzv.zzb<Videos.ListVideosResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzwW()).zzd((IGamesCallbacks)new ListVideosBinderCallback(zzb2), string, n);
    }

    public void zze(zzaaz<Videos.CaptureOverlayStateListener> zzaaz2) {
        try {
            CaptureOverlayStateBinderCallback captureOverlayStateBinderCallback = new CaptureOverlayStateBinderCallback(zzaaz2);
            ((IGamesService)this.zzwW()).zzf((IGamesCallbacks)captureOverlayStateBinderCallback, this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzg(zzzv.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzm((IGamesCallbacks)new CapturePausedBinderCallback(zzb2), bl);
    }

    public void zza(zzzv.zzb<Status> zzb2, VideoConfiguration videoConfiguration, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new CaptureStartedBinderCallbacks(zzb2, captureRuntimeErrorCallback), videoConfiguration);
    }

    public void zzq(zzzv.zzb<Videos.CaptureStoppedResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzu(new CaptureStoppedBinderCallbacks(zzb2));
    }

    public void zzEx() {
        try {
            ((IGamesService)this.zzwW()).zzT(this.zzaYW);
        }
        catch (RemoteException remoteException) {
            this.zzd(remoteException);
        }
    }

    public void zzc(zzzv.zzb<Status> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzh(new UpdateHeadlessCapturePermissionBinderCallback(zzb2), string, bl);
    }

    public void zzj(zzzv.zzb<GamesMetadata.LoadGameInstancesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzf((IGamesCallbacks)new GameInstancesLoadedBinderCallback(zzb2), string);
    }

    public void zzk(zzzv.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzp(new GameSearchSuggestionsLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzzv.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzd((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, bl);
    }

    public void zza(zzzv.zzb<Leaderboards.LeaderboardMetadataResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zza(zzzv.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzzv.zzb<Leaderboards.LoadScoresResult> zzb2, String string, String string2, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb(new LeaderboardScoresLoadedBinderCallback(zzb2), string, string2, n, n2, n3, bl);
    }

    public void zzb(zzzv.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzc(zzzv.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzd(zzzv.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzwW()).zze(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzb(zzzv.zzb<Players.LoadPlayersResult> zzb2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, n, bl, bl2);
    }

    public void zzb(zzzv.zzb<Players.LoadPlayersResult> zzb2, String string, String string2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), string, string2, n, bl, bl2);
    }

    public void zzl(zzzv.zzb<Players.LoadXpForGameCategoriesResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzr(new PlayerXpForGameCategoriesLoadedBinderCallback(zzb2), string);
    }

    public void zzd(zzzv.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zze(zzzv.zzb<Players.LoadXpStreamResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(zzb2), string, n);
    }

    public void zza(zzzv.zzb<Players.LoadProfileSettingsResult> zzb2, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(zzb2), bl, bl2);
    }

    public void zzh(zzzv.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzh((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(zzb2), bl);
    }

    public void zza(zzzv.zzb<Players.LoadPlayersResult> zzb2, Account account) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new PlayersLoadedBinderCallback(zzb2), account);
    }

    public void zzr(zzzv.zzb<Players.LoadStockProfileImagesResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzp(new StockProfileImagesLoadedBinderCallback(zzb2));
    }

    public void zza(zzzv.zzb<Players.UpdateGamerProfileResult> zzb2, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new GamerProfileUpdatedBinderCallback(zzb2), string, bl, string2, bl2, bl3);
    }

    public void zzi(zzzv.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzj((IGamesCallbacks)new DeletePlayerBinderCallback(zzb2), bl);
    }

    public void zzj(zzzv.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzk((IGamesCallbacks)new UpdateAutoSignInBinderCallback(zzb2), bl);
    }

    public void zzk(zzzv.zzb<Status> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzl((IGamesCallbacks)new UpdateProfileDiscoverabilityBinderCallback(zzb2), bl);
    }

    public void zzb(zzzv.zzb<Achievements.LoadAchievementsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new AchievementsLoadedBinderCallback(zzb2), string, string2, bl);
    }

    public void zzc(zzzv.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzd((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzd(zzzv.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2, String string, String string2) throws RemoteException {
        ((IGamesService)this.zzwW()).zze((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(zzb2), string, string2);
    }

    public void zzf(zzzv.zzb<Invitations.LoadInvitationsResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string, n, false);
    }

    public void zzm(zzzv.zzb<Invitations.LoadInvitationsResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzj((IGamesCallbacks)new InvitationsLoadedBinderCallback(zzb2), string);
    }

    public void zza(zzzv.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2, String string, int n, int[] nArray) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(zzb2), string, n, nArray);
    }

    public void zze(zzzv.zzb<Notifications.GameMuteStatusChangeResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(zzb2), string, bl);
    }

    public void zzn(zzzv.zzb<Notifications.GameMuteStatusLoadResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzi((IGamesCallbacks)new GameMuteStatusLoadedBinderCallback(zzb2), string);
    }

    public void zzl(zzzv.zzb<Notifications.ContactSettingLoadResult> zzb2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zze((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(zzb2), bl);
    }

    public void zza(zzzv.zzb<Status> zzb2, boolean bl, boolean bl2, Bundle bundle) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(zzb2), bl, bl2, bundle);
    }

    public void zzs(zzzv.zzb<Notifications.InboxCountResult> zzb2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzs(new InboxCountsLoadedBinderCallback(zzb2), null);
    }

    public void zza(zzzv.zzb<Requests.SendRequestResult> zzb2, String string, String[] stringArray, int n, byte[] byArray, int n2) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new RequestSentBinderCallbacks(zzb2), string, stringArray, n, byArray, n2);
    }

    public void zza(zzzv.zzb<Requests.UpdateRequestsResult> zzb2, String string, String string2, String[] stringArray) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(zzb2), string, string2, stringArray);
    }

    public void zza(zzzv.zzb<Requests.LoadRequestsResult> zzb2, String string, String string2, int n, int n2, int n3) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new RequestsLoadedBinderCallbacks(zzb2), string, string2, n, n2, n3);
    }

    public void zzg(zzzv.zzb<Requests.LoadRequestSummariesResult> zzb2, String string, int n) throws RemoteException {
        ((IGamesService)this.zzwW()).zza((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(zzb2), string, n);
    }

    public void zzc(zzzv.zzb<Snapshots.LoadSnapshotsResult> zzb2, String string, String string2, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzc((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(zzb2), string, string2, bl);
    }

    public void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzwW()).zza(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                this.zzd(remoteException);
            }
        }
    }

    public void zzEy() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.zzwW()).zzEy();
            }
            catch (RemoteException remoteException) {
                this.zzd(remoteException);
            }
        }
    }

    private void zzd(RemoteException remoteException) {
        GamesLog.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzai(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzaYU = bundle.getBoolean("show_welcome_popup");
            this.zzaYR = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzaYS = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public void zzo(zzzv.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzu(new SendFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzp(zzzv.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzv(new AcceptFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzq(zzzv.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzw(new IgnoreFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zzr(zzzv.zzb<Social.InviteUpdateResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzx(new CancelFriendInviteFirstPartyBinderCallback(zzb2), string);
    }

    public void zze(zzzv.zzb<Players.LoadPlayersResult> zzb2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((IGamesService)this.zzwW()).zzf(new PlayersLoadedBinderCallback(zzb2), n, bl, bl2);
    }

    public void zzs(zzzv.zzb<Players.LoadPlayersResult> zzb2, String string) throws RemoteException {
        ((IGamesService)this.zzwW()).zzy(new PlayerUnfriendedBinderCallback(zzb2), string);
    }

    public void zzf(zzzv.zzb<Players.LoadPlayersResult> zzb2, String string, boolean bl) throws RemoteException {
        ((IGamesService)this.zzwW()).zzg(new SetPlayerMutedBinderCallback(zzb2), string, bl);
    }

    public void zzc(zzzv.zzb<Social.LoadInvitesResult> zzb2, int n) throws RemoteException {
        ((IGamesService)this.zzwW()).zzb((IGamesCallbacks)new InvitesLoadedBinderCallback(zzb2), n);
    }

    public void zza(Account account, byte[] byArray) throws RemoteException {
        ((IGamesService)this.zzwW()).zza(account, byArray);
    }

    public void zzf(Account account) throws RemoteException {
        ((IGamesService)this.zzwW()).zzf(account);
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzcP(iBinder);
    }

    private static final class ListVideosResultImpl
    extends GamesDataHolderResult
    implements Videos.ListVideosResult {
        private final VideoBuffer zzaZv;

        public ListVideosResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZv = new VideoBuffer(dataHolder);
        }
    }

    private static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final Status zzahq;
        private final String zzD;

        CaptureStreamingUrlResultImpl(Status status, String string) {
            this.zzahq = status;
            this.zzD = string;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public String getUrl() {
            return this.zzD;
        }
    }

    private static final class CaptureStreamingMetadataResultImpl
    implements Videos.CaptureStreamingMetadataResult {
        private final Status zzahq;
        private final String zzalD;
        private final String zzacd;

        CaptureStreamingMetadataResultImpl(Status status, String string, String string2) {
            this.zzahq = status;
            this.zzalD = string;
            this.zzacd = string2;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class CaptureStreamingEnabledResultImpl
    implements Result {
        private final Status zzahq;

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class CaptureStreamingAvailabilityResultImpl
    implements Videos.CaptureStreamingAvailabilityResult {
        private final Status zzahq;
        private final boolean zzaZd;
        private final boolean zzaZk;

        CaptureStreamingAvailabilityResultImpl(Status status, boolean bl, boolean bl2) {
            this.zzahq = status;
            this.zzaZd = bl;
            this.zzaZk = bl2;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class CaptureStoppedResultImpl
    implements Videos.CaptureStoppedResult {
        private final Status zzahq;
        private final Uri zzaZj;

        CaptureStoppedResultImpl(Status status, Uri uri) {
            this.zzahq = status;
            this.zzaZj = uri;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class CaptureStateResultImpl
    implements Videos.CaptureStateResult {
        private final Status zzahq;
        private final CaptureState zzaZi;

        CaptureStateResultImpl(Status status, CaptureState captureState) {
            this.zzahq = status;
            this.zzaZi = captureState;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public CaptureState getCaptureState() {
            return this.zzaZi;
        }
    }

    private static final class CaptureCapabilitiesResultImpl
    implements Videos.CaptureCapabilitiesResult {
        private final Status zzahq;
        private final VideoCapabilities zzaZe;

        CaptureCapabilitiesResultImpl(Status status, VideoCapabilities videoCapabilities) {
            this.zzahq = status;
            this.zzaZe = videoCapabilities;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public VideoCapabilities getCapabilities() {
            return this.zzaZe;
        }
    }

    private static final class CaptureAvailableResultImpl
    implements Videos.CaptureAvailableResult {
        private final Status zzahq;
        private final boolean zzaZd;

        CaptureAvailableResultImpl(Status status, boolean bl) {
            this.zzahq = status;
            this.zzaZd = bl;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public boolean isAvailable() {
            return this.zzaZd;
        }
    }

    private static final class InviteUpdateResultImpl
    extends GamesDataHolderResult
    implements Social.InviteUpdateResult {
        private final SocialInvite zzaZs;

        InviteUpdateResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            try {
                this.zzaZs = socialInviteBuffer.getCount() > 0 ? new SocialInviteEntity((SocialInvite)socialInviteBuffer.get(0)) : null;
            }
            finally {
                socialInviteBuffer.release();
            }
        }
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status zzahq;
        private final String zzaZn;

        DeleteSnapshotResultImpl(int n, String string) {
            this.zzahq = GamesStatusCodes.zzib(n);
            this.zzaZn = string;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public String getSnapshotId() {
            return this.zzaZn;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzaZm;

        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzaZm = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.zzaZm;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends GamesDataHolderResult
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzaZS;
        private final String zzaZT;
        private final Snapshot zzaZU;
        private final com.google.android.gms.drive.zzc zzaZV;
        private final SnapshotContents zzaZW;

        OpenSnapshotResultImpl(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzaZS = null;
                    this.zzaZU = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    zzc.zzar((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzaZS = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(zzc2));
                    this.zzaZU = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzaZS = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContentsEntity(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzaZU = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContentsEntity(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzaZT = string;
            this.zzaZV = zzc4;
            this.zzaZW = new SnapshotContentsEntity(zzc4);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.zzaZS;
        }

        @Override
        public String getConflictId() {
            return this.zzaZT;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.zzaZU;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.zzaZW;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends GamesDataHolderResult
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzazI);
        }
    }

    private static final class LoadPlayerStatsResultImpl
    extends GamesDataHolderResult
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzaZG;

        LoadPlayerStatsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzaZG = playerStatsBuffer.getCount() > 0 ? new PlayerStatsEntity((PlayerStats)playerStatsBuffer.get(0)) : null;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public PlayerStats getPlayerStats() {
            return this.zzaZG;
        }
    }

    private static final class LoadAppContentsResultImpl
    extends GamesDataHolderResult
    implements AppContents.LoadAppContentResult {
        private final ArrayList<DataHolder> zzaZx;

        LoadAppContentsResultImpl(DataHolder[] dataHolderArray) {
            super(dataHolderArray[0]);
            this.zzaZx = new ArrayList<DataHolder>(Arrays.asList(dataHolderArray));
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends GamesDataHolderResult
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzaZl;
        private final Quest zzaZa;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzaZa = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzaZa.zzFI();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzaZl = list.get(i);
                        return;
                    }
                    this.zzaZl = null;
                } else {
                    this.zzaZl = null;
                    this.zzaZa = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.zzaZl;
        }

        @Override
        public Quest getQuest() {
            return this.zzaZa;
        }
    }

    private static final class AcceptQuestResultImpl
    extends GamesDataHolderResult
    implements Quests.AcceptQuestResult {
        private final Quest zzaZa;

        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzaZa = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.zzaZa;
        }
    }

    private static final class LoadQuestsResultImpl
    extends GamesDataHolderResult
    implements Quests.LoadQuestsResult {
        private final DataHolder zzazI;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzazI = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.zzazI);
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends GamesDataHolderResult
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status zzahq;
        private final Bundle zzaZI;

        LoadRequestsResultImpl(Status status, Bundle bundle) {
            this.zzahq = status;
            this.zzaZI = bundle;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public GameRequestBuffer getRequests(int n) {
            String string = RequestType.zziC(n);
            if (!this.zzaZI.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzaZI.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public void release() {
            for (String string : this.zzaZI.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzaZI.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends GamesDataHolderResult
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes zzbaz;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzbaz = RequestUpdateOutcomes.zzal(dataHolder);
        }

        @Override
        public int getRequestOutcome(String string) {
            return this.zzbaz.getRequestOutcome(string);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.zzbaz.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends GamesDataHolderResult
    implements Requests.SendRequestResult {
        private final GameRequest zzbaf;

        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.zzbaf = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status zzahq;
        private final Bundle zzaZq;

        InboxCountResultImpl(Status status, Bundle bundle) {
            this.zzahq = status;
            this.zzaZq = bundle;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class GetServerAuthCodeResultImpl
    implements Games.GetServerAuthCodeResult {
        private final Status zzahq;
        private final String zzaZp;

        GetServerAuthCodeResultImpl(Status status, String string) {
            this.zzahq = status;
            this.zzaZp = string;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public String getCode() {
            return this.zzaZp;
        }
    }

    private static final class GetTokenResultImpl
    implements Games.GetTokenResult {
        private final Status zzahq;
        private final String zzahI;

        GetTokenResultImpl(Status status, String string) {
            this.zzahq = status;
            this.zzahI = string;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends GamesDataHolderResult
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status zzahq;
        private final String zzaZo;
        private final boolean zzZA;

        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.zzahq = GamesStatusCodes.zzib(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.zzaZo = dataHolder.zzd("external_game_id", 0, 0);
                    this.zzZA = dataHolder.zze("muted", 0, 0);
                } else {
                    this.zzaZo = null;
                    this.zzZA = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status zzahq;
        private final String zzaZo;
        private final boolean zzZA;

        public GameMuteStatusChangeResultImpl(int n, String string, boolean bl) {
            this.zzahq = GamesStatusCodes.zzib(n);
            this.zzaZo = string;
            this.zzZA = bl;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status zzahq;
        private final String zzaZc;

        CancelMatchResultImpl(Status status, String string) {
            this.zzahq = status;
            this.zzaZc = string;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public String getMatchId() {
            return this.zzaZc;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends GamesDataHolderResult {
        final TurnBasedMatch zzaZQ;

        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzaZQ = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzaZQ;
        }
    }

    private static final class SubmitScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzbar;

        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzbar = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.zzbar;
        }
    }

    private static final class UpdateGamerProfileResultImpl
    implements Players.UpdateGamerProfileResult {
        private final Status zzahq;
        private final Bundle zzbay;

        UpdateGamerProfileResultImpl(int n, Bundle bundle) {
            this.zzahq = new Status(n);
            this.zzbay = bundle;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class LoadStockProfileImagesResultImpl
    extends GamesDataHolderResult
    implements Players.LoadStockProfileImagesResult {
        private final StockProfileImageBuffer zzaZL;

        LoadStockProfileImagesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZL = new StockProfileImageBuffer(dataHolder);
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends GamesDataHolderResult
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer zzaZO;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZO = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status zzahq;
        private final List<String> zzaZM;
        private final Bundle zzaZN;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle bundle) {
            this.zzahq = status;
            this.zzaZM = bundle.getStringArrayList("game_category_list");
            this.zzaZN = bundle;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    private static final class LoadInvitesResultImpl
    extends GamesDataHolderResult
    implements Social.LoadInvitesResult {
        private final SocialInviteBuffer zzaZD;

        LoadInvitesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZD = new SocialInviteBuffer(dataHolder);
        }
    }

    private static final class LoadPlayersResultImpl
    extends GamesDataHolderResult
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzaZH;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZH = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.zzaZH;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status zzahq;
        private final LoadMatchesResponse zzaZE;

        LoadMatchesResultImpl(Status status, Bundle bundle) {
            this.zzahq = status;
            this.zzaZE = new LoadMatchesResponse(bundle);
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.zzaZE;
        }

        public void release() {
            this.zzaZE.release();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends GamesDataHolderResult
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzaZC;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZC = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.zzaZC;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzaZF;

        LoadPlayerScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzaZF = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.zzaZF;
        }
    }

    private static final class LoadScoresResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzaZJ;
        private final LeaderboardScoreBuffer zzaZK;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzaZJ = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzaZK = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.zzaZJ;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.zzaZK;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends GamesDataHolderResult
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzaZt;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZt = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.zzaZt;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final GameSearchSuggestionBuffer zzaZA;

        LoadGameSearchSuggestionsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZA = new GameSearchSuggestionBuffer(dataHolder);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer zzaZz;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZz = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends GamesDataHolderResult
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzaZB;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZB = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.zzaZB;
        }
    }

    private static final class LoadEventResultImpl
    extends GamesDataHolderResult
    implements Events.LoadEventsResult {
        private final EventBuffer zzaZy;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZy = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.zzaZy;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status zzahq;
        private final String zzaYb;

        UpdateAchievementResultImpl(int n, String string) {
            this.zzahq = GamesStatusCodes.zzib(n);
            this.zzaYb = string;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public String getAchievementId() {
            return this.zzaYb;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends GamesDataHolderResult
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzaZw;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.zzaZw = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.zzaZw;
        }
    }

    private static abstract class GamesDataHolderResult
    extends zzaag {
        protected GamesDataHolderResult(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzib(dataHolder.getStatusCode()));
        }
    }

    private static final class RealTimeMessageSentNotifier
    implements zzaaz.zzc<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzauz;
        private final String zzbac;
        private final int zzbad;

        RealTimeMessageSentNotifier(int n, int n2, String string) {
            this.zzauz = n;
            this.zzbad = n2;
            this.zzbac = string;
        }

        public void zza(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.zzauz, this.zzbad, this.zzbac);
            }
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private static final class MessageReceivedNotifier
    implements zzaaz.zzc<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzaZR;

        MessageReceivedNotifier(RealTimeMessage realTimeMessage) {
            this.zzaZR = realTimeMessage;
        }

        public void zza(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            realTimeMessageReceivedListener.onRealTimeMessageReceived(this.zzaZR);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RealTimeMessageReceivedListener)object);
        }
    }

    private static final class P2PDisconnectedNotifier
    implements zzaaz.zzc<RoomStatusUpdateListener> {
        private final String zzaZX;

        P2PDisconnectedNotifier(String string) {
            this.zzaZX = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PDisconnected(this.zzaZX);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class P2PConnectedNotifier
    implements zzaaz.zzc<RoomStatusUpdateListener> {
        private final String zzaZX;

        P2PConnectedNotifier(String string) {
            this.zzaZX = string;
        }

        public void zza(RoomStatusUpdateListener roomStatusUpdateListener) {
            roomStatusUpdateListener.onP2PConnected(this.zzaZX);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RoomStatusUpdateListener)object);
        }
    }

    private static final class PeerDisconnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDisconnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private static final class PeerConnectedNotifier
    extends AbstractPeerStatusNotifier {
        PeerConnectedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private static final class PeerDeclinedNotifier
    extends AbstractPeerStatusNotifier {
        PeerDeclinedNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private static final class PeerLeftRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerLeftRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private static final class PeerJoinedRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerJoinedRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private static final class PeerInvitedToRoomNotifier
    extends AbstractPeerStatusNotifier {
        PeerInvitedToRoomNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private static final class DisconnectedFromRoomNotifier
    extends AbstractRoomStatusNotifier {
        DisconnectedFromRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private static final class ConnectedToRoomNotifier
    extends AbstractRoomStatusNotifier {
        ConnectedToRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private static final class RoomAutoMatchingNotifier
    extends AbstractRoomStatusNotifier {
        RoomAutoMatchingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private static final class RoomConnectingNotifier
    extends AbstractRoomStatusNotifier {
        RoomConnectingNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private static final class RoomConnectedNotifier
    extends AbstractRoomNotifier {
        RoomConnectedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    private static final class LeftRoomNotifier
    implements zzaaz.zzc<RoomUpdateListener> {
        private final int zzauz;
        private final String zzaZu;

        LeftRoomNotifier(int n, String string) {
            this.zzauz = n;
            this.zzaZu = string;
        }

        public void zza(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.zzauz, this.zzaZu);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((RoomUpdateListener)object);
        }
    }

    private static final class JoinedRoomNotifier
    extends AbstractRoomNotifier {
        public JoinedRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    private static final class RoomCreatedNotifier
    extends AbstractRoomNotifier {
        public RoomCreatedNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    private static abstract class AbstractPeerStatusNotifier
    extends AbstractRoomStatusNotifier {
        private final ArrayList<String> zzaYZ = new ArrayList();

        AbstractPeerStatusNotifier(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzaYZ.add(stringArray[i]);
            }
        }

        @Override
        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzaYZ);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private static abstract class AbstractRoomStatusNotifier
    extends zzaaf<RoomStatusUpdateListener> {
        AbstractRoomStatusNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzai(dataHolder));
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);
    }

    private static abstract class AbstractRoomNotifier
    extends zzaaf<RoomUpdateListener> {
        AbstractRoomNotifier(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected void zza(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.zza(roomUpdateListener, GamesClientImpl.zzai(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);
    }

    private static final class NearbyPlayerDetectedNotifier
    implements zzaaz.zzc<OnNearbyPlayerDetectedListener> {
        public void zzvy() {
        }
    }

    private static final class SocialInviteRemovedNotifier
    implements zzaaz.zzc<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite zzbaq;

        SocialInviteRemovedNotifier(SocialInvite socialInvite) {
            this.zzbaq = socialInvite;
        }

        public void zzvy() {
        }
    }

    private static final class SocialInviteUpdateReceivedNotifier
    implements zzaaz.zzc<OnSocialInviteUpdateReceivedListener> {
        private final SocialInvite zzbaq;

        SocialInviteUpdateReceivedNotifier(SocialInvite socialInvite) {
            this.zzbaq = socialInvite;
        }

        public void zzvy() {
        }
    }

    private static final class RequestRemovedNotifier
    implements zzaaz.zzc<OnRequestReceivedListener> {
        private final String zzOn;

        RequestRemovedNotifier(String string) {
            this.zzOn = string;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.zzOn);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class RequestReceivedNotifier
    implements zzaaz.zzc<OnRequestReceivedListener> {
        private final GameRequest zzbaf;

        RequestReceivedNotifier(GameRequest gameRequest) {
            this.zzbaf = gameRequest;
        }

        public void zza(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.zzbaf);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnRequestReceivedListener)object);
        }
    }

    private static final class QuestCompletedNotifier
    implements zzaaz.zzc<QuestUpdateListener> {
        private final Quest zzaZa;

        QuestCompletedNotifier(Quest quest) {
            this.zzaZa = quest;
        }

        public void zza(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.zzaZa);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((QuestUpdateListener)object);
        }
    }

    private static final class MatchRemovedNotifier
    implements zzaaz.zzc<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzaZP;

        MatchRemovedNotifier(String string) {
            this.zzaZP = string;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.zzaZP);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class MatchUpdateReceivedNotifier
    implements zzaaz.zzc<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzaZQ;

        MatchUpdateReceivedNotifier(TurnBasedMatch turnBasedMatch) {
            this.zzaZQ = turnBasedMatch;
        }

        public void zza(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.zzaZQ);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private static final class InvitationRemovedNotifier
    implements zzaaz.zzc<OnInvitationReceivedListener> {
        private final String zzahi;

        InvitationRemovedNotifier(String string) {
            this.zzahi = string;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.zzahi);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class InvitationReceivedNotifier
    implements zzaaz.zzc<OnInvitationReceivedListener> {
        private final Invitation zzaZr;

        InvitationReceivedNotifier(Invitation invitation) {
            this.zzaZr = invitation;
        }

        public void zza(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.zzaZr);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((OnInvitationReceivedListener)object);
        }
    }

    private static final class CaptureOverlayStateChangedNotifier
    implements zzaaz.zzc<Videos.CaptureOverlayStateListener> {
        private final int zzaZg;

        CaptureOverlayStateChangedNotifier(int n) {
            this.zzaZg = n;
        }

        public void zza(Videos.CaptureOverlayStateListener captureOverlayStateListener) {
            captureOverlayStateListener.onCaptureOverlayStateChanged(this.zzaZg);
        }

        public void zzvy() {
        }

        public /* synthetic */ void zzs(Object object) {
            this.zza((Videos.CaptureOverlayStateListener)object);
        }
    }

    private static final class SetPlayerMutedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Players.LoadPlayersResult> zzaFq;

        SetPlayerMutedBinderCallback(zzzv.zzb<Players.LoadPlayersResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzag(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class PlayerUnfriendedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Players.LoadPlayersResult> zzaFq;

        PlayerUnfriendedBinderCallback(zzzv.zzb<Players.LoadPlayersResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaf(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class CancelFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Social.InviteUpdateResult> zzaFq;

        CancelFriendInviteFirstPartyBinderCallback(zzzv.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzae(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class IgnoreFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Social.InviteUpdateResult> zzaFq;

        IgnoreFriendInviteFirstPartyBinderCallback(zzzv.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzad(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class AcceptFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Social.InviteUpdateResult> zzaFq;

        AcceptFriendInviteFirstPartyBinderCallback(zzzv.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzaa(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class SendFriendInviteFirstPartyBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Social.InviteUpdateResult> zzaFq;

        SendFriendInviteFirstPartyBinderCallback(zzzv.zzb<Social.InviteUpdateResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzZ(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new InviteUpdateResultImpl(dataHolder));
        }
    }

    private static final class UpdateHeadlessCapturePermissionBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        UpdateHeadlessCapturePermissionBinderCallback(zzzv.zzb<Status> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzan(Status status) {
            this.zzaFq.setResult((Object)status);
        }
    }

    private static final class ListVideosBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Videos.ListVideosResult> zzaFq;

        ListVideosBinderCallback(zzzv.zzb<Videos.ListVideosResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzX(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new ListVideosResultImpl(dataHolder));
        }
    }

    private static final class CaptureStreamingUrlBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Videos.CaptureStreamingUrlResult> zzaFq;

        CaptureStreamingUrlBinderCallback(zzzv.zzb<Videos.CaptureStreamingUrlResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(int n, String string) {
            this.zzaFq.setResult((Object)new CaptureStreamingUrlResultImpl(new Status(n), string));
        }
    }

    private static final class CaptureStreamingMetadataBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Videos.CaptureStreamingMetadataResult> zzaFq;

        CaptureStreamingMetadataBinderCallback(zzzv.zzb<Videos.CaptureStreamingMetadataResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, String string, String string2) {
            this.zzaFq.setResult((Object)new CaptureStreamingMetadataResultImpl(new Status(n), string, string2));
        }
    }

    private static final class CaptureStreamingEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        CaptureStreamingEnabledBinderCallback(zzzv.zzb<Status> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzir(int n) {
            this.zzaFq.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureStreamingAvailabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Videos.CaptureStreamingAvailabilityResult> zzaFq;

        CaptureStreamingAvailabilityBinderCallback(zzzv.zzb<Videos.CaptureStreamingAvailabilityResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, boolean bl, boolean bl2) {
            this.zzaFq.setResult((Object)new CaptureStreamingAvailabilityResultImpl(new Status(n), bl, bl2));
        }
    }

    private static final class CaptureStoppedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Videos.CaptureStoppedResult> zzaFq;

        public CaptureStoppedBinderCallbacks(zzzv.zzb<Videos.CaptureStoppedResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, Uri uri) {
            this.zzaFq.setResult((Object)new CaptureStoppedResultImpl(new Status(n), uri));
        }
    }

    private static final class CaptureStateBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Videos.CaptureStateResult> zzaFq;

        public CaptureStateBinderCallbacks(zzzv.zzb<Videos.CaptureStateResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            this.zzaFq.setResult((Object)new CaptureStateResultImpl(new Status(n), CaptureState.zzC(bundle)));
        }
    }

    private static final class CaptureStartedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;
        private final Videos.CaptureRuntimeErrorCallback zzaZh;

        public CaptureStartedBinderCallbacks(zzzv.zzb<Status> zzb2, Videos.CaptureRuntimeErrorCallback captureRuntimeErrorCallback) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
            this.zzaZh = (Videos.CaptureRuntimeErrorCallback)zzac.zzb((Object)captureRuntimeErrorCallback, (Object)"Callback must not be null");
        }

        @Override
        public void zzao(Status status) {
            this.zzaFq.setResult((Object)status);
        }

        @Override
        public void zziv(int n) {
        }
    }

    private static final class CapturePausedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        public CapturePausedBinderCallback(zzzv.zzb<Status> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zziw(int n) {
            this.zzaFq.setResult((Object)new Status(n));
        }
    }

    private static final class CaptureOverlayStateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaaz<Videos.CaptureOverlayStateListener> zzaLP;

        CaptureOverlayStateBinderCallback(zzaaz<Videos.CaptureOverlayStateListener> zzaaz2) {
            this.zzaLP = (zzaaz)zzac.zzb(zzaaz2, (Object)"Callback must not be null");
        }

        @Override
        public void onCaptureOverlayStateChanged(int n) {
            this.zzaLP.zza((zzaaz.zzc)new CaptureOverlayStateChangedNotifier(n));
        }
    }

    private static final class CaptureLaunchGameAndOverlayBinderCallback
    extends AbstractGamesCallbacks {
        private final Games.BaseGamesApiMethodImpl<Status> zzaZf;

        CaptureLaunchGameAndOverlayBinderCallback(Games.BaseGamesApiMethodImpl<Status> baseGamesApiMethodImpl) {
            this.zzaZf = (Games.BaseGamesApiMethodImpl)((Object)zzac.zzb(baseGamesApiMethodImpl, (Object)"Holder must not be null"));
        }

        @Override
        public void zziq(int n) {
            this.zzaZf.zzb((Result)new Status(n));
        }

        @Override
        public void zzal(Status status) {
            this.zzaZf.zzb((Result)status);
        }
    }

    private static final class CaptureCapabilitiesBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Videos.CaptureCapabilitiesResult> zzaFq;

        CaptureCapabilitiesBinderCallback(zzzv.zzb<Videos.CaptureCapabilitiesResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzaFq.setResult((Object)new CaptureCapabilitiesResultImpl(new Status(n), videoCapabilities));
        }
    }

    private static final class CaptureAvailableBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Videos.CaptureAvailableResult> zzaFq;

        CaptureAvailableBinderCallback(zzzv.zzb<Videos.CaptureAvailableResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, boolean bl) {
            this.zzaFq.setResult((Object)new CaptureAvailableResultImpl(new Status(n), bl));
        }
    }

    private static final class HeadlessCaptureEnabledBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        HeadlessCaptureEnabledBinderCallback(zzzv.zzb<Status> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzam(Status status) {
            this.zzaFq.setResult((Object)status);
        }
    }

    static final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Snapshots.DeleteSnapshotResult> zzaFq;

        public SnapshotDeletedBinderCallbacks(zzzv.zzb<Snapshots.DeleteSnapshotResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(int n, String string) {
            this.zzaFq.setResult((Object)new DeleteSnapshotResultImpl(n, string));
        }
    }

    private static final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Snapshots.CommitSnapshotResult> zzban;

        public SnapshotCommittedBinderCallbacks(zzzv.zzb<Snapshots.CommitSnapshotResult> zzb2) {
            this.zzban = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzO(DataHolder dataHolder) {
            this.zzban.setResult((Object)new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private static final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Snapshots.OpenSnapshotResult> zzbao;

        public SnapshotOpenedBinderCallbacks(zzzv.zzb<Snapshots.OpenSnapshotResult> zzb2) {
            this.zzbao = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zzbao.setResult((Object)new OpenSnapshotResultImpl(dataHolder, zzc2));
        }

        @Override
        public void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zzbao.setResult((Object)new OpenSnapshotResultImpl(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    private static final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Snapshots.LoadSnapshotsResult> zzbap;

        public SnapshotsLoadedBinderCallbacks(zzzv.zzb<Snapshots.LoadSnapshotsResult> zzb2) {
            this.zzbap = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzN(DataHolder dataHolder) {
            this.zzbap.setResult((Object)new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private static final class PlayerStatsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Stats.LoadPlayerStatsResult> zzaFq;

        public PlayerStatsLoadedBinderCallbacks(zzzv.zzb<Stats.LoadPlayerStatsResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzW(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadPlayerStatsResultImpl(dataHolder));
        }
    }

    private static final class AppContentLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<AppContents.LoadAppContentResult> zzaZb;

        public AppContentLoadedBinderCallbacks(zzzv.zzb<AppContents.LoadAppContentResult> zzb2) {
            this.zzaZb = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder[] dataHolderArray) {
            this.zzaZb.setResult((Object)new LoadAppContentsResultImpl(dataHolderArray));
        }
    }

    private static final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Quests.LoadQuestsResult> zzbab;

        public QuestsLoadedBinderCallbacks(zzzv.zzb<Quests.LoadQuestsResult> zzb2) {
            this.zzbab = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzT(DataHolder dataHolder) {
            this.zzbab.setResult((Object)new LoadQuestsResultImpl(dataHolder));
        }
    }

    private static final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Quests.ClaimMilestoneResult> zzaZZ;
        private final String zzbaa;

        public QuestMilestoneClaimBinderCallbacks(zzzv.zzb<Quests.ClaimMilestoneResult> zzb2, String string) {
            this.zzaZZ = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
            this.zzbaa = (String)zzac.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public void zzP(DataHolder dataHolder) {
            this.zzaZZ.setResult((Object)new ClaimMilestoneResultImpl(dataHolder, this.zzbaa));
        }
    }

    private static final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Quests.AcceptQuestResult> zzaZY;

        public QuestAcceptedBinderCallbacks(zzzv.zzb<Quests.AcceptQuestResult> zzb2) {
            this.zzaZY = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzQ(DataHolder dataHolder) {
            this.zzaZY.setResult((Object)new AcceptQuestResultImpl(dataHolder));
        }
    }

    private static final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Requests.LoadRequestSummariesResult> zzbah;

        public RequestSummariesLoadedBinderCallbacks(zzzv.zzb<Requests.LoadRequestSummariesResult> zzb2) {
            this.zzbah = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzM(DataHolder dataHolder) {
            this.zzbah.setResult((Object)new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private static final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Requests.LoadRequestsResult> zzbai;

        public RequestsLoadedBinderCallbacks(zzzv.zzb<Requests.LoadRequestsResult> zzb2) {
            this.zzbai = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzd(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzib(n);
            this.zzbai.setResult((Object)new LoadRequestsResultImpl(status, bundle));
        }
    }

    private static final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Requests.SendRequestResult> zzbag;

        public RequestSentBinderCallbacks(zzzv.zzb<Requests.SendRequestResult> zzb2) {
            this.zzbag = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzL(DataHolder dataHolder) {
            this.zzbag.setResult((Object)new SendRequestResultImpl(dataHolder));
        }
    }

    private static final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Requests.UpdateRequestsResult> zzbaj;

        public RequestsUpdatedBinderCallbacks(zzzv.zzb<Requests.UpdateRequestsResult> zzb2) {
            this.zzbaj = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzK(DataHolder dataHolder) {
            this.zzbaj.setResult((Object)new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private static final class PopupLocationInfoBinderCallbacks
    extends AbstractGamesClient {
        private final PopupManager zzaYT;

        public PopupLocationInfoBinderCallbacks(PopupManager popupManager) {
            this.zzaYT = popupManager;
        }

        @Override
        public PopupLocationInfoParcelable zzDX() {
            return new PopupLocationInfoParcelable(this.zzaYT.zzEQ());
        }
    }

    private static final class GetServerAuthCodeBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Games.GetServerAuthCodeResult> zzaFq;

        public GetServerAuthCodeBinderCallbacks(zzzv.zzb<Games.GetServerAuthCodeResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            Status status = GamesStatusCodes.zzib(n);
            this.zzaFq.setResult((Object)new GetServerAuthCodeResultImpl(status, string));
        }
    }

    private static final class GetAuthTokenBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Games.GetTokenResult> zzaFq;

        public GetAuthTokenBinderCallbacks(zzzv.zzb<Games.GetTokenResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(int n, String string) {
            Status status = GamesStatusCodes.zzib(n);
            this.zzaFq.setResult((Object)new GetTokenResultImpl(status, string));
        }
    }

    private static final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        public SignOutCompleteBinderCallbacks(zzzv.zzb<Status> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzDW() {
            Status status = GamesStatusCodes.zzib(0);
            this.zzaFq.setResult((Object)status);
        }
    }

    private static final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Notifications.InboxCountResult> zzaFq;

        InboxCountsLoadedBinderCallback(zzzv.zzb<Notifications.InboxCountResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzg(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzib(n);
            this.zzaFq.setResult((Object)new InboxCountResultImpl(status, bundle));
        }
    }

    private static final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        ContactSettingsUpdatedBinderCallback(zzzv.zzb<Status> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzio(int n) {
            this.zzaFq.setResult((Object)GamesStatusCodes.zzib(n));
        }
    }

    private static final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Notifications.ContactSettingLoadResult> zzaFq;

        ContactSettingsLoadedBinderCallback(zzzv.zzb<Notifications.ContactSettingLoadResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzI(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Notifications.GameMuteStatusLoadResult> zzaFq;

        GameMuteStatusLoadedBinderCallback(zzzv.zzb<Notifications.GameMuteStatusLoadResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzG(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private static final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Notifications.GameMuteStatusChangeResult> zzaFq;

        GameMuteStatusChangedBinderCallback(zzzv.zzb<Notifications.GameMuteStatusChangeResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(int n, String string, boolean bl) {
            this.zzaFq.setResult((Object)new GameMuteStatusChangeResultImpl(n, string, bl));
        }
    }

    private static final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final zzaaz<RealTimeMultiplayer.ReliableMessageSentCallback> zzbae;

        public RealTimeReliableMessageBinderCallbacks(zzaaz<RealTimeMultiplayer.ReliableMessageSentCallback> zzaaz2) {
            this.zzbae = zzaaz2;
        }

        @Override
        public void zzb(int n, int n2, String string) {
            if (this.zzbae != null) {
                this.zzbae.zza((zzaaz.zzc)new RealTimeMessageSentNotifier(n, n2, string));
            }
        }
    }

    private static final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzaaz<? extends RoomUpdateListener> zzbak;
        private final zzaaz<? extends RoomStatusUpdateListener> zzbal;
        private final zzaaz<RealTimeMessageReceivedListener> zzbam;

        public RoomBinderCallbacks(zzaaz<RoomUpdateListener> zzaaz2) {
            this.zzbak = (zzaaz)zzac.zzb(zzaaz2, (Object)"Callbacks must not be null");
            this.zzbal = null;
            this.zzbam = null;
        }

        public RoomBinderCallbacks(zzaaz<? extends RoomUpdateListener> zzaaz2, zzaaz<? extends RoomStatusUpdateListener> zzaaz3, zzaaz<RealTimeMessageReceivedListener> zzaaz4) {
            this.zzbak = (zzaaz)zzac.zzb(zzaaz2, (Object)"Callbacks must not be null");
            this.zzbal = zzaaz3;
            this.zzbam = zzaaz4;
        }

        @Override
        public void zzz(DataHolder dataHolder) {
            this.zzbak.zza((zzaaz.zzc)new RoomCreatedNotifier(dataHolder));
        }

        @Override
        public void zzA(DataHolder dataHolder) {
            this.zzbak.zza((zzaaz.zzc)new JoinedRoomNotifier(dataHolder));
        }

        @Override
        public void onLeftRoom(int n, String string) {
            this.zzbak.zza((zzaaz.zzc)new LeftRoomNotifier(n, string));
        }

        @Override
        public void zzD(DataHolder dataHolder) {
            this.zzbak.zza((zzaaz.zzc)new RoomConnectedNotifier(dataHolder));
        }

        @Override
        public void zzB(DataHolder dataHolder) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new RoomConnectingNotifier(dataHolder));
            }
        }

        @Override
        public void zzC(DataHolder dataHolder) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new RoomAutoMatchingNotifier(dataHolder));
            }
        }

        @Override
        public void zzE(DataHolder dataHolder) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new ConnectedToRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zzF(DataHolder dataHolder) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new DisconnectedFromRoomNotifier(dataHolder));
            }
        }

        @Override
        public void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new PeerConnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new PeerDisconnectedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new PeerInvitedToRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new PeerJoinedRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new PeerLeftRoomNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new PeerDeclinedNotifier(dataHolder, stringArray));
            }
        }

        @Override
        public void onP2PConnected(String string) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new P2PConnectedNotifier(string));
            }
        }

        @Override
        public void onP2PDisconnected(String string) {
            if (this.zzbal != null) {
                this.zzbal.zza((zzaaz.zzc)new P2PDisconnectedNotifier(string));
            }
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzbam != null) {
                this.zzbam.zza((zzaaz.zzc)new MessageReceivedNotifier(realTimeMessage));
            }
        }
    }

    private static final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<TurnBasedMultiplayer.CancelMatchResult> zzbas;

        public TurnBasedMatchCanceledBinderCallbacks(zzzv.zzb<TurnBasedMultiplayer.CancelMatchResult> zzb2) {
            this.zzbas = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(int n, String string) {
            Status status = GamesStatusCodes.zzib(n);
            this.zzbas.setResult((Object)new CancelMatchResultImpl(status, string));
        }
    }

    private static final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzbau;

        public TurnBasedMatchLeftBinderCallbacks(zzzv.zzb<TurnBasedMultiplayer.LeaveMatchResult> zzb2) {
            this.zzbau = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzx(DataHolder dataHolder) {
            this.zzbau.setResult((Object)new LeaveMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzbaw;

        public TurnBasedMatchUpdatedBinderCallbacks(zzzv.zzb<TurnBasedMultiplayer.UpdateMatchResult> zzb2) {
            this.zzbaw = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzw(DataHolder dataHolder) {
            this.zzbaw.setResult((Object)new UpdateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzbat;

        public TurnBasedMatchInitiatedBinderCallbacks(zzzv.zzb<TurnBasedMultiplayer.InitiateMatchResult> zzb2) {
            this.zzbat = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzv(DataHolder dataHolder) {
            this.zzbat.setResult((Object)new InitiateMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<TurnBasedMultiplayer.LoadMatchResult> zzbav;

        public TurnBasedMatchLoadedBinderCallbacks(zzzv.zzb<TurnBasedMultiplayer.LoadMatchResult> zzb2) {
            this.zzbav = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzu(DataHolder dataHolder) {
            this.zzbav.setResult((Object)new LoadMatchResultImpl(dataHolder));
        }
    }

    private static final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzbax;

        public TurnBasedMatchesLoadedBinderCallbacks(zzzv.zzb<TurnBasedMultiplayer.LoadMatchesResult> zzb2) {
            this.zzbax = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzib(n);
            this.zzbax.setResult((Object)new LoadMatchesResultImpl(status, bundle));
        }
    }

    private static final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Leaderboards.SubmitScoreResult> zzaFq;

        public SubmitScoreBinderCallbacks(zzzv.zzb<Leaderboards.SubmitScoreResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzk(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new SubmitScoreResultImpl(dataHolder));
        }
    }

    private static final class UpdateProfileDiscoverabilityBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        UpdateProfileDiscoverabilityBinderCallback(zzzv.zzb<Status> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zziu(int n) {
            this.zzaFq.setResult((Object)new Status(n));
        }
    }

    private static final class UpdateAutoSignInBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        UpdateAutoSignInBinderCallback(zzzv.zzb<Status> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zzit(int n) {
            this.zzaFq.setResult((Object)new Status(n));
        }
    }

    private static final class DeletePlayerBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        DeletePlayerBinderCallback(zzzv.zzb<Status> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zzis(int n) {
            this.zzaFq.setResult((Object)new Status(n));
        }
    }

    private static final class GamerProfileUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Players.UpdateGamerProfileResult> zzaFq;

        GamerProfileUpdatedBinderCallback(zzzv.zzb<Players.UpdateGamerProfileResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            this.zzaFq.setResult((Object)new UpdateGamerProfileResultImpl(n, bundle));
        }
    }

    private static final class StockProfileImagesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Players.LoadStockProfileImagesResult> zzaFq;

        StockProfileImagesLoadedBinderCallback(zzzv.zzb<Players.LoadStockProfileImagesResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zzY(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadStockProfileImagesResultImpl(dataHolder));
        }
    }

    private static final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Status> zzaFq;

        ProfileSettingsUpdatedBinderCallback(zzzv.zzb<Status> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzip(int n) {
            this.zzaFq.setResult((Object)GamesStatusCodes.zzib(n));
        }
    }

    private static final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Players.LoadProfileSettingsResult> zzaFq;

        ProfileSettingsLoadedBinderCallback(zzzv.zzb<Players.LoadProfileSettingsResult> zzb2) {
            this.zzaFq = zzb2;
        }

        @Override
        public void zzV(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new ProfileSettingsEntity(dataHolder));
            dataHolder.close();
        }
    }

    static final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Players.LoadXpStreamResult> zzaFq;

        PlayerXpStreamLoadedBinderCallback(zzzv.zzb<Players.LoadXpStreamResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzU(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private static final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Players.LoadXpForGameCategoriesResult> zzaFq;

        PlayerXpForGameCategoriesLoadedBinderCallback(zzzv.zzb<Players.LoadXpForGameCategoriesResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzf(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzib(n);
            this.zzaFq.setResult((Object)new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private static final class InvitesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Social.LoadInvitesResult> zzaFq;

        InvitesLoadedBinderCallback(zzzv.zzb<Social.LoadInvitesResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzah(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadInvitesResultImpl(dataHolder));
        }
    }

    private static final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Players.LoadPlayersResult> zzaFq;

        PlayersLoadedBinderCallback(zzzv.zzb<Players.LoadPlayersResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzl(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void zzm(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadPlayersResultImpl(dataHolder));
        }
    }

    private static final class SocialInviteUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzab(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzaaz.zzc)new SocialInviteUpdateReceivedNotifier(socialInvite));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzac(DataHolder dataHolder) {
            SocialInviteBuffer socialInviteBuffer = new SocialInviteBuffer(dataHolder);
            SocialInvite socialInvite = null;
            try {
                if (socialInviteBuffer.getCount() > 0) {
                    socialInvite = (SocialInvite)((SocialInvite)socialInviteBuffer.get(0)).freeze();
                }
            }
            finally {
                socialInviteBuffer.release();
            }
            if (socialInvite != null) {
                null.zza((zzaaz.zzc)new SocialInviteRemovedNotifier(socialInvite));
            }
        }
    }

    private static final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaaz<OnRequestReceivedListener> zzaLP;

        RequestReceivedBinderCallback(zzaaz<OnRequestReceivedListener> zzaaz2) {
            this.zzaLP = zzaaz2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzt(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzaLP.zza((zzaaz.zzc)new RequestReceivedNotifier(gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String string) {
            this.zzaLP.zza((zzaaz.zzc)new RequestRemovedNotifier(string));
        }
    }

    private static final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaaz<QuestUpdateListener> zzaLP;

        QuestUpdateBinderCallback(zzaaz<QuestUpdateListener> zzaaz2) {
            this.zzaLP = zzaaz2;
        }

        @Override
        public void zzR(DataHolder dataHolder) {
            Quest quest = this.zzak(dataHolder);
            if (quest != null) {
                this.zzaLP.zza((zzaaz.zzc)new QuestCompletedNotifier(quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest zzak(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private static final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaaz<OnTurnBasedMatchUpdateReceivedListener> zzaLP;

        MatchUpdateReceivedBinderCallback(zzaaz<OnTurnBasedMatchUpdateReceivedListener> zzaaz2) {
            this.zzaLP = zzaaz2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzy(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzaLP.zza((zzaaz.zzc)new MatchUpdateReceivedNotifier(turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String string) {
            this.zzaLP.zza((zzaaz.zzc)new MatchRemovedNotifier(string));
        }
    }

    private static final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzaaz<OnInvitationReceivedListener> zzaLP;

        InvitationReceivedBinderCallback(zzaaz<OnInvitationReceivedListener> zzaaz2) {
            this.zzaLP = zzaaz2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzs(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzaLP.zza((zzaaz.zzc)new InvitationReceivedNotifier(invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String string) {
            this.zzaLP.zza((zzaaz.zzc)new InvitationRemovedNotifier(string));
        }
    }

    private static final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Invitations.LoadInvitationsResult> zzaFq;

        InvitationsLoadedBinderCallback(zzzv.zzb<Invitations.LoadInvitationsResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzr(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private static final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Leaderboards.LoadPlayerScoreResult> zzaFq;

        PlayerLeaderboardScoreLoadedBinderCallback(zzzv.zzb<Leaderboards.LoadPlayerScoreResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzJ(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private static final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Leaderboards.LoadScoresResult> zzaFq;

        LeaderboardScoresLoadedBinderCallback(zzzv.zzb<Leaderboards.LoadScoresResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzaFq.setResult((Object)new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private static final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Leaderboards.LeaderboardMetadataResult> zzaFq;

        LeaderboardsLoadedBinderCallback(zzzv.zzb<Leaderboards.LeaderboardMetadataResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzj(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private static final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzaFq;

        GameSearchSuggestionsLoadedBinderCallback(zzzv.zzb<GamesMetadata.LoadGameSearchSuggestionsResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzq(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private static final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<GamesMetadata.LoadGameInstancesResult> zzaFq;

        GameInstancesLoadedBinderCallback(zzzv.zzb<GamesMetadata.LoadGameInstancesResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzp(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private static final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Events.LoadEventsResult> zzaFq;

        EventsLoadedBinderCallback(zzzv.zzb<Events.LoadEventsResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadEventResultImpl(dataHolder));
        }
    }

    private static final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<GamesMetadata.LoadGamesResult> zzaFq;

        GamesLoadedBinderCallback(zzzv.zzb<GamesMetadata.LoadGamesResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzn(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadGamesResultImpl(dataHolder));
        }
    }

    private static final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Achievements.UpdateAchievementResult> zzaFq;

        AchievementUpdatedBinderCallback(zzzv.zzb<Achievements.UpdateAchievementResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzi(int n, String string) {
            this.zzaFq.setResult((Object)new UpdateAchievementResultImpl(n, string));
        }
    }

    private static final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final zzzv.zzb<Achievements.LoadAchievementsResult> zzaFq;

        AchievementsLoadedBinderCallback(zzzv.zzb<Achievements.LoadAchievementsResult> zzb2) {
            this.zzaFq = (zzzv.zzb)zzac.zzb(zzb2, (Object)"Holder must not be null");
        }

        @Override
        public void zzh(DataHolder dataHolder) {
            this.zzaFq.setResult((Object)new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void zzr(String string, int n) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.zzwW()).zzo(string, n);
                } else {
                    GamesLog.zzF("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                }
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.this.zzd(remoteException);
            }
        }
    }
}

