/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzbdZ;
    private final TurnBasedMatchBuffer zzbea;
    private final TurnBasedMatchBuffer zzbeb;
    private final TurnBasedMatchBuffer zzbec;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.zzbdZ = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.zzbea = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.zzbeb = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        this.zzbec = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zziC(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.zzbdZ;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzbea;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzbeb;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzbec;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.zzbdZ != null) {
            this.zzbdZ.release();
        }
        if (this.zzbea != null) {
            this.zzbea.release();
        }
        if (this.zzbeb != null) {
            this.zzbeb.release();
        }
        if (this.zzbec != null) {
            this.zzbec.release();
        }
    }

    public boolean hasData() {
        if (this.zzbdZ != null && this.zzbdZ.getCount() > 0) {
            return true;
        }
        if (this.zzbea != null && this.zzbea.getCount() > 0) {
            return true;
        }
        if (this.zzbeb != null && this.zzbeb.getCount() > 0) {
            return true;
        }
        return this.zzbec != null && this.zzbec.getCount() > 0;
    }
}

