/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzGy();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzade;
        private Long zzbfl;
        private Long zzbfm;
        private BitmapTeleporter zzbfn;
        private Uri zzbfo;

        public Builder setDescription(String string) {
            this.zzade = string;
            return this;
        }

        public Builder setPlayedTimeMillis(long l) {
            this.zzbfl = l;
            return this;
        }

        public Builder setProgressValue(long l) {
            this.zzbfm = l;
            return this;
        }

        public Builder setCoverImage(Bitmap bitmap) {
            this.zzbfn = new BitmapTeleporter(bitmap);
            this.zzbfo = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzade = snapshotMetadata.getDescription();
            this.zzbfl = snapshotMetadata.getPlayedTime();
            this.zzbfm = snapshotMetadata.getProgressValue();
            if (this.zzbfl == -1L) {
                this.zzbfl = null;
            }
            this.zzbfo = snapshotMetadata.getCoverImageUri();
            if (this.zzbfo != null) {
                this.zzbfn = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzade, this.zzbfl, this.zzbfn, this.zzbfo, this.zzbfm);
        }
    }
}

