/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private String zzavw;
    private String zzakb;
    private final Uri zzaXy;
    private final Uri zzaXz;
    private final long zzaYi;
    private final int zzaYj;
    private final long zzaYk;
    private final String zzaXJ;
    private final String zzaXK;
    private final String zzamJ;
    private final MostRecentGameInfoEntity zzaYl;
    private final PlayerLevelInfo zzaYm;
    private final boolean zzaYn;
    private final boolean zzaYo;
    private final String zzaYp;
    private final String mName;
    private final Uri zzaYq;
    private final String zzaYr;
    private final Uri zzaYs;
    private final String zzaYt;
    private final int zzaYu;
    private final long zzaYv;
    private final boolean zzaaD;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean bl) {
        this.zzavw = bl ? player.getPlayerId() : null;
        this.zzakb = player.getDisplayName();
        this.zzaXy = player.getIconImageUri();
        this.zzaXJ = player.getIconImageUrl();
        this.zzaXz = player.getHiResImageUri();
        this.zzaXK = player.getHiResImageUrl();
        this.zzaYi = player.getRetrievedTimestamp();
        this.zzaYj = player.zzDS();
        this.zzaYk = player.getLastPlayedWithTimestamp();
        this.zzamJ = player.getTitle();
        this.zzaYn = player.zzDT();
        MostRecentGameInfo mostRecentGameInfo = player.zzDU();
        this.zzaYl = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzaYm = player.getLevelInfo();
        this.zzaYo = player.zzDR();
        this.zzaYp = player.zzDQ();
        this.mName = player.getName();
        this.zzaYq = player.getBannerImageLandscapeUri();
        this.zzaYr = player.getBannerImageLandscapeUrl();
        this.zzaYs = player.getBannerImagePortraitUri();
        this.zzaYt = player.getBannerImagePortraitUrl();
        this.zzaYu = player.zzDV();
        this.zzaYv = player.zzDW();
        this.zzaaD = player.isMuted();
        if (bl) {
            zzc.zzt((Object)this.zzavw);
        }
        zzc.zzt((Object)this.zzakb);
        zzc.zzaw((this.zzaYi > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, MostRecentGameInfoEntity mostRecentGameInfoEntity, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzavw = string;
        this.zzakb = string2;
        this.zzaXy = uri;
        this.zzaXJ = string3;
        this.zzaXz = uri2;
        this.zzaXK = string4;
        this.zzaYi = l;
        this.zzaYj = n;
        this.zzaYk = l2;
        this.zzamJ = string5;
        this.zzaYn = bl;
        this.zzaYl = mostRecentGameInfoEntity;
        this.zzaYm = playerLevelInfo;
        this.zzaYo = bl2;
        this.zzaYp = string6;
        this.mName = string7;
        this.zzaYq = uri3;
        this.zzaYr = string8;
        this.zzaYs = uri4;
        this.zzaYt = string9;
        this.zzaYu = n2;
        this.zzaYv = l3;
        this.zzaaD = bl3;
    }

    @Override
    public String getPlayerId() {
        return this.zzavw;
    }

    @Override
    public String getDisplayName() {
        return this.zzakb;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzakb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String zzDQ() {
        return this.zzaYp;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zzDR() {
        return this.zzaYo;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaXy;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaXJ;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaXz;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaXK;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzaYi;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzaYk;
    }

    @Override
    public int zzDS() {
        return this.zzaYj;
    }

    @Override
    public boolean zzDT() {
        return this.zzaYn;
    }

    @Override
    public String getTitle() {
        return this.zzamJ;
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzamJ, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaYm;
    }

    @Override
    public MostRecentGameInfo zzDU() {
        return this.zzaYl;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzaYq;
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.zzaYr;
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzaYs;
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.zzaYt;
    }

    @Override
    public int zzDV() {
        return this.zzaYu;
    }

    @Override
    public long zzDW() {
        return this.zzaYv;
    }

    @Override
    public boolean isMuted() {
        return this.zzaaD;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return zzaa.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzDR(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzDQ(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzDV(), player.zzDW(), player.isMuted()});
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzaa.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzaa.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzaa.equal((Object)player2.zzDR(), (Object)player.zzDR()) && zzaa.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzaa.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzaa.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzaa.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzaa.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzaa.equal((Object)player2.zzDQ(), (Object)player.zzDQ()) && zzaa.equal((Object)player2.getName(), (Object)player.getName()) && zzaa.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzaa.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzaa.equal((Object)player2.zzDV(), (Object)player.zzDV()) && zzaa.equal((Object)player2.zzDW(), (Object)player.zzDW()) && zzaa.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzaa.zzv((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzDR()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzDQ()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzDV()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzDW()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        PlayerEntityCreator.zza(this, parcel, n);
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzfx(Parcel parcel) {
            boolean bl = PlayerEntity.zzf(PlayerEntity.zzxV());
            if (bl || PlayerEntity.zzdl((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzfx(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzfx(parcel);
        }
    }
}

