/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final String zzamX;
    private final String zzakb;
    private final String zzaXv;
    private final String zzaXw;
    private final String zzade;
    private final String zzaXx;
    private final Uri zzaXy;
    private final Uri zzaXz;
    private final Uri zzaXA;
    private final boolean zzaXB;
    private final boolean zzaXC;
    private final String zzaXD;
    private final int zzaXE;
    private final int zzaXF;
    private final int zzaXG;
    private final boolean zzaXH;
    private final boolean zzaXI;
    private final String zzaXJ;
    private final String zzaXK;
    private final String zzaXL;
    private final boolean zzPl;
    private final boolean zzaXM;
    private final boolean zzaXN;
    private final String zzaXO;
    private final boolean zzaXP;

    public GameEntity(Game game) {
        this.zzamX = game.getApplicationId();
        this.zzaXv = game.getPrimaryCategory();
        this.zzaXw = game.getSecondaryCategory();
        this.zzade = game.getDescription();
        this.zzaXx = game.getDeveloperName();
        this.zzakb = game.getDisplayName();
        this.zzaXy = game.getIconImageUri();
        this.zzaXJ = game.getIconImageUrl();
        this.zzaXz = game.getHiResImageUri();
        this.zzaXK = game.getHiResImageUrl();
        this.zzaXA = game.getFeaturedImageUri();
        this.zzaXL = game.getFeaturedImageUrl();
        this.zzaXB = game.zzDJ();
        this.zzaXC = game.zzDL();
        this.zzaXD = game.zzDM();
        this.zzaXE = 1;
        this.zzaXF = game.getAchievementTotalCount();
        this.zzaXG = game.getLeaderboardCount();
        this.zzaXH = game.isRealTimeMultiplayerEnabled();
        this.zzaXI = game.isTurnBasedMultiplayerEnabled();
        this.zzPl = game.isMuted();
        this.zzaXM = game.zzDK();
        this.zzaXN = game.areSnapshotsEnabled();
        this.zzaXO = game.getThemeColor();
        this.zzaXP = game.hasGamepadSupport();
    }

    GameEntity(String string, String string2, String string3, String string4, String string5, String string6, Uri uri, Uri uri2, Uri uri3, boolean bl, boolean bl2, String string7, int n, int n2, int n3, boolean bl3, boolean bl4, String string8, String string9, String string10, boolean bl5, boolean bl6, boolean bl7, String string11, boolean bl8) {
        this.zzamX = string;
        this.zzakb = string2;
        this.zzaXv = string3;
        this.zzaXw = string4;
        this.zzade = string5;
        this.zzaXx = string6;
        this.zzaXy = uri;
        this.zzaXJ = string8;
        this.zzaXz = uri2;
        this.zzaXK = string9;
        this.zzaXA = uri3;
        this.zzaXL = string10;
        this.zzaXB = bl;
        this.zzaXC = bl2;
        this.zzaXD = string7;
        this.zzaXE = n;
        this.zzaXF = n2;
        this.zzaXG = n3;
        this.zzaXH = bl3;
        this.zzaXI = bl4;
        this.zzPl = bl5;
        this.zzaXM = bl6;
        this.zzaXN = bl7;
        this.zzaXO = string11;
        this.zzaXP = bl8;
    }

    @Override
    public String getApplicationId() {
        return this.zzamX;
    }

    @Override
    public String getDisplayName() {
        return this.zzakb;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzakb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzaXv;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzaXw;
    }

    @Override
    public String getDescription() {
        return this.zzade;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzade, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDeveloperName() {
        return this.zzaXx;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzaXx, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaXy;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaXJ;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzaXz;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaXK;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzaXA;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzaXL;
    }

    @Override
    public boolean isMuted() {
        return this.zzPl;
    }

    @Override
    public boolean zzDK() {
        return this.zzaXM;
    }

    @Override
    public boolean zzDJ() {
        return this.zzaXB;
    }

    @Override
    public boolean zzDL() {
        return this.zzaXC;
    }

    @Override
    public String zzDM() {
        return this.zzaXD;
    }

    public int zzDN() {
        return this.zzaXE;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzaXF;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzaXG;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzaXH;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzaXI;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzaXN;
    }

    @Override
    public String getThemeColor() {
        return this.zzaXO;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzaXP;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzaa.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzDJ(), game.zzDL(), game.zzDM(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzDK(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object object) {
        return GameEntity.zza(this, object);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzaa.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzaa.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzaa.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzaa.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzaa.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzaa.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzaa.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzaa.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzaa.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzaa.equal((Object)game2.zzDJ(), (Object)game.zzDJ()) && zzaa.equal((Object)game2.zzDL(), (Object)game.zzDL()) && zzaa.equal((Object)game2.zzDM(), (Object)game.zzDM()) && zzaa.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzaa.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzaa.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzaa.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzaa.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzaa.equal((Object)game2.zzDK(), (Object)game.zzDK()) ? 1 : 0)) && zzaa.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzaa.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzaa.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzaa.zzv((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzDJ()).zzg("InstanceInstalled", (Object)game.zzDL()).zzg("InstancePackageName", (Object)game.zzDM()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        GameEntityCreator.zza(this, parcel, n);
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzfw(Parcel parcel) {
            boolean bl = GameEntity.zzf(GameEntity.zzxV());
            if (bl || GameEntity.zzdl((String)GameEntity.class.getCanonicalName())) {
                return super.zzfw(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            return new GameEntity(string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, false, false, null, null, null, false, false, false, null, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzfw(parcel);
        }
    }
}

