/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;

public final class AchievementEntity
extends GamesAbstractSafeParcelable
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final String zzaYF;
    private final int zzakD;
    private final String mName;
    private final String zzade;
    private final Uri zzaYG;
    private final String zzaYH;
    private final Uri zzaYI;
    private final String zzaYJ;
    private final int zzaYK;
    private final String zzaYL;
    private final PlayerEntity zzaYM;
    private final int mState;
    private final int zzaYN;
    private final String zzaYO;
    private final long zzaYP;
    private final long zzaYQ;

    public AchievementEntity(Achievement achievement) {
        this.zzaYF = achievement.getAchievementId();
        this.zzakD = achievement.getType();
        this.mName = achievement.getName();
        this.zzade = achievement.getDescription();
        this.zzaYG = achievement.getUnlockedImageUri();
        this.zzaYH = achievement.getUnlockedImageUrl();
        this.zzaYI = achievement.getRevealedImageUri();
        this.zzaYJ = achievement.getRevealedImageUrl();
        this.zzaYM = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzaYP = achievement.getLastUpdatedTimestamp();
        this.zzaYQ = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzaYK = achievement.getTotalSteps();
            this.zzaYL = achievement.getFormattedTotalSteps();
            this.zzaYN = achievement.getCurrentSteps();
            this.zzaYO = achievement.getFormattedCurrentSteps();
        } else {
            this.zzaYK = 0;
            this.zzaYL = null;
            this.zzaYN = 0;
            this.zzaYO = null;
        }
        zzc.zzt((Object)this.zzaYF);
        zzc.zzt((Object)this.zzade);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzaYF = string;
        this.zzakD = n;
        this.mName = string2;
        this.zzade = string3;
        this.zzaYG = uri;
        this.zzaYH = string4;
        this.zzaYI = uri2;
        this.zzaYJ = string5;
        this.zzaYK = n2;
        this.zzaYL = string6;
        this.zzaYM = playerEntity;
        this.mState = n3;
        this.zzaYN = n4;
        this.zzaYO = string7;
        this.zzaYP = l;
        this.zzaYQ = l2;
    }

    @Override
    public String getAchievementId() {
        return this.zzaYF;
    }

    @Override
    public int getType() {
        return this.zzakD;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzade;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzade, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzaYG;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzaYH;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzaYI;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzaYJ;
    }

    public int zzEd() {
        return this.zzaYK;
    }

    @Override
    public int getTotalSteps() {
        zzc.zzaw((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzEd();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzc.zzaw((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzEe();
    }

    public String zzEe() {
        return this.zzaYL;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        zzc.zzaw((this.getType() == 1 ? 1 : 0) != 0);
        zzh.zzb((String)this.zzaYL, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Player getPlayer() {
        return this.zzaYM;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzc.zzaw((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzEf();
    }

    public int zzEf() {
        return this.zzaYN;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzc.zzaw((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzEg();
    }

    public String zzEg() {
        return this.zzaYO;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        zzc.zzaw((this.getType() == 1 ? 1 : 0) != 0);
        zzh.zzb((String)this.zzaYO, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaYP;
    }

    @Override
    public long getXpValue() {
        return this.zzaYQ;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzaa.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object object) {
        return AchievementEntity.zza(this, object);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzaa.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzaa.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzaa.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzaa.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzaa.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzaa.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzaa.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzaa.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzaa.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzaa.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzaa.zza zza2 = zzaa.zzv((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        AchievementEntityCreator.zza(this, parcel, n);
    }
}

