/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzbdA;
    private final String zzakb;
    private final Uri zzaXy;
    private final int zzbdB;
    private final ArrayList<LeaderboardVariantEntity> zzbdC;
    private final Game zzbdD;
    private final String zzaXJ;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzbdA = leaderboard.getLeaderboardId();
        this.zzakb = leaderboard.getDisplayName();
        this.zzaXy = leaderboard.getIconImageUri();
        this.zzaXJ = leaderboard.getIconImageUrl();
        this.zzbdB = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzbdD = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzbdC = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzbdC.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.zzbdA;
    }

    @Override
    public String getDisplayName() {
        return this.zzakb;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzakb, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaXy;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaXJ;
    }

    @Override
    public int getScoreOrder() {
        return this.zzbdB;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzbdC);
    }

    @Override
    public Game getGame() {
        return this.zzbdD;
    }

    public Leaderboard zzGn() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return zzaa.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzaa.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzaa.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzaa.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzaa.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzaa.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzaa.zzv((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzGn();
    }
}

