/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;

public final class MilestoneRef
extends zzc
implements Milestone {
    MilestoneRef(DataHolder dataHolder, int n) {
        super(dataHolder, n);
    }

    @Override
    public String getMilestoneId() {
        return this.getString("external_milestone_id");
    }

    @Override
    public long getCurrentProgress() {
        long l;
        switch (this.getState()) {
            case 3: 
            case 4: {
                l = this.getTargetProgress();
                break;
            }
            case 1: {
                l = 0L;
                break;
            }
            case 2: {
                l = this.getLong("current_value");
                if (this.getLong("quest_state") == 6L) break;
                l -= this.zzGv();
                break;
            }
            default: {
                l = 0L;
            }
        }
        if (l < 0L) {
            GamesLog.zzG("MilestoneRef", "Current progress should never be negative");
            l = 0L;
        }
        if (l > this.getTargetProgress()) {
            GamesLog.zzG("MilestoneRef", "Current progress should never exceed target progress");
            l = this.getTargetProgress();
        }
        return l;
    }

    @Override
    public String getEventId() {
        return this.getString("external_event_id");
    }

    private long zzGv() {
        return this.getLong("initial_value");
    }

    @Override
    public long getTargetProgress() {
        return this.getLong("target_value");
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.getByteArray("completion_reward_data");
    }

    @Override
    public int getState() {
        return this.getInteger("milestone_state");
    }

    public Milestone freeze() {
        return new MilestoneEntity(this);
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    public boolean equals(Object object) {
        return MilestoneEntity.zza(this, object);
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        MilestoneEntity milestoneEntity = (MilestoneEntity)((Milestone)this.freeze());
        milestoneEntity.writeToParcel(parcel, n);
    }
}

