/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import java.util.Arrays;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzbcV;
    private final String zzbcW;
    private final String zzbcX;
    private final long zzbcY;
    private final long zzbcZ;
    private final String zzbda;
    private final Uri zzbdb;
    private final Uri zzbdc;
    private final PlayerEntity zzbdd;
    private final String zzbde;
    private final String zzbdf;
    private final String zzbdg;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.zzbcV = leaderboardScore.getRank();
        this.zzbcW = (String)zzbr.zzu((Object)leaderboardScore.getDisplayRank());
        this.zzbcX = (String)zzbr.zzu((Object)leaderboardScore.getDisplayScore());
        this.zzbcY = leaderboardScore.getRawScore();
        this.zzbcZ = leaderboardScore.getTimestampMillis();
        this.zzbda = leaderboardScore.getScoreHolderDisplayName();
        this.zzbdb = leaderboardScore.getScoreHolderIconImageUri();
        this.zzbdc = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.zzbdd = player == null ? null : (PlayerEntity)player.freeze();
        this.zzbde = leaderboardScore.getScoreTag();
        this.zzbdf = leaderboardScore.getScoreHolderIconImageUrl();
        this.zzbdg = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public final long getRank() {
        return this.zzbcV;
    }

    @Override
    public final String getDisplayRank() {
        return this.zzbcW;
    }

    @Override
    public final void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzi.zzb((String)this.zzbcW, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDisplayScore() {
        return this.zzbcX;
    }

    @Override
    public final void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzi.zzb((String)this.zzbcX, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getRawScore() {
        return this.zzbcY;
    }

    @Override
    public final long getTimestampMillis() {
        return this.zzbcZ;
    }

    @Override
    public final String getScoreHolderDisplayName() {
        if (this.zzbdd == null) {
            return this.zzbda;
        }
        return this.zzbdd.getDisplayName();
    }

    @Override
    public final void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzbdd == null) {
            zzi.zzb((String)this.zzbda, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzbdd.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getScoreHolderIconImageUri() {
        if (this.zzbdd == null) {
            return this.zzbdb;
        }
        return this.zzbdd.getIconImageUri();
    }

    @Override
    public final String getScoreHolderIconImageUrl() {
        if (this.zzbdd == null) {
            return this.zzbdf;
        }
        return this.zzbdd.getIconImageUrl();
    }

    @Override
    public final Uri getScoreHolderHiResImageUri() {
        if (this.zzbdd == null) {
            return this.zzbdc;
        }
        return this.zzbdd.getHiResImageUri();
    }

    @Override
    public final String getScoreHolderHiResImageUrl() {
        if (this.zzbdd == null) {
            return this.zzbdg;
        }
        return this.zzbdd.getHiResImageUrl();
    }

    @Override
    public final Player getScoreHolder() {
        return this.zzbdd;
    }

    @Override
    public final String getScoreTag() {
        return this.zzbde;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return Arrays.hashCode(new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public final boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzbh.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzbh.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzbh.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzbh.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzbh.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzbh.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzbh.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzbh.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzbh.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzbh.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public final String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzbh.zzt((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }
}

