/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.zze;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzbdU;
    private final TurnBasedMatchBuffer zzbdV;
    private final TurnBasedMatchBuffer zzbdW;
    private final TurnBasedMatchBuffer zzbdX;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.zzbdU = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.zzbdV = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.zzbdW = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        if (dataHolder4 != null) {
            this.zzbdX = new TurnBasedMatchBuffer(dataHolder4);
            return;
        }
        this.zzbdX = null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                String string2 = "TURN_STATUS_INVITED";
                break;
            }
            case 1: {
                String string2 = "TURN_STATUS_MY_TURN";
                break;
            }
            case 2: {
                String string2 = "TURN_STATUS_THEIR_TURN";
                break;
            }
            case 3: {
                String string2 = "TURN_STATUS_COMPLETE";
                break;
            }
            default: {
                zze.zzz("MatchTurnStatus", new StringBuilder(38).append("Unknown match turn status: ").append(n2).toString());
                String string2 = string = "TURN_STATUS_UNKNOWN";
            }
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public final InvitationBuffer getInvitations() {
        return this.zzbdU;
    }

    public final TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzbdV;
    }

    public final TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzbdW;
    }

    public final TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzbdX;
    }

    @Deprecated
    public final void close() {
        this.release();
    }

    public final void release() {
        if (this.zzbdU != null) {
            this.zzbdU.release();
        }
        if (this.zzbdV != null) {
            this.zzbdV.release();
        }
        if (this.zzbdW != null) {
            this.zzbdW.release();
        }
        if (this.zzbdX != null) {
            this.zzbdX.release();
        }
    }

    public final boolean hasData() {
        if (this.zzbdU != null && this.zzbdU.getCount() > 0) {
            return true;
        }
        if (this.zzbdV != null && this.zzbdV.getCount() > 0) {
            return true;
        }
        if (this.zzbdW != null && this.zzbdW.getCount() > 0) {
            return true;
        }
        return this.zzbdX != null && this.zzbdX.getCount() > 0;
    }
}

