/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.zzb;
import java.util.ArrayList;
import java.util.List;

public final class QuestRef
extends zzc
implements Quest {
    private final Game zzbcS;
    private final int zzbcT;

    QuestRef(DataHolder dataHolder, int n, int n2) {
        super(dataHolder, n);
        this.zzbcS = new GameRef(dataHolder, n);
        this.zzbcT = n2;
    }

    @Override
    public final String getQuestId() {
        return this.getString("external_quest_id");
    }

    @Override
    public final String getName() {
        return this.getString("quest_name");
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        this.zza("quest_name", charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.getString("quest_description");
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        this.zza("quest_description", charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzcw("quest_icon_image_uri");
    }

    @Override
    public final String getIconImageUrl() {
        return this.getString("quest_icon_image_url");
    }

    @Override
    public final Uri getBannerImageUri() {
        return this.zzcw("quest_banner_image_uri");
    }

    @Override
    public final String getBannerImageUrl() {
        return this.getString("quest_banner_image_url");
    }

    @Override
    public final Milestone getCurrentMilestone() {
        return this.zzvs().get(0);
    }

    @Override
    public final List<Milestone> zzvs() {
        ArrayList<Milestone> arrayList = new ArrayList<Milestone>(this.zzbcT);
        for (int i = 0; i < this.zzbcT; ++i) {
            arrayList.add(new zzb(this.zzaCZ, this.zzaFz + i));
        }
        return arrayList;
    }

    @Override
    public final Game getGame() {
        return this.zzbcS;
    }

    @Override
    public final int getState() {
        return this.getInteger("quest_state");
    }

    @Override
    public final int getType() {
        return this.getInteger("quest_type");
    }

    @Override
    public final long getAcceptedTimestamp() {
        return this.getLong("accepted_ts");
    }

    @Override
    public final long getEndTimestamp() {
        return this.getLong("quest_end_ts");
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.getLong("quest_last_updated_ts");
    }

    @Override
    public final long zzvt() {
        return this.getLong("notification_ts");
    }

    @Override
    public final long getStartTimestamp() {
        return this.getLong("quest_start_ts");
    }

    @Override
    public final boolean isEndingSoon() {
        return this.getLong("notification_ts") <= System.currentTimeMillis() + 1800000L;
    }

    public final int hashCode() {
        return QuestEntity.zza(this);
    }

    public final boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    public final String toString() {
        return QuestEntity.zzb(this);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        ((QuestEntity)((Quest)this.freeze())).writeToParcel(parcel, n);
    }

    public final /* synthetic */ Object freeze() {
        QuestRef questRef = this;
        return new QuestEntity(questRef);
    }
}

