/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.zzc;
import java.util.Arrays;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new zza();
    private final String zzbah;
    private final String zzalP;
    private final Uri zzaXU;
    private final Uri zzaXV;
    private final int zzLg;
    private final String zzbdx;
    private final boolean zzbdy;
    private final PlayerEntity zzaZi;
    private final int zzapi;
    private final ParticipantResult zzbdz;
    private final String zzaYf;
    private final String zzaYg;

    public ParticipantEntity(Participant participant) {
        this.zzbah = participant.getParticipantId();
        this.zzalP = participant.getDisplayName();
        this.zzaXU = participant.getIconImageUri();
        this.zzaXV = participant.getHiResImageUri();
        this.zzLg = participant.getStatus();
        this.zzbdx = participant.zzvr();
        this.zzbdy = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaZi = player == null ? null : new PlayerEntity(player);
        this.zzapi = participant.getCapabilities();
        this.zzbdz = participant.getResult();
        this.zzaYf = participant.getIconImageUrl();
        this.zzaYg = participant.getHiResImageUrl();
    }

    ParticipantEntity(String string, String string2, Uri uri, Uri uri2, int n, String string3, boolean bl, PlayerEntity playerEntity, int n2, ParticipantResult participantResult, String string4, String string5) {
        this.zzbah = string;
        this.zzalP = string2;
        this.zzaXU = uri;
        this.zzaXV = uri2;
        this.zzLg = n;
        this.zzbdx = string3;
        this.zzbdy = bl;
        this.zzaZi = playerEntity;
        this.zzapi = n2;
        this.zzbdz = participantResult;
        this.zzaYf = string4;
        this.zzaYg = string5;
    }

    @Override
    public final int getStatus() {
        return this.zzLg;
    }

    @Override
    public final String zzvr() {
        return this.zzbdx;
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.zzbdy;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzaZi == null) {
            return this.zzalP;
        }
        return this.zzaZi.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzaZi == null) {
            zzh.zzb((String)this.zzalP, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzaZi.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzaZi == null) {
            return this.zzaXU;
        }
        return this.zzaZi.getIconImageUri();
    }

    @Override
    public final String getIconImageUrl() {
        if (this.zzaZi == null) {
            return this.zzaYf;
        }
        return this.zzaZi.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzaZi == null) {
            return this.zzaXV;
        }
        return this.zzaZi.getHiResImageUri();
    }

    @Override
    public final String getHiResImageUrl() {
        if (this.zzaZi == null) {
            return this.zzaYg;
        }
        return this.zzaZi.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.zzbah;
    }

    @Override
    public final Player getPlayer() {
        return this.zzaZi;
    }

    @Override
    public final ParticipantResult getResult() {
        return this.zzbdz;
    }

    @Override
    public final int getCapabilities() {
        return this.zzapi;
    }

    public final Participant freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return Arrays.hashCode(new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzvr(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzbe.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzbe.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzbe.equal((Object)participant2.zzvr(), (Object)participant.zzvr()) && zzbe.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzbe.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzbe.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzbe.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzbe.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzbe.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzbe.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzbe.zzt((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzvr()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ParticipantEntity participantEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)participantEntity.getParticipantId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)participantEntity.getDisplayName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)participantEntity.getIconImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)participantEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)participantEntity.getStatus());
        zzd.zza((Parcel)parcel2, (int)6, (String)participantEntity.zzbdx, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)participantEntity.isConnectedToRoom());
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)participantEntity.getPlayer(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)9, (int)participantEntity.zzapi);
        zzd.zza((Parcel)parcel2, (int)10, (Parcelable)participantEntity.getResult(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)11, (String)participantEntity.getIconImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)12, (String)participantEntity.getHiResImageUrl(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzc {
        zza() {
        }

        @Override
        public final ParticipantEntity zzi(Parcel parcel) {
            if (ParticipantEntity.zze(ParticipantEntity.zzrx()) || ParticipantEntity.zzcA((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzi(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl = parcel.readInt() > 0;
            PlayerEntity playerEntity = parcel.readInt() > 0 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n, string5, bl, playerEntity, 7, null, null, null);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzi(parcel);
        }
    }
}

