/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.zze;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzbdQ;
    private final TurnBasedMatchBuffer zzbdR;
    private final TurnBasedMatchBuffer zzbdS;
    private final TurnBasedMatchBuffer zzbdT;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.zzbdQ = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.zzbdR = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.zzbdS = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        if (dataHolder4 != null) {
            this.zzbdT = new TurnBasedMatchBuffer(dataHolder4);
            return;
        }
        this.zzbdT = null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                String string2 = "TURN_STATUS_INVITED";
                break;
            }
            case 1: {
                String string2 = "TURN_STATUS_MY_TURN";
                break;
            }
            case 2: {
                String string2 = "TURN_STATUS_THEIR_TURN";
                break;
            }
            case 3: {
                String string2 = "TURN_STATUS_COMPLETE";
                break;
            }
            default: {
                zze.zzz("MatchTurnStatus", new StringBuilder(38).append("Unknown match turn status: ").append(n2).toString());
                String string2 = string = "TURN_STATUS_UNKNOWN";
            }
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public final InvitationBuffer getInvitations() {
        return this.zzbdQ;
    }

    public final TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzbdR;
    }

    public final TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzbdS;
    }

    public final TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzbdT;
    }

    @Deprecated
    public final void close() {
        this.release();
    }

    public final void release() {
        if (this.zzbdQ != null) {
            this.zzbdQ.release();
        }
        if (this.zzbdR != null) {
            this.zzbdR.release();
        }
        if (this.zzbdS != null) {
            this.zzbdS.release();
        }
        if (this.zzbdT != null) {
            this.zzbdT.release();
        }
    }

    public final boolean hasData() {
        if (this.zzbdQ != null && this.zzbdQ.getCount() > 0) {
            return true;
        }
        if (this.zzbdR != null && this.zzbdR.getCount() > 0) {
            return true;
        }
        if (this.zzbdS != null && this.zzbdS.getCount() > 0) {
            return true;
        }
        return this.zzbdT != null && this.zzbdT.getCount() > 0;
    }
}

