/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.games.video.zzb;

public final class VideoConfiguration
extends zza {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zzbfi;
    private final int zzbfb;
    private final String zzbfj;
    private final String zzbfk;
    private final String zzbfl;
    private final String zzbfm;
    private final boolean zzbfn;

    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzbo.zzaf((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzbo.zzaf((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zzbfi = n;
        this.zzbfb = n2;
        this.zzbfn = bl;
        if (n2 == 1) {
            this.zzbfk = string2;
            this.zzbfj = string;
            this.zzbfl = string3;
            this.zzbfm = string4;
            return;
        }
        zzbo.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
        zzbo.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
        zzbo.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
        zzbo.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
        this.zzbfk = null;
        this.zzbfj = null;
        this.zzbfl = null;
        this.zzbfm = null;
    }

    public final int getQualityLevel() {
        return this.zzbfi;
    }

    public final int getCaptureMode() {
        return this.zzbfb;
    }

    public final String getStreamUrl() {
        return this.zzbfj;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoConfiguration videoConfiguration = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)videoConfiguration.getQualityLevel());
        zzd.zzc((Parcel)parcel2, (int)2, (int)videoConfiguration.getCaptureMode());
        zzd.zza((Parcel)parcel2, (int)3, (String)videoConfiguration.getStreamUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)videoConfiguration.zzbfk, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)videoConfiguration.zzbfl, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)videoConfiguration.zzbfm, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (boolean)videoConfiguration.zzbfn);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzbfi;
        private int zzbfb;
        private boolean zzbfn;
        private String zzbfj;
        private String zzbfk;
        private String zzbfl;
        private String zzbfm;

        public Builder(int n, int n2) {
            this.zzbfi = n;
            this.zzbfb = n2;
            this.zzbfn = true;
            this.zzbfj = null;
            this.zzbfk = null;
            this.zzbfl = null;
            this.zzbfm = null;
        }

        public final Builder setQualityLevel(int n) {
            this.zzbfi = n;
            return this;
        }

        public final Builder setCaptureMode(int n) {
            this.zzbfb = n;
            return this;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zzbfi, this.zzbfb, null, null, null, null, this.zzbfn);
        }
    }
}

