/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.zza;
import java.util.Arrays;

public final class MilestoneEntity
extends zzc
implements Milestone {
    public static final Parcelable.Creator<MilestoneEntity> CREATOR = new zza();
    private final String zzbak;
    private final long zzbef;
    private final long zzbeg;
    private final byte[] zzbeh;
    private final int mState;
    private final String zzaZn;

    public MilestoneEntity(Milestone milestone) {
        this.zzbak = milestone.getMilestoneId();
        this.zzbef = milestone.getCurrentProgress();
        this.zzbeg = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.zzaZn = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.zzbeh = null;
            return;
        }
        this.zzbeh = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.zzbeh, 0, byArray.length);
    }

    MilestoneEntity(String string, long l, long l2, byte[] byArray, int n, String string2) {
        this.zzbak = string;
        this.zzbef = l;
        this.zzbeg = l2;
        this.zzbeh = byArray;
        this.mState = n;
        this.zzaZn = string2;
    }

    @Override
    public final String getEventId() {
        return this.zzaZn;
    }

    @Override
    public final String getMilestoneId() {
        return this.zzbak;
    }

    @Override
    public final long getCurrentProgress() {
        return this.zzbef;
    }

    @Override
    public final long getTargetProgress() {
        return this.zzbeg;
    }

    @Override
    public final byte[] getCompletionRewardData() {
        return this.zzbeh;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    public final Milestone freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return Arrays.hashCode(new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public final boolean equals(Object object) {
        return MilestoneEntity.zza(this, object);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzbe.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzbe.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzbe.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzbe.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzbe.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public final String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzbe.zzt((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        MilestoneEntity milestoneEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)milestoneEntity.getMilestoneId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (long)milestoneEntity.getCurrentProgress());
        zzd.zza((Parcel)parcel2, (int)3, (long)milestoneEntity.getTargetProgress());
        zzd.zza((Parcel)parcel2, (int)4, (byte[])milestoneEntity.getCompletionRewardData(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)5, (int)milestoneEntity.getState());
        zzd.zza((Parcel)parcel2, (int)6, (String)milestoneEntity.getEventId(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

