/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zze;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new zze();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzvv();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzafa;
        private Long zzbez;
        private Long zzbeA;
        private BitmapTeleporter zzbeB;
        private Uri zzbeC;

        public final Builder setDescription(String string) {
            this.zzafa = string;
            return this;
        }

        public final Builder setPlayedTimeMillis(long l) {
            this.zzbez = l;
            return this;
        }

        public final Builder setProgressValue(long l) {
            this.zzbeA = l;
            return this;
        }

        public final Builder setCoverImage(Bitmap bitmap) {
            this.zzbeB = new BitmapTeleporter(bitmap);
            this.zzbeC = null;
            return this;
        }

        public final Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzafa = snapshotMetadata.getDescription();
            this.zzbez = snapshotMetadata.getPlayedTime();
            this.zzbeA = snapshotMetadata.getProgressValue();
            if (this.zzbez == -1L) {
                this.zzbez = null;
            }
            this.zzbeC = snapshotMetadata.getCoverImageUri();
            if (this.zzbeC != null) {
                this.zzbeB = null;
            }
            return this;
        }

        public final SnapshotMetadataChange build() {
            return new zze(this.zzafa, this.zzbez, this.zzbeB, this.zzbeC, this.zzbeA);
        }
    }
}

