/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbe;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zzaZb;
    private final int zzamr;
    private final String mName;
    private final String zzafa;
    private final Uri zzaZc;
    private final String zzaZd;
    private final Uri zzaZe;
    private final String zzaZf;
    private final int zzaZg;
    private final String zzaZh;
    private final PlayerEntity zzaZi;
    private final int mState;
    private final int zzaZj;
    private final String zzaZk;
    private final long zzaZl;
    private final long zzaZm;

    public AchievementEntity(Achievement achievement) {
        this.zzaZb = achievement.getAchievementId();
        this.zzamr = achievement.getType();
        this.mName = achievement.getName();
        this.zzafa = achievement.getDescription();
        this.zzaZc = achievement.getUnlockedImageUri();
        this.zzaZd = achievement.getUnlockedImageUrl();
        this.zzaZe = achievement.getRevealedImageUri();
        this.zzaZf = achievement.getRevealedImageUrl();
        this.zzaZi = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzaZl = achievement.getLastUpdatedTimestamp();
        this.zzaZm = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzaZg = achievement.getTotalSteps();
            this.zzaZh = achievement.getFormattedTotalSteps();
            this.zzaZj = achievement.getCurrentSteps();
            this.zzaZk = achievement.getFormattedCurrentSteps();
        } else {
            this.zzaZg = 0;
            this.zzaZh = null;
            this.zzaZj = 0;
            this.zzaZk = null;
        }
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzaZb);
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzafa);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzaZb = string;
        this.zzamr = n;
        this.mName = string2;
        this.zzafa = string3;
        this.zzaZc = uri;
        this.zzaZd = string4;
        this.zzaZe = uri2;
        this.zzaZf = string5;
        this.zzaZg = n2;
        this.zzaZh = string6;
        this.zzaZi = playerEntity;
        this.mState = n3;
        this.zzaZj = n4;
        this.zzaZk = string7;
        this.zzaZl = l;
        this.zzaZm = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zzaZb;
    }

    @Override
    public final int getType() {
        return this.zzamr;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzafa;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzafa, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zzaZc;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzaZd;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzaZe;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzaZf;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzaZg;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzaZh;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        zzh.zzb((String)this.zzaZh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzaZi;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzaZj;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzaZk;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzae((this.getType() == 1 ? 1 : 0) != 0);
        zzh.zzb((String)this.zzaZk, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzaZl;
    }

    @Override
    public final long getXpValue() {
        return this.zzaZm;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbe.equal((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbe.equal((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbe.equal((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbe.equal((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbe.equal((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbe.equal((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbe.equal((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbe.equal((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbe.equal((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbe.equal((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbg zzbg2 = zzbe.zzt((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbg2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbg2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbg2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzd.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)9, (int)achievementEntity.zzaZg);
        zzd.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzaZh, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzd.zzc((Parcel)parcel2, (int)13, (int)achievementEntity.zzaZj);
        zzd.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzaZk, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzd.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzd.zzI((Parcel)parcel2, (int)n2);
    }
}

