/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.zzb;
import com.google.android.gms.games.zzg;
import java.util.Arrays;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new zza();
    private String zzezq;
    private String zzeby;
    private final Uri zzhbd;
    private final Uri zzhbe;
    private final long zzhcn;
    private final int zzhco;
    private final long zzhcp;
    private final String zzhbo;
    private final String zzhbp;
    private final String zzehi;
    private final zzb zzhcq;
    private final PlayerLevelInfo zzhcr;
    private final boolean zzhcs;
    private final boolean zzhct;
    private final String zzhcu;
    private final String mName;
    private final Uri zzhcv;
    private final String zzhcw;
    private final Uri zzhcx;
    private final String zzhcy;
    private final int zzhcz;
    private final long zzhda;
    private final boolean zzdhy;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    private PlayerEntity(Player player, boolean bl) {
        this.zzezq = player.getPlayerId();
        this.zzeby = player.getDisplayName();
        this.zzhbd = player.getIconImageUri();
        this.zzhbo = player.getIconImageUrl();
        this.zzhbe = player.getHiResImageUri();
        this.zzhbp = player.getHiResImageUrl();
        this.zzhcn = player.getRetrievedTimestamp();
        this.zzhco = player.zzapo();
        this.zzhcp = player.getLastPlayedWithTimestamp();
        this.zzehi = player.getTitle();
        this.zzhcs = player.zzapp();
        com.google.android.gms.games.internal.player.zza zza2 = player.zzapq();
        this.zzhcq = zza2 == null ? null : new zzb(zza2);
        this.zzhcr = player.getLevelInfo();
        this.zzhct = player.zzapn();
        this.zzhcu = player.zzapm();
        this.mName = player.getName();
        this.zzhcv = player.getBannerImageLandscapeUri();
        this.zzhcw = player.getBannerImageLandscapeUrl();
        this.zzhcx = player.getBannerImagePortraitUri();
        this.zzhcy = player.getBannerImagePortraitUrl();
        this.zzhcz = player.zzapr();
        this.zzhda = player.zzaps();
        this.zzdhy = player.isMuted();
        zzc.zzr((Object)this.zzezq);
        zzc.zzr((Object)this.zzeby);
        zzc.zzbg((this.zzhcn > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(String string, String string2, Uri uri, Uri uri2, long l, int n, long l2, String string3, String string4, String string5, zzb zzb2, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n2, long l3, boolean bl3) {
        this.zzezq = string;
        this.zzeby = string2;
        this.zzhbd = uri;
        this.zzhbo = string3;
        this.zzhbe = uri2;
        this.zzhbp = string4;
        this.zzhcn = l;
        this.zzhco = n;
        this.zzhcp = l2;
        this.zzehi = string5;
        this.zzhcs = bl;
        this.zzhcq = zzb2;
        this.zzhcr = playerLevelInfo;
        this.zzhct = bl2;
        this.zzhcu = string6;
        this.mName = string7;
        this.zzhcv = uri3;
        this.zzhcw = string8;
        this.zzhcx = uri4;
        this.zzhcy = string9;
        this.zzhcz = n2;
        this.zzhda = l3;
        this.zzdhy = bl3;
    }

    @Override
    public final String getPlayerId() {
        return this.zzezq;
    }

    @Override
    public final String getDisplayName() {
        return this.zzeby;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzg.zzb((String)this.zzeby, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String zzapm() {
        return this.zzhcu;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final boolean zzapn() {
        return this.zzhct;
    }

    @Override
    public final boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhbd;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhbo;
    }

    @Override
    public final boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public final Uri getHiResImageUri() {
        return this.zzhbe;
    }

    @Override
    public final String getHiResImageUrl() {
        return this.zzhbp;
    }

    @Override
    public final long getRetrievedTimestamp() {
        return this.zzhcn;
    }

    @Override
    public final long getLastPlayedWithTimestamp() {
        return this.zzhcp;
    }

    @Override
    public final int zzapo() {
        return this.zzhco;
    }

    @Override
    public final boolean zzapp() {
        return this.zzhcs;
    }

    @Override
    public final String getTitle() {
        return this.zzehi;
    }

    @Override
    public final void getTitle(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.util.zzg.zzb((String)this.zzehi, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final PlayerLevelInfo getLevelInfo() {
        return this.zzhcr;
    }

    @Override
    public final com.google.android.gms.games.internal.player.zza zzapq() {
        return this.zzhcq;
    }

    @Override
    public final Uri getBannerImageLandscapeUri() {
        return this.zzhcv;
    }

    @Override
    public final String getBannerImageLandscapeUrl() {
        return this.zzhcw;
    }

    @Override
    public final Uri getBannerImagePortraitUri() {
        return this.zzhcx;
    }

    @Override
    public final String getBannerImagePortraitUrl() {
        return this.zzhcy;
    }

    @Override
    public final int zzapr() {
        return this.zzhcz;
    }

    @Override
    public final long zzaps() {
        return this.zzhda;
    }

    @Override
    public final boolean isMuted() {
        return this.zzdhy;
    }

    public final Player freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return PlayerEntity.zza(this);
    }

    static int zza(Player player) {
        return Arrays.hashCode(new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzapn(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzapm(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzapr(), player.zzaps(), player.isMuted()});
    }

    public final boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzbf.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzbf.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzbf.equal((Object)player2.zzapn(), (Object)player.zzapn()) && zzbf.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzbf.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzbf.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzbf.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzbf.equal((Object)((Object)player2.getLevelInfo()), (Object)((Object)player.getLevelInfo())) && zzbf.equal((Object)player2.zzapm(), (Object)player.zzapm()) && zzbf.equal((Object)player2.getName(), (Object)player.getName()) && zzbf.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzbf.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzbf.equal((Object)player2.zzapr(), (Object)player.zzapr()) && zzbf.equal((Object)player2.zzaps(), (Object)player.zzaps()) && zzbf.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public final String toString() {
        return PlayerEntity.zzb(this);
    }

    static String zzb(Player player) {
        return zzbf.zzt((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzapn()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzapm()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzapr()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzaps()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlayerEntity playerEntity = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)playerEntity.getPlayerId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)playerEntity.getDisplayName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)playerEntity.getIconImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)playerEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (long)playerEntity.getRetrievedTimestamp());
        zzd.zzc((Parcel)parcel2, (int)6, (int)playerEntity.zzhco);
        zzd.zza((Parcel)parcel2, (int)7, (long)playerEntity.getLastPlayedWithTimestamp());
        zzd.zza((Parcel)parcel2, (int)8, (String)playerEntity.getIconImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)playerEntity.getHiResImageUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)14, (String)playerEntity.getTitle(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)15, (Parcelable)playerEntity.zzhcq, (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)16, (Parcelable)playerEntity.getLevelInfo(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)18, (boolean)playerEntity.zzhcs);
        zzd.zza((Parcel)parcel2, (int)19, (boolean)playerEntity.zzhct);
        zzd.zza((Parcel)parcel2, (int)20, (String)playerEntity.zzhcu, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)21, (String)playerEntity.mName, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)22, (Parcelable)playerEntity.getBannerImageLandscapeUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)23, (String)playerEntity.getBannerImageLandscapeUrl(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)24, (Parcelable)playerEntity.getBannerImagePortraitUri(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)25, (String)playerEntity.getBannerImagePortraitUrl(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)26, (int)playerEntity.zzhcz);
        zzd.zza((Parcel)parcel2, (int)27, (long)playerEntity.zzhda);
        zzd.zza((Parcel)parcel2, (int)28, (boolean)playerEntity.zzdhy);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzg {
        zza() {
        }

        @Override
        public final PlayerEntity zzj(Parcel parcel) {
            if (PlayerEntity.zze(PlayerEntity.zzakc()) || PlayerEntity.zzga((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzj(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            return new PlayerEntity(string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzg)this).zzj(parcel);
        }
    }
}

