/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.zzb;
import java.util.ArrayList;
import java.util.Arrays;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzhku;
    private final String zzeby;
    private final Uri zzhbd;
    private final int zzhkv;
    private final ArrayList<zzb> zzhkw;
    private final Game zzhkx;
    private final String zzhbo;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzhku = leaderboard.getLeaderboardId();
        this.zzeby = leaderboard.getDisplayName();
        this.zzhbd = leaderboard.getIconImageUri();
        this.zzhbo = leaderboard.getIconImageUrl();
        this.zzhkv = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzhkx = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzhkw = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzhkw.add((zzb)arrayList.get(i).freeze());
        }
    }

    @Override
    public final String getLeaderboardId() {
        return this.zzhku;
    }

    @Override
    public final String getDisplayName() {
        return this.zzeby;
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzeby, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhbd;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhbo;
    }

    @Override
    public final int getScoreOrder() {
        return this.zzhkv;
    }

    @Override
    public final ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzhkw);
    }

    @Override
    public final Game getGame() {
        return this.zzhkx;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return Arrays.hashCode(new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public final boolean equals(Object object) {
        return LeaderboardEntity.zza(this, object);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzbf.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzbf.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzbf.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzbf.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzbf.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public final String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzbf.zzt((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }
}

