/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.GamesStatusCodes;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsBuffer;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.CaptureState;
import com.google.android.gms.games.video.VideoCapabilities;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzbvo;
import com.google.android.gms.internal.zzbvq;
import com.google.android.gms.internal.zzbvr;
import com.google.android.gms.internal.zzcqc;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class GamesClientImpl
extends com.google.android.gms.common.internal.zzaa<com.google.android.gms.games.internal.zzj> {
    private zzbvq zzhdy = new com.google.android.gms.games.internal.zzd(this);
    private final String zzhdz;
    private PlayerEntity zzhea;
    private GameEntity zzheb;
    private final com.google.android.gms.games.internal.zzn zzhec;
    private boolean zzhed = false;
    private final Binder zzhee;
    private final long zzhef;
    private final Games.GamesOptions zzheg;
    private boolean zzheh = false;

    public GamesClientImpl(Context context, Looper looper, com.google.android.gms.common.internal.zzq zzq2, Games.GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 1, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzhdz = zzq2.zzaju();
        this.zzhee = new Binder();
        int n = zzq2.zzajq();
        GamesClientImpl gamesClientImpl = this;
        this.zzhec = new com.google.android.gms.games.internal.zzq(gamesClientImpl, n);
        this.zzhef = ((Object)((Object)this)).hashCode();
        this.zzheg = gamesOptions;
        if (!this.zzheg.zzhcl) {
            this.zzs(zzq2.zzajw());
        }
    }

    public final boolean zzaaa() {
        return true;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzhed = false;
    }

    public final void zzdc(int n) {
        int n2;
        this.zzhec.zzhgu.gravity = n2 = n;
    }

    public final void zzs(View view) {
        this.zzhec.zzt(view);
    }

    protected final Set<Scope> zzb(Set<Scope> set) {
        boolean bl = false;
        boolean bl2 = false;
        Scope scope = new Scope("https://www.googleapis.com/auth/games");
        Scope scope2 = new Scope("https://www.googleapis.com/auth/games.firstparty");
        for (Scope scope3 : set) {
            if (scope3.equals((Object)scope)) {
                bl = true;
                continue;
            }
            if (!scope3.equals((Object)scope2)) continue;
            bl2 = true;
        }
        if (bl2) {
            com.google.android.gms.common.internal.zzbp.zza((!bl ? 1 : 0) != 0, (String)"Cannot have both %s and %s!", (Object[])new Object[]{"https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"});
        } else {
            com.google.android.gms.common.internal.zzbp.zza((boolean)bl, (String)"Games APIs requires %s to function.", (Object[])new Object[]{"https://www.googleapis.com/auth/games"});
        }
        return set;
    }

    public final void zza(com.google.android.gms.common.internal.zzj zzj2) {
        GamesClientImpl gamesClientImpl = this;
        this.zzhea = null;
        gamesClientImpl.zzheb = null;
        super.zza(zzj2);
    }

    public final void disconnect() {
        this.zzhed = false;
        if (this.isConnected()) {
            try {
                com.google.android.gms.games.internal.zzj zzj2 = (com.google.android.gms.games.internal.zzj)this.zzajj();
                zzj2.zzaqs();
                this.zzhdy.flush();
                zzj2.zzac(this.zzhef);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.games.internal.zze.zzy("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        super.disconnect();
    }

    protected final String zzhc() {
        return "com.google.android.gms.games.service.START";
    }

    protected final String zzhd() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    public final Bundle zzaeg() {
        try {
            Bundle bundle = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaeg();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    protected final Bundle zzzs() {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = this.zzheg.zzapl();
        bundle.putString("com.google.android.gms.games.key.gamePackageName", this.zzhdz);
        bundle.putString("com.google.android.gms.games.key.desiredLocale", string);
        bundle.putParcelable("com.google.android.gms.games.key.popupWindowToken", (Parcelable)new BinderWrapper(this.zzhec.zzhgu.zzhgv));
        bundle.putInt("com.google.android.gms.games.key.API_VERSION", 6);
        bundle.putBundle("com.google.android.gms.games.key.signInOptions", zzcqc.zza((com.google.android.gms.common.internal.zzq)this.zzakd()));
        return bundle;
    }

    public final String zzapv() {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzapv();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zzb(String string, com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) throws RemoteException {
        com.google.android.gms.common.internal.zzbp.zzh((String)string, (Object)"Please provide a valid serverClientId");
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(string, new zzy(zzn2));
    }

    public final String zzbj(boolean bl) {
        if (this.zzhea != null) {
            return this.zzhea.getPlayerId();
        }
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqu();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Player zzapw() {
        this.zzaji();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzhea == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqv());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.zzhea = (PlayerEntity)((Player)playerBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesClientImpl.zzd(remoteException);
                }
            }
        }
        return this.zzhea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Game zzapx() {
        this.zzaji();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.zzheb == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqw());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.zzheb = (GameEntity)((Game)gameBuffer.get(0)).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesClientImpl.zzd(remoteException);
                }
            }
        }
        return this.zzheb;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzbn(zzn2), string, bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, int n, boolean bl, boolean bl2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbn(zzn2), n, bl, bl2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, String string, int n, boolean bl, boolean bl2) throws RemoteException {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Invalid player collection: ".concat(string2) : new String("Invalid player collection: "));
            }
        }
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbn(zzn2), string, n, bl, bl2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc((com.google.android.gms.games.internal.zzf)new zzbn(zzn2), bl);
    }

    public final Intent zzapy() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzapy();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzj(String string, int n, int n2) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzk(string, n, n2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzai(zzn2), bl);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2, String string, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzai(zzn2), string, bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2, String string, String string2, int n, int n2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbl(zzn2), null, string2, n, n2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(new zzah(zzn2), string, n, n2, n3, bl);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, String string, int n, int n2, int n3, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(new zzah(zzn2), string, n, n2, n3, bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n, int n2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzah(zzn2), leaderboardScoreBuffer.zzarq().asBundle(), n, n2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2, String string, long l, String string2) throws RemoteException {
        zzcl zzcl2 = zzn2 == null ? null : new zzcl(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zzcl2, string, l, string2);
    }

    public final Intent zzapz() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzapz();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzf(zzn2), bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zze2, string, this.zzhec.zzhgu.zzhgv, this.zzhec.zzhgu.zzaqz());
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(zze2, string, this.zzhec.zzhgu.zzhgv, this.zzhec.zzhgu.zzaqz());
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zze2, string, n, this.zzhec.zzhgu.zzhgv, this.zzhec.zzhgu.zzaqz());
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2, String string, int n) throws RemoteException {
        zze zze2 = zzn2 == null ? null : new zze(zzn2);
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(zze2, string, n, this.zzhec.zzhgu.zzhgv, this.zzhec.zzhgu.zzaqz());
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl) throws RemoteException {
        this.zzhdy.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zze((com.google.android.gms.games.internal.zzf)new zzu(zzn2), bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2, boolean bl, String ... stringArray) throws RemoteException {
        this.zzhdy.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzu(zzn2), bl, stringArray);
    }

    public final void zzp(String string, int n) {
        this.zzhdy.zzp(string, n);
    }

    public final Intent zzaqa() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqa();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzaqb() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqb();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzcj<OnInvitationReceivedListener> zzcj2) {
        try {
            zzab zzab2 = new zzab(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zzab2, this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqc() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzad(this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzcj<OnTurnBasedMatchUpdateReceivedListener> zzcj2) {
        try {
            zzaz zzaz2 = new zzaz(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)zzaz2, this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqd() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzae(this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzcj<QuestUpdateListener> zzcj2) {
        try {
            zzbs zzbs2 = new zzbs(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd((com.google.android.gms.games.internal.zzf)zzbs2, this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqe() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzag(this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzcj<OnRequestReceivedListener> zzcj2) {
        try {
            zzbw zzbw2 = new zzbw(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc((com.google.android.gms.games.internal.zzf)zzbw2, this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqf() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaf(this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zza(PlayerEntity playerEntity) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(playerEntity);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzaqg() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqg();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(Room room, int n) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((RoomEntity)room.freeze(), n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzaqh() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqh();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(new zzx(zzn2));
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) throws RemoteException {
        this.zzhdy.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(new zzcg(zzn2));
    }

    public final int zzaqi() {
        int n = 4368;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqi();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final String getAppId() {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).getAppId();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return null;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzae(zzn2), n);
    }

    public final void zzq(String string, int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzq(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzr(String string, int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzr(string, n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzb(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, TurnBasedMatchConfig turnBasedMatchConfig) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzco(zzn2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.zzarv(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
    }

    public final void zzc(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzco(zzn2), string);
    }

    public final void zzd(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc((com.google.android.gms.games.internal.zzf)new zzco(zzn2), string);
    }

    public final int zzaqj() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqj();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcs(zzn2), string, byArray, string2, participantResultArray);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2, String string, byte[] byArray, ParticipantResult[] participantResultArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcs(zzn2), string, byArray, participantResultArray);
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zze((com.google.android.gms.games.internal.zzf)new zzcp(zzn2), string);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2, String string, String string2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcp(zzn2), string, string2);
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd((com.google.android.gms.games.internal.zzf)new zzcn(zzn2), string);
    }

    public final void zzhj(String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzhm(string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2, int n, int[] nArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzct(zzn2), n, nArray);
    }

    public final void zzg(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzf((com.google.android.gms.games.internal.zzf)new zzcq(zzn2), string);
    }

    public final Intent zzc(int n, int n2, boolean bl) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc(n, n2, bl);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzcj<RoomUpdateListener> zzcj2, com.google.android.gms.common.api.internal.zzcj<RoomStatusUpdateListener> zzcj3, com.google.android.gms.common.api.internal.zzcj<RealTimeMessageReceivedListener> zzcj4, RoomConfig roomConfig) {
        try {
            zzcc zzcc2 = new zzcc(zzcj2, zzcj3, zzcj4);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(zzcc2, (IBinder)this.zzhee, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), false, this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzcj<RoomUpdateListener> zzcj2, com.google.android.gms.common.api.internal.zzcj<RoomStatusUpdateListener> zzcj3, com.google.android.gms.common.api.internal.zzcj<RealTimeMessageReceivedListener> zzcj4, RoomConfig roomConfig) {
        try {
            zzcc zzcc2 = new zzcc(zzcj2, zzcj3, zzcj4);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)zzcc2, (IBinder)this.zzhee, roomConfig.getInvitationId(), false, this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(com.google.android.gms.common.api.internal.zzcj<RoomUpdateListener> zzcj2, String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcc(zzcj2), string);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zza(com.google.android.gms.common.api.internal.zzcj<RealTimeMultiplayer.ReliableMessageSentCallback> zzcj2, byte[] byArray, String string, String string2) {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbv(zzcj2), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zza(byte[] byArray, String string, String[] stringArray) {
        com.google.android.gms.common.internal.zzbp.zzb((Object)stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final int zzd(byte[] byArray, String string) {
        try {
            return ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return -1;
        }
    }

    public final void zzdd(int n) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzdd(n);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final Intent zzaqk() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqk();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zza(int n, byte[] byArray, int n2, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(n, byArray, n2, string);
            com.google.android.gms.common.internal.zzbp.zzb((Object)bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final int zzaql() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaql();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzaqm() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqm();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzca(zzn2), stringArray);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2, String[] stringArray) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzca(zzn2), stringArray);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2, int n, int n2, int n3) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbz(zzn2), n, n2, n3);
    }

    public final void zze(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzf((com.google.android.gms.games.internal.zzf)new zzbm(zzn2), bl);
    }

    public final Intent zzd(int[] nArray) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd(nArray);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final Intent zzhk(String string) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzhk(string);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2, String string) throws RemoteException {
        this.zzhdy.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzh(new zzbp(zzn2), string);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string, String string2) throws RemoteException {
        this.zzhdy.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzbr(zzn2, string2), string, string2);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, int[] nArray, int n, boolean bl) throws RemoteException {
        this.zzhdy.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbt(zzn2), nArray, n, bl);
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2, boolean bl, String[] stringArray) throws RemoteException {
        this.zzhdy.flush();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzbt(zzn2), stringArray, bl);
    }

    public final void zzhl(String string) {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(string, this.zzhec.zzhgu.zzhgv, this.zzhec.zzhgu.zzaqz());
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final int zzaqn() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqn();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final int zzaqo() {
        int n = -1;
        try {
            n = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqo();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return n;
    }

    public final Intent zza(String string, boolean bl, boolean bl2, int n) {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(string, bl, bl2, n);
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzf(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2, boolean bl) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd((com.google.android.gms.games.internal.zzf)new zzck(zzn2), bl);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, boolean bl, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcj(zzn2), string, bl, n);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) throws RemoteException {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbp.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzary();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzamq();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzch(zzn2), snapshot.getMetadata().getSnapshotId(), (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
    }

    public final void zza(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        com.google.android.gms.common.internal.zzbp.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"Snapshot already closed");
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzamq();
        snapshotContents.close();
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(zzc2);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2, String string) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzg(new zzci(zzn2), string);
    }

    public final void zza(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) throws RemoteException {
        com.google.android.gms.common.internal.zzbp.zza((!snapshotContents.isClosed() ? 1 : 0) != 0, (Object)"SnapshotContents already closed");
        BitmapTeleporter bitmapTeleporter = snapshotMetadataChange.zzary();
        if (bitmapTeleporter != null) {
            bitmapTeleporter.zzc(this.getContext().getCacheDir());
        }
        com.google.android.gms.drive.zzc zzc2 = snapshotContents.zzamq();
        snapshotContents.close();
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza((com.google.android.gms.games.internal.zzf)new zzcj(zzn2), string, string2, (com.google.android.gms.games.snapshot.zze)snapshotMetadataChange, zzc2);
    }

    public final void zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzc(new zzj(zzn2));
    }

    public final Intent zzaqp() {
        Intent intent;
        try {
            intent = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqx();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            intent = null;
        }
        return intent;
    }

    public final void zzi(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzd(new zzn(zzn2));
    }

    public final void zzb(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2, int n) throws RemoteException {
        ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzb((com.google.android.gms.games.internal.zzf)new zzh(zzn2), n);
    }

    public final boolean zzaqq() {
        boolean bl = false;
        try {
            bl = ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqq();
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
        }
        return bl;
    }

    public final void zze(com.google.android.gms.common.api.internal.zzcj<Videos.CaptureOverlayStateListener> zzcj2) {
        try {
            zzl zzl2 = new zzl(zzcj2);
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zze((com.google.android.gms.games.internal.zzf)zzl2, this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zzaqr() {
        try {
            ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzah(this.zzhef);
            return;
        }
        catch (RemoteException remoteException) {
            GamesClientImpl.zzd(remoteException);
            return;
        }
    }

    public final void zza(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzj)this.zzajj()).zza(iBinder, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    public final void zzaqs() {
        if (this.isConnected()) {
            try {
                ((com.google.android.gms.games.internal.zzj)this.zzajj()).zzaqs();
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    private static void zzd(RemoteException remoteException) {
        com.google.android.gms.games.internal.zze.zzc("GamesClientImpl", "service died", remoteException);
    }

    private static Room zzak(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.zzb zzb2 = new com.google.android.gms.games.multiplayer.realtime.zzb(dataHolder);
        Room room = null;
        try {
            if (zzb2.getCount() > 0) {
                room = (Room)((Room)zzb2.get(0)).freeze();
            }
        }
        finally {
            zzb2.release();
        }
        return room;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null) {
            bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            this.zzheh = this.zzhed = bundle.getBoolean("show_welcome_popup");
            this.zzhea = (PlayerEntity)bundle.getParcelable("com.google.android.gms.games.current_player");
            this.zzheb = (GameEntity)bundle.getParcelable("com.google.android.gms.games.current_game");
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public final /* synthetic */ void zza(@NonNull IInterface iInterface) {
        com.google.android.gms.games.internal.zzj zzj2 = (com.google.android.gms.games.internal.zzj)iInterface;
        GamesClientImpl gamesClientImpl = this;
        super.zza((IInterface)zzj2);
        if (gamesClientImpl.zzhed) {
            gamesClientImpl.zzhec.zzaqy();
            gamesClientImpl.zzhed = false;
        }
        if (!gamesClientImpl.zzheg.zzhcd && !gamesClientImpl.zzheg.zzhcl) {
            com.google.android.gms.games.internal.zzj zzj3 = zzj2;
            GamesClientImpl gamesClientImpl2 = gamesClientImpl;
            try {
                zzbo zzbo2 = new zzbo(gamesClientImpl2.zzhec);
                zzj3.zza(zzbo2, gamesClientImpl2.zzhef);
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
            }
        }
    }

    protected final /* synthetic */ IInterface zze(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.games.internal.IGamesService");
        if (iInterface instanceof com.google.android.gms.games.internal.zzj) {
            return (com.google.android.gms.games.internal.zzj)iInterface;
        }
        return new com.google.android.gms.games.internal.zzk(iBinder2);
    }

    static final class CaptureStreamingUrlResultImpl
    implements Videos.CaptureStreamingUrlResult {
        private final String zzad;

        public final Status getStatus() {
            throw new NoSuchMethodError();
        }

        @Override
        public final String getUrl() {
            return this.zzad;
        }
    }

    static final class zzo
    implements Videos.CaptureStateResult {
        private final Status mStatus;
        private final CaptureState zzhep;

        zzo(Status status, CaptureState captureState) {
            this.mStatus = status;
            this.zzhep = captureState;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final CaptureState getCaptureState() {
            return this.zzhep;
        }
    }

    static final class zzk
    implements Videos.CaptureCapabilitiesResult {
        private final Status mStatus;
        private final VideoCapabilities zzhen;

        zzk(Status status, VideoCapabilities videoCapabilities) {
            this.mStatus = status;
            this.zzhen = videoCapabilities;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final VideoCapabilities getCapabilities() {
            return this.zzhen;
        }
    }

    static final class zzi
    implements Videos.CaptureAvailableResult {
        private final Status mStatus;
        private final boolean zzhem;

        zzi(Status status, boolean bl) {
            this.mStatus = status;
            this.zzhem = bl;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final boolean isAvailable() {
            return this.zzhem;
        }
    }

    static final class zzs
    implements Snapshots.DeleteSnapshotResult {
        private final Status mStatus;
        private final String zzhes;

        zzs(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdb(n);
            this.zzhes = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getSnapshotId() {
            return this.zzhes;
        }
    }

    static final class zzq
    extends zzw
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata zzher;

        zzq(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.zzher = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0)) : null;
                return;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public final SnapshotMetadata getSnapshotMetadata() {
            return this.zzher;
        }
    }

    static final class zzbc
    extends zzw
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot zzhfl;
        private final String zzhfm;
        private final Snapshot zzhfn;
        private final com.google.android.gms.drive.zzc zzhfo;
        private final SnapshotContents zzhfp;

        zzbc(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this(dataHolder, null, zzc2, null, null);
        }

        zzbc(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.zzhfl = null;
                    this.zzhfn = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.zzc.zzbg((dataHolder.getStatusCode() != 4004 ? 1 : 0) != 0);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhfl = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    this.zzhfn = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(0));
                    this.zzhfl = new SnapshotEntity(snapshotMetadataEntity, new com.google.android.gms.games.snapshot.zza(zzc2));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity((SnapshotMetadata)snapshotMetadataBuffer.get(1));
                    this.zzhfn = new SnapshotEntity(snapshotMetadataEntity2, new com.google.android.gms.games.snapshot.zza(zzc3));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.zzhfm = string;
            this.zzhfo = zzc4;
            this.zzhfp = new com.google.android.gms.games.snapshot.zza(zzc4);
        }

        @Override
        public final Snapshot getSnapshot() {
            return this.zzhfl;
        }

        @Override
        public final String getConflictId() {
            return this.zzhfm;
        }

        @Override
        public final Snapshot getConflictingSnapshot() {
            return this.zzhfn;
        }

        @Override
        public final SnapshotContents getResolutionSnapshotContents() {
            return this.zzhfp;
        }
    }

    static final class zzax
    extends zzw
    implements Snapshots.LoadSnapshotsResult {
        zzax(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.zzfkz);
        }
    }

    static final class zzas
    extends zzw
    implements Stats.LoadPlayerStatsResult {
        private final PlayerStats zzhfd;

        zzas(DataHolder dataHolder) {
            super(dataHolder);
            PlayerStatsBuffer playerStatsBuffer = new PlayerStatsBuffer(dataHolder);
            try {
                this.zzhfd = playerStatsBuffer.getCount() > 0 ? new com.google.android.gms.games.stats.zza((PlayerStats)playerStatsBuffer.get(0)) : null;
                return;
            }
            finally {
                playerStatsBuffer.release();
            }
        }

        @Override
        public final PlayerStats getPlayerStats() {
            return this.zzhfd;
        }
    }

    static final class zzp
    extends zzw
    implements Quests.ClaimMilestoneResult {
        private final Milestone zzheq;
        private final Quest zzhek;

        zzp(DataHolder dataHolder, String string) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.zzhek = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.zzhek.zzarw();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        if (!list.get(i).getMilestoneId().equals(string)) continue;
                        this.zzheq = list.get(i);
                        return;
                    }
                    this.zzheq = null;
                } else {
                    this.zzheq = null;
                    this.zzhek = null;
                }
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Milestone getMilestone() {
            return this.zzheq;
        }

        @Override
        public final Quest getQuest() {
            return this.zzhek;
        }
    }

    static final class zzd
    extends zzw
    implements Quests.AcceptQuestResult {
        private final Quest zzhek;

        zzd(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.zzhek = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
                return;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public final Quest getQuest() {
            return this.zzhek;
        }
    }

    static final class zzau
    extends zzw
    implements Quests.LoadQuestsResult {
        private final DataHolder zzfkz;

        zzau(DataHolder dataHolder) {
            super(dataHolder);
            this.zzfkz = dataHolder;
        }

        @Override
        public final QuestBuffer getQuests() {
            return new QuestBuffer(this.zzfkz);
        }
    }

    static final class zzav
    implements Requests.LoadRequestsResult {
        private final Status mStatus;
        private final Bundle zzhff;

        zzav(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhff = bundle;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final GameRequestBuffer getRequests(int n) {
            String string;
            switch (n) {
                case 1: {
                    String string2 = "GIFT";
                    break;
                }
                case 2: {
                    String string2 = "WISH";
                    break;
                }
                default: {
                    com.google.android.gms.games.internal.zze.zzz("RequestType", new StringBuilder(33).append("Unknown request type: ").append(n).toString());
                    String string2 = string = "UNKNOWN_TYPE";
                }
            }
            if (!this.zzhff.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.zzhff.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        public final void release() {
            for (String string : this.zzhff.keySet()) {
                DataHolder dataHolder = (DataHolder)this.zzhff.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    static final class zzcw
    extends zzw
    implements Requests.UpdateRequestsResult {
        private final zzbvr zzhgo;

        zzcw(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhgo = zzbvr.zzan(dataHolder);
        }

        @Override
        public final int getRequestOutcome(String string) {
            return this.zzhgo.getRequestOutcome(string);
        }

        @Override
        public final Set<String> getRequestIds() {
            return this.zzhgo.getRequestIds();
        }
    }

    static final class zzz
    implements Games.GetServerAuthCodeResult {
        private final Status mStatus;
        private final String zzhet;

        zzz(Status status, String string) {
            this.mStatus = status;
            this.zzhet = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getCode() {
            return this.zzhet;
        }
    }

    static final class zzg
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status mStatus;
        private final String zzhel;

        zzg(Status status, String string) {
            this.mStatus = status;
            this.zzhel = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMatchId() {
            return this.zzhel;
        }
    }

    static final class zzaj
    extends zzcr
    implements TurnBasedMultiplayer.LeaveMatchResult {
        zzaj(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzcv
    extends zzcr
    implements TurnBasedMultiplayer.UpdateMatchResult {
        zzcv(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzaa
    extends zzcr
    implements TurnBasedMultiplayer.InitiateMatchResult {
        zzaa(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static final class zzap
    extends zzcr
    implements TurnBasedMultiplayer.LoadMatchResult {
        zzap(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    static abstract class zzcr
    extends zzw {
        private TurnBasedMatch zzhfj;

        zzcr(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.zzhfj = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.zzhfj;
        }
    }

    static final class zzcm
    extends zzw
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData zzhgh;

        public zzcm(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.zzhgh = new ScoreSubmissionData(dataHolder);
                return;
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public final ScoreSubmissionData getScoreData() {
            return this.zzhgh;
        }
    }

    static final class zzat
    extends zzw
    implements Players.LoadPlayersResult {
        private final PlayerBuffer zzhfe;

        zzat(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhfe = new PlayerBuffer(dataHolder);
        }

        @Override
        public final PlayerBuffer getPlayers() {
            return this.zzhfe;
        }
    }

    static final class zzaq
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status mStatus;
        private final LoadMatchesResponse zzhfb;

        zzaq(Status status, Bundle bundle) {
            this.mStatus = status;
            this.zzhfb = new LoadMatchesResponse(bundle);
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final LoadMatchesResponse getMatches() {
            return this.zzhfb;
        }

        public final void release() {
            this.zzhfb.release();
        }
    }

    static final class zzao
    extends zzw
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer zzhfa;

        zzao(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhfa = new InvitationBuffer(dataHolder);
        }

        @Override
        public final InvitationBuffer getInvitations() {
            return this.zzhfa;
        }
    }

    static final class zzar
    extends zzw
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity zzhfc;

        zzar(DataHolder dataHolder) {
            super(dataHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.zzhfc = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)((LeaderboardScore)leaderboardScoreBuffer.get(0)).freeze() : null;
                return;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public final LeaderboardScore getScore() {
            return this.zzhfc;
        }
    }

    static final class zzaw
    extends zzw
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity zzhfg;
        private final LeaderboardScoreBuffer zzhfh;

        zzaw(DataHolder dataHolder, DataHolder dataHolder2) {
            super(dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.zzhfg = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.zzhfh = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        public final Leaderboard getLeaderboard() {
            return this.zzhfg;
        }

        @Override
        public final LeaderboardScoreBuffer getScores() {
            return this.zzhfh;
        }
    }

    static final class zzag
    extends zzw
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer zzhev;

        zzag(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhev = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public final LeaderboardBuffer getLeaderboards() {
            return this.zzhev;
        }
    }

    static final class zzan
    extends zzw
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer zzhez;

        zzan(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhez = new GameBuffer(dataHolder);
        }

        @Override
        public final GameBuffer getGames() {
            return this.zzhez;
        }
    }

    static final class zzam
    extends zzw
    implements Events.LoadEventsResult {
        private final EventBuffer zzhey;

        zzam(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhey = new EventBuffer(dataHolder);
        }

        @Override
        public final EventBuffer getEvents() {
            return this.zzhey;
        }
    }

    static final class zzcu
    implements Achievements.UpdateAchievementResult {
        private final Status mStatus;
        private final String zzhdk;

        zzcu(int n, String string) {
            this.mStatus = GamesStatusCodes.zzdb(n);
            this.zzhdk = string;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getAchievementId() {
            return this.zzhdk;
        }
    }

    static final class zzal
    extends zzw
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer zzhex;

        zzal(DataHolder dataHolder) {
            super(dataHolder);
            this.zzhex = new AchievementBuffer(dataHolder);
        }

        @Override
        public final AchievementBuffer getAchievements() {
            return this.zzhex;
        }
    }

    static abstract class zzw
    extends com.google.android.gms.common.api.internal.zzam {
        protected zzw(DataHolder dataHolder) {
            super(dataHolder, GamesStatusCodes.zzdb(dataHolder.getStatusCode()));
        }
    }

    static final class zzbu
    implements com.google.android.gms.common.api.internal.zzcm<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int zzezx;
        private final String zzhfv;
        private final int zzhfw;

        zzbu(int n, int n2, String string) {
            this.zzezx = n;
            this.zzhfw = n2;
            this.zzhfv = string;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback = (RealTimeMultiplayer.ReliableMessageSentCallback)object;
            zzbu zzbu2 = this;
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(zzbu2.zzezx, zzbu2.zzhfw, zzbu2.zzhfv);
            }
        }
    }

    static final class zzbb
    implements com.google.android.gms.common.api.internal.zzcm<RealTimeMessageReceivedListener> {
        private final RealTimeMessage zzhfk;

        zzbb(RealTimeMessage realTimeMessage) {
            this.zzhfk = realTimeMessage;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RealTimeMessageReceivedListener realTimeMessageReceivedListener = (RealTimeMessageReceivedListener)object;
            zzbb zzbb2 = this;
            realTimeMessageReceivedListener.onRealTimeMessageReceived(zzbb2.zzhfk);
        }
    }

    static final class zzbe
    implements com.google.android.gms.common.api.internal.zzcm<RoomStatusUpdateListener> {
        private final String zzhfq;

        zzbe(String string) {
            this.zzhfq = string;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbe zzbe2 = this;
            roomStatusUpdateListener.onP2PDisconnected(zzbe2.zzhfq);
        }
    }

    static final class zzbd
    implements com.google.android.gms.common.api.internal.zzcm<RoomStatusUpdateListener> {
        private final String zzhfq;

        zzbd(String string) {
            this.zzhfq = string;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            zzbd zzbd2 = this;
            roomStatusUpdateListener.onP2PConnected(zzbd2.zzhfq);
        }
    }

    static final class zzbh
    extends zza {
        zzbh(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    static final class zzbf
    extends zza {
        zzbf(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    static final class zzbg
    extends zza {
        zzbg(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    static final class zzbk
    extends zza {
        zzbk(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    static final class zzbj
    extends zza {
        zzbj(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    static final class zzbi
    extends zza {
        zzbi(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder, stringArray);
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    static final class zzt
    extends zzc {
        zzt(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    static final class zzr
    extends zzc {
        zzr(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    static final class zzcb
    extends zzc {
        zzcb(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    static final class zzce
    extends zzc {
        zzce(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    static final class zzcd
    extends zzb {
        zzcd(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomConnected(n, room);
        }
    }

    static final class zzak
    implements com.google.android.gms.common.api.internal.zzcm<RoomUpdateListener> {
        private final int zzezx;
        private final String zzhew;

        zzak(int n, String string) {
            this.zzezx = n;
            this.zzhew = string;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            zzak zzak2 = this;
            roomUpdateListener.onLeftRoom(zzak2.zzezx, zzak2.zzhew);
        }
    }

    static final class zzaf
    extends zzb {
        public zzaf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onJoinedRoom(n, room);
        }
    }

    static final class zzcf
    extends zzb {
        public zzcf(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public final void zza(RoomUpdateListener roomUpdateListener, Room room, int n) {
            roomUpdateListener.onRoomCreated(n, room);
        }
    }

    static abstract class zza
    extends zzc {
        private final ArrayList<String> zzhej = new ArrayList();

        zza(DataHolder dataHolder, String[] stringArray) {
            super(dataHolder);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.zzhej.add(stringArray[i]);
            }
        }

        @Override
        protected final void zza(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.zza(roomStatusUpdateListener, room, this.zzhej);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    static abstract class zzc
    extends com.google.android.gms.common.api.internal.zzal<RoomStatusUpdateListener> {
        zzc(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomStatusUpdateListener var1, Room var2);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomStatusUpdateListener roomStatusUpdateListener = (RoomStatusUpdateListener)object;
            this.zza(roomStatusUpdateListener, GamesClientImpl.zzak(dataHolder2));
        }
    }

    static abstract class zzb
    extends com.google.android.gms.common.api.internal.zzal<RoomUpdateListener> {
        zzb(DataHolder dataHolder) {
            super(dataHolder);
        }

        protected abstract void zza(RoomUpdateListener var1, Room var2, int var3);

        protected final /* synthetic */ void zza(Object object, DataHolder dataHolder) {
            DataHolder dataHolder2 = dataHolder;
            RoomUpdateListener roomUpdateListener = (RoomUpdateListener)object;
            this.zza(roomUpdateListener, GamesClientImpl.zzak(dataHolder2), dataHolder2.getStatusCode());
        }
    }

    static final class zzby
    implements com.google.android.gms.common.api.internal.zzcm<OnRequestReceivedListener> {
        private final String zzcjq;

        zzby(String string) {
            this.zzcjq = string;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzby zzby2 = this;
            onRequestReceivedListener.onRequestRemoved(zzby2.zzcjq);
        }
    }

    static final class zzbx
    implements com.google.android.gms.common.api.internal.zzcm<OnRequestReceivedListener> {
        private final GameRequest zzhfy;

        zzbx(GameRequest gameRequest) {
            this.zzhfy = gameRequest;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnRequestReceivedListener onRequestReceivedListener = (OnRequestReceivedListener)object;
            zzbx zzbx2 = this;
            onRequestReceivedListener.onRequestReceived(zzbx2.zzhfy);
        }
    }

    static final class zzbq
    implements com.google.android.gms.common.api.internal.zzcm<QuestUpdateListener> {
        private final Quest zzhek;

        zzbq(Quest quest) {
            this.zzhek = quest;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            QuestUpdateListener questUpdateListener = (QuestUpdateListener)object;
            zzbq zzbq2 = this;
            questUpdateListener.onQuestCompleted(zzbq2.zzhek);
        }
    }

    static final class zzay
    implements com.google.android.gms.common.api.internal.zzcm<OnTurnBasedMatchUpdateReceivedListener> {
        private final String zzhfi;

        zzay(String string) {
            this.zzhfi = string;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzay zzay2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(zzay2.zzhfi);
        }
    }

    static final class zzba
    implements com.google.android.gms.common.api.internal.zzcm<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch zzhfj;

        zzba(TurnBasedMatch turnBasedMatch) {
            this.zzhfj = turnBasedMatch;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener = (OnTurnBasedMatchUpdateReceivedListener)object;
            zzba zzba2 = this;
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(zzba2.zzhfj);
        }
    }

    static final class zzad
    implements com.google.android.gms.common.api.internal.zzcm<OnInvitationReceivedListener> {
        private final String zzdww;

        zzad(String string) {
            this.zzdww = string;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzad zzad2 = this;
            onInvitationReceivedListener.onInvitationRemoved(zzad2.zzdww);
        }
    }

    static final class zzac
    implements com.google.android.gms.common.api.internal.zzcm<OnInvitationReceivedListener> {
        private final Invitation zzheu;

        zzac(Invitation invitation) {
            this.zzheu = invitation;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            OnInvitationReceivedListener onInvitationReceivedListener = (OnInvitationReceivedListener)object;
            zzac zzac2 = this;
            onInvitationReceivedListener.onInvitationReceived(zzac2.zzheu);
        }
    }

    static final class zzm
    implements com.google.android.gms.common.api.internal.zzcm<Videos.CaptureOverlayStateListener> {
        private final int zzheo;

        zzm(int n) {
            this.zzheo = n;
        }

        public final void zzagw() {
        }

        public final /* synthetic */ void zzq(Object object) {
            Videos.CaptureOverlayStateListener captureOverlayStateListener = (Videos.CaptureOverlayStateListener)object;
            zzm zzm2 = this;
            captureOverlayStateListener.onCaptureOverlayStateChanged(zzm2.zzheo);
        }
    }

    static final class zzn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzfwc;

        public zzn(com.google.android.gms.common.api.internal.zzn<Videos.CaptureStateResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzd(int n, Bundle bundle) {
            this.zzfwc.setResult((Object)new zzo(new Status(n), CaptureState.zzo(bundle)));
        }
    }

    static final class zzl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<Videos.CaptureOverlayStateListener> zzghr;

        zzl(com.google.android.gms.common.api.internal.zzcj<Videos.CaptureOverlayStateListener> zzcj2) {
            this.zzghr = (com.google.android.gms.common.api.internal.zzcj)com.google.android.gms.common.internal.zzbp.zzb(zzcj2, (Object)"Callback must not be null");
        }

        @Override
        public final void onCaptureOverlayStateChanged(int n) {
            this.zzghr.zza((com.google.android.gms.common.api.internal.zzcm)new zzm(n));
        }
    }

    static final class zzj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzfwc;

        zzj(com.google.android.gms.common.api.internal.zzn<Videos.CaptureCapabilitiesResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(int n, VideoCapabilities videoCapabilities) {
            this.zzfwc.setResult((Object)new zzk(new Status(n), videoCapabilities));
        }
    }

    static final class zzh
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzfwc;

        zzh(com.google.android.gms.common.api.internal.zzn<Videos.CaptureAvailableResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, boolean bl) {
            this.zzfwc.setResult((Object)new zzi(new Status(n), bl));
        }
    }

    static final class zzci
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzfwc;

        public zzci(com.google.android.gms.common.api.internal.zzn<Snapshots.DeleteSnapshotResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(int n, String string) {
            this.zzfwc.setResult((Object)new zzs(n, string));
        }
    }

    static final class zzch
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzhge;

        public zzch(com.google.android.gms.common.api.internal.zzn<Snapshots.CommitSnapshotResult> zzn2) {
            this.zzhge = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzae(DataHolder dataHolder) {
            this.zzhge.setResult((Object)new zzq(dataHolder));
        }
    }

    static final class zzcj
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzhgf;

        public zzcj(com.google.android.gms.common.api.internal.zzn<Snapshots.OpenSnapshotResult> zzn2) {
            this.zzhgf = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, com.google.android.gms.drive.zzc zzc2) {
            this.zzhgf.setResult((Object)new zzbc(dataHolder, zzc2));
        }

        @Override
        public final void zza(DataHolder dataHolder, String string, com.google.android.gms.drive.zzc zzc2, com.google.android.gms.drive.zzc zzc3, com.google.android.gms.drive.zzc zzc4) {
            this.zzhgf.setResult((Object)new zzbc(dataHolder, string, zzc2, zzc3, zzc4));
        }
    }

    static final class zzck
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzhgg;

        public zzck(com.google.android.gms.common.api.internal.zzn<Snapshots.LoadSnapshotsResult> zzn2) {
            this.zzhgg = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzad(DataHolder dataHolder) {
            this.zzhgg.setResult((Object)new zzax(dataHolder));
        }
    }

    static final class zzbm
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzfwc;

        public zzbm(com.google.android.gms.common.api.internal.zzn<Stats.LoadPlayerStatsResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzaj(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzas(dataHolder));
        }
    }

    static final class zzbt
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzhfu;

        public zzbt(com.google.android.gms.common.api.internal.zzn<Quests.LoadQuestsResult> zzn2) {
            this.zzhfu = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzai(DataHolder dataHolder) {
            this.zzhfu.setResult((Object)new zzau(dataHolder));
        }
    }

    static final class zzbr
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzhfs;
        private final String zzhft;

        public zzbr(com.google.android.gms.common.api.internal.zzn<Quests.ClaimMilestoneResult> zzn2, String string) {
            this.zzhfs = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
            this.zzhft = (String)com.google.android.gms.common.internal.zzbp.zzb((Object)string, (Object)"MilestoneId must not be null");
        }

        @Override
        public final void zzaf(DataHolder dataHolder) {
            this.zzhfs.setResult((Object)new zzp(dataHolder, this.zzhft));
        }
    }

    static final class zzbp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzhfr;

        public zzbp(com.google.android.gms.common.api.internal.zzn<Quests.AcceptQuestResult> zzn2) {
            this.zzhfr = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzag(DataHolder dataHolder) {
            this.zzhfr.setResult((Object)new zzd(dataHolder));
        }
    }

    static final class zzbz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzhfz;

        public zzbz(com.google.android.gms.common.api.internal.zzn<Requests.LoadRequestsResult> zzn2) {
            this.zzhfz = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzc(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdb(n);
            this.zzhfz.setResult((Object)new zzav(status, bundle));
        }
    }

    static final class zzca
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzhga;

        public zzca(com.google.android.gms.common.api.internal.zzn<Requests.UpdateRequestsResult> zzn2) {
            this.zzhga = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzac(DataHolder dataHolder) {
            this.zzhga.setResult((Object)new zzcw(dataHolder));
        }
    }

    static final class zzbo
    extends com.google.android.gms.games.internal.zzb {
        private final com.google.android.gms.games.internal.zzn zzhec;

        public zzbo(com.google.android.gms.games.internal.zzn zzn2) {
            this.zzhec = zzn2;
        }

        @Override
        public final com.google.android.gms.games.internal.zzl zzapu() {
            return new com.google.android.gms.games.internal.zzl(this.zzhec.zzhgu);
        }
    }

    static final class zzy
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzfwc;

        public zzy(com.google.android.gms.common.api.internal.zzn<Games.GetServerAuthCodeResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(int n, String string) {
            Status status = GamesStatusCodes.zzdb(n);
            this.zzfwc.setResult((Object)new zzz(status, string));
        }
    }

    static final class zzcg
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Status> zzfwc;

        public zzcg(com.google.android.gms.common.api.internal.zzn<Status> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzapt() {
            Status status = GamesStatusCodes.zzdb(0);
            this.zzfwc.setResult((Object)status);
        }
    }

    static final class zzbv
    extends com.google.android.gms.games.internal.zza {
        private com.google.android.gms.common.api.internal.zzcj<RealTimeMultiplayer.ReliableMessageSentCallback> zzhfx;

        public zzbv(com.google.android.gms.common.api.internal.zzcj<RealTimeMultiplayer.ReliableMessageSentCallback> zzcj2) {
            this.zzhfx = zzcj2;
        }

        @Override
        public final void zzb(int n, int n2, String string) {
            if (this.zzhfx != null) {
                this.zzhfx.zza((com.google.android.gms.common.api.internal.zzcm)new zzbu(n, n2, string));
            }
        }
    }

    static final class zzcc
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<? extends RoomUpdateListener> zzhgb;
        private final com.google.android.gms.common.api.internal.zzcj<? extends RoomStatusUpdateListener> zzhgc;
        private final com.google.android.gms.common.api.internal.zzcj<RealTimeMessageReceivedListener> zzhgd;

        public zzcc(com.google.android.gms.common.api.internal.zzcj<RoomUpdateListener> zzcj2) {
            this.zzhgb = (com.google.android.gms.common.api.internal.zzcj)com.google.android.gms.common.internal.zzbp.zzb(zzcj2, (Object)"Callbacks must not be null");
            this.zzhgc = null;
            this.zzhgd = null;
        }

        public zzcc(com.google.android.gms.common.api.internal.zzcj<? extends RoomUpdateListener> zzcj2, com.google.android.gms.common.api.internal.zzcj<? extends RoomStatusUpdateListener> zzcj3, com.google.android.gms.common.api.internal.zzcj<RealTimeMessageReceivedListener> zzcj4) {
            this.zzhgb = (com.google.android.gms.common.api.internal.zzcj)com.google.android.gms.common.internal.zzbp.zzb(zzcj2, (Object)"Callbacks must not be null");
            this.zzhgc = zzcj3;
            this.zzhgd = zzcj4;
        }

        @Override
        public final void zzu(DataHolder dataHolder) {
            this.zzhgb.zza((com.google.android.gms.common.api.internal.zzcm)new zzcf(dataHolder));
        }

        @Override
        public final void zzv(DataHolder dataHolder) {
            this.zzhgb.zza((com.google.android.gms.common.api.internal.zzcm)new zzaf(dataHolder));
        }

        @Override
        public final void onLeftRoom(int n, String string) {
            this.zzhgb.zza((com.google.android.gms.common.api.internal.zzcm)new zzak(n, string));
        }

        @Override
        public final void zzy(DataHolder dataHolder) {
            this.zzhgb.zza((com.google.android.gms.common.api.internal.zzcm)new zzcd(dataHolder));
        }

        @Override
        public final void zzw(DataHolder dataHolder) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzce(dataHolder));
            }
        }

        @Override
        public final void zzx(DataHolder dataHolder) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzcb(dataHolder));
            }
        }

        @Override
        public final void zzz(DataHolder dataHolder) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzr(dataHolder));
            }
        }

        @Override
        public final void zzaa(DataHolder dataHolder) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzt(dataHolder));
            }
        }

        @Override
        public final void zze(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzbf(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzf(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzbh(dataHolder, stringArray));
            }
        }

        @Override
        public final void zza(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzbi(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzb(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzbj(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzc(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzbk(dataHolder, stringArray));
            }
        }

        @Override
        public final void zzd(DataHolder dataHolder, String[] stringArray) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzbg(dataHolder, stringArray));
            }
        }

        @Override
        public final void onP2PConnected(String string) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzbd(string));
            }
        }

        @Override
        public final void onP2PDisconnected(String string) {
            if (this.zzhgc != null) {
                this.zzhgc.zza((com.google.android.gms.common.api.internal.zzcm)new zzbe(string));
            }
        }

        @Override
        public final void onRealTimeMessageReceived(RealTimeMessage realTimeMessage) {
            if (this.zzhgd != null) {
                this.zzhgd.zza((com.google.android.gms.common.api.internal.zzcm)new zzbb(realTimeMessage));
            }
        }
    }

    static final class zzcn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzhgi;

        public zzcn(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.CancelMatchResult> zzn2) {
            this.zzhgi = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(int n, String string) {
            Status status = GamesStatusCodes.zzdb(n);
            this.zzhgi.setResult((Object)new zzg(status, string));
        }
    }

    static final class zzcp
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzhgk;

        public zzcp(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LeaveMatchResult> zzn2) {
            this.zzhgk = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzs(DataHolder dataHolder) {
            this.zzhgk.setResult((Object)new zzaj(dataHolder));
        }
    }

    static final class zzcs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzhgm;

        public zzcs(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.UpdateMatchResult> zzn2) {
            this.zzhgm = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzr(DataHolder dataHolder) {
            this.zzhgm.setResult((Object)new zzcv(dataHolder));
        }
    }

    static final class zzco
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzhgj;

        public zzco(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.InitiateMatchResult> zzn2) {
            this.zzhgj = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzq(DataHolder dataHolder) {
            this.zzhgj.setResult((Object)new zzaa(dataHolder));
        }
    }

    static final class zzcq
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzhgl;

        public zzcq(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchResult> zzn2) {
            this.zzhgl = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzp(DataHolder dataHolder) {
            this.zzhgl.setResult((Object)new zzap(dataHolder));
        }
    }

    static final class zzct
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzhgn;

        public zzct(com.google.android.gms.common.api.internal.zzn<TurnBasedMultiplayer.LoadMatchesResult> zzn2) {
            this.zzhgn = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzb(int n, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = GamesStatusCodes.zzdb(n);
            this.zzhgn.setResult((Object)new zzaq(status, bundle));
        }
    }

    static final class zzcl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzfwc;

        public zzcl(com.google.android.gms.common.api.internal.zzn<Leaderboards.SubmitScoreResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzi(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzcm(dataHolder));
        }
    }

    static final class zzbn
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzfwc;

        zzbn(com.google.android.gms.common.api.internal.zzn<Players.LoadPlayersResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzj(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzat(dataHolder));
        }

        @Override
        public final void zzk(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzat(dataHolder));
        }
    }

    static final class zzbw
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<OnRequestReceivedListener> zzghr;

        zzbw(com.google.android.gms.common.api.internal.zzcj<OnRequestReceivedListener> zzcj2) {
            this.zzghr = zzcj2;
        }

        @Override
        public final void zzo(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                this.zzghr.zza((com.google.android.gms.common.api.internal.zzcm)new zzbx(gameRequest));
            }
        }

        @Override
        public final void onRequestRemoved(String string) {
            this.zzghr.zza((com.google.android.gms.common.api.internal.zzcm)new zzby(string));
        }
    }

    static final class zzbs
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<QuestUpdateListener> zzghr;

        zzbs(com.google.android.gms.common.api.internal.zzcj<QuestUpdateListener> zzcj2) {
            this.zzghr = zzcj2;
        }

        @Override
        public final void zzah(DataHolder dataHolder) {
            Quest quest = zzbs.zzam(dataHolder);
            if (quest != null) {
                this.zzghr.zza((com.google.android.gms.common.api.internal.zzcm)new zzbq(quest));
            }
        }

        private static Quest zzam(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    static final class zzaz
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<OnTurnBasedMatchUpdateReceivedListener> zzghr;

        zzaz(com.google.android.gms.common.api.internal.zzcj<OnTurnBasedMatchUpdateReceivedListener> zzcj2) {
            this.zzghr = zzcj2;
        }

        @Override
        public final void zzt(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                this.zzghr.zza((com.google.android.gms.common.api.internal.zzcm)new zzba(turnBasedMatch));
            }
        }

        @Override
        public final void onTurnBasedMatchRemoved(String string) {
            this.zzghr.zza((com.google.android.gms.common.api.internal.zzcm)new zzay(string));
        }
    }

    static final class zzab
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzcj<OnInvitationReceivedListener> zzghr;

        zzab(com.google.android.gms.common.api.internal.zzcj<OnInvitationReceivedListener> zzcj2) {
            this.zzghr = zzcj2;
        }

        @Override
        public final void zzn(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                this.zzghr.zza((com.google.android.gms.common.api.internal.zzcm)new zzac(invitation));
            }
        }

        @Override
        public final void onInvitationRemoved(String string) {
            this.zzghr.zza((com.google.android.gms.common.api.internal.zzcm)new zzad(string));
        }
    }

    static final class zzae
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzfwc;

        zzae(com.google.android.gms.common.api.internal.zzn<Invitations.LoadInvitationsResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzm(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzao(dataHolder));
        }
    }

    static final class zzbl
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzfwc;

        zzbl(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadPlayerScoreResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzab(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzar(dataHolder));
        }
    }

    static final class zzah
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzfwc;

        zzah(com.google.android.gms.common.api.internal.zzn<Leaderboards.LoadScoresResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zza(DataHolder dataHolder, DataHolder dataHolder2) {
            this.zzfwc.setResult((Object)new zzaw(dataHolder, dataHolder2));
        }
    }

    static final class zzai
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzfwc;

        zzai(com.google.android.gms.common.api.internal.zzn<Leaderboards.LeaderboardMetadataResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzag(dataHolder));
        }
    }

    static final class zzu
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzfwc;

        zzu(com.google.android.gms.common.api.internal.zzn<Events.LoadEventsResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzg(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzam(dataHolder));
        }
    }

    static final class zzx
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzfwc;

        zzx(com.google.android.gms.common.api.internal.zzn<GamesMetadata.LoadGamesResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzl(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzan(dataHolder));
        }
    }

    static final class zze
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzfwc;

        zze(com.google.android.gms.common.api.internal.zzn<Achievements.UpdateAchievementResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzh(int n, String string) {
            this.zzfwc.setResult((Object)new zzcu(n, string));
        }
    }

    static final class zzf
    extends com.google.android.gms.games.internal.zza {
        private final com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzfwc;

        zzf(com.google.android.gms.common.api.internal.zzn<Achievements.LoadAchievementsResult> zzn2) {
            this.zzfwc = (com.google.android.gms.common.api.internal.zzn)com.google.android.gms.common.internal.zzbp.zzb(zzn2, (Object)"Holder must not be null");
        }

        @Override
        public final void zzf(DataHolder dataHolder) {
            this.zzfwc.setResult((Object)new zzal(dataHolder));
        }
    }

    final class zzv
    extends zzbvo {
        private /* synthetic */ GamesClientImpl zzhei;

        public zzv(GamesClientImpl gamesClientImpl) {
            this.zzhei = gamesClientImpl;
            super(gamesClientImpl.getContext().getMainLooper(), 1000);
        }

        @Override
        protected final void zzs(String string, int n) {
            try {
                if (this.zzhei.isConnected()) {
                    ((com.google.android.gms.games.internal.zzj)this.zzhei.zzajj()).zzp(string, n);
                    return;
                }
                com.google.android.gms.games.internal.zze.zzz("GamesClientImpl", new StringBuilder(89 + String.valueOf(string).length()).append("Unable to increment event ").append(string).append(" by ").append(n).append(" because the games client is no longer connected").toString());
                return;
            }
            catch (RemoteException remoteException) {
                GamesClientImpl.zzd(remoteException);
                return;
            }
        }
    }
}

