/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.zze;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzhmz;
    private final TurnBasedMatchBuffer zzhna;
    private final TurnBasedMatchBuffer zzhnb;
    private final TurnBasedMatchBuffer zzhnc;

    public LoadMatchesResponse(Bundle bundle) {
        DataHolder dataHolder = LoadMatchesResponse.zzc(bundle, 0);
        this.zzhmz = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zzc(bundle, 1);
        this.zzhna = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zzc(bundle, 2);
        this.zzhnb = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zzc(bundle, 3);
        if (dataHolder4 != null) {
            this.zzhnc = new TurnBasedMatchBuffer(dataHolder4);
            return;
        }
        this.zzhnc = null;
    }

    private static DataHolder zzc(Bundle bundle, int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                String string2 = "TURN_STATUS_INVITED";
                break;
            }
            case 1: {
                String string2 = "TURN_STATUS_MY_TURN";
                break;
            }
            case 2: {
                String string2 = "TURN_STATUS_THEIR_TURN";
                break;
            }
            case 3: {
                String string2 = "TURN_STATUS_COMPLETE";
                break;
            }
            default: {
                zze.zzz("MatchTurnStatus", new StringBuilder(38).append("Unknown match turn status: ").append(n2).toString());
                String string2 = string = "TURN_STATUS_UNKNOWN";
            }
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public final InvitationBuffer getInvitations() {
        return this.zzhmz;
    }

    public final TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzhna;
    }

    public final TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzhnb;
    }

    public final TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzhnc;
    }

    @Deprecated
    public final void close() {
        this.release();
    }

    public final void release() {
        if (this.zzhmz != null) {
            this.zzhmz.release();
        }
        if (this.zzhna != null) {
            this.zzhna.release();
        }
        if (this.zzhnb != null) {
            this.zzhnb.release();
        }
        if (this.zzhnc != null) {
            this.zzhnc.release();
        }
    }

    public final boolean hasData() {
        if (this.zzhmz != null && this.zzhmz.getCount() > 0) {
            return true;
        }
        if (this.zzhna != null && this.zzhna.getCount() > 0) {
            return true;
        }
        if (this.zzhnb != null && this.zzhnb.getCount() > 0) {
            return true;
        }
        return this.zzhnc != null && this.zzhnc.getCount() > 0;
    }
}

