/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zze;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new zze();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzary();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzdmz;
        private Long zzhoi;
        private Long zzhoj;
        private BitmapTeleporter zzhok;
        private Uri zzhol;

        public Builder() {
        }

        public final Builder setDescription(String string) {
            this.zzdmz = string;
            return this;
        }

        public final Builder setPlayedTimeMillis(long l) {
            this.zzhoi = l;
            return this;
        }

        public final Builder setProgressValue(long l) {
            this.zzhoj = l;
            return this;
        }

        public final Builder setCoverImage(Bitmap bitmap) {
            this.zzhok = new BitmapTeleporter(bitmap);
            this.zzhol = null;
            return this;
        }

        public final Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzdmz = snapshotMetadata.getDescription();
            this.zzhoi = snapshotMetadata.getPlayedTime();
            this.zzhoj = snapshotMetadata.getProgressValue();
            if (this.zzhoi == -1L) {
                this.zzhoi = null;
            }
            this.zzhol = snapshotMetadata.getCoverImageUri();
            if (this.zzhol != null) {
                this.zzhok = null;
            }
            return this;
        }

        public final SnapshotMetadataChange build() {
            return new zze(this.zzdmz, this.zzhoi, this.zzhok, this.zzhol, this.zzhoj);
        }
    }
}

