/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.zzc;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new zza();
    private final String zzhfy;
    private final String zzebw;
    private final Uri zzhbl;
    private final Uri zzhbm;
    private final int zzbyy;
    private final String zzhmo;
    private final boolean zzhmp;
    private final PlayerEntity zzhdz;
    private final int zzeiu;
    private final ParticipantResult zzhmq;
    private final String zzhbw;
    private final String zzhbx;

    public ParticipantEntity(Participant participant) {
        this.zzhfy = participant.getParticipantId();
        this.zzebw = participant.getDisplayName();
        this.zzhbl = participant.getIconImageUri();
        this.zzhbm = participant.getHiResImageUri();
        this.zzbyy = participant.getStatus();
        this.zzhmo = participant.zzarw();
        this.zzhmp = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzhdz = player == null ? null : new PlayerEntity(player);
        this.zzeiu = participant.getCapabilities();
        this.zzhmq = participant.getResult();
        this.zzhbw = participant.getIconImageUrl();
        this.zzhbx = participant.getHiResImageUrl();
    }

    ParticipantEntity(String string, String string2, Uri uri, Uri uri2, int n, String string3, boolean bl, PlayerEntity playerEntity, int n2, ParticipantResult participantResult, String string4, String string5) {
        this.zzhfy = string;
        this.zzebw = string2;
        this.zzhbl = uri;
        this.zzhbm = uri2;
        this.zzbyy = n;
        this.zzhmo = string3;
        this.zzhmp = bl;
        this.zzhdz = playerEntity;
        this.zzeiu = n2;
        this.zzhmq = participantResult;
        this.zzhbw = string4;
        this.zzhbx = string5;
    }

    @Override
    public final int getStatus() {
        return this.zzbyy;
    }

    @Override
    public final String zzarw() {
        return this.zzhmo;
    }

    @Override
    public final boolean isConnectedToRoom() {
        return this.zzhmp;
    }

    @Override
    public final String getDisplayName() {
        if (this.zzhdz == null) {
            return this.zzebw;
        }
        return this.zzhdz.getDisplayName();
    }

    @Override
    public final void getDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.zzhdz == null) {
            zzg.zzb((String)this.zzebw, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.zzhdz.getDisplayName(charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        if (this.zzhdz == null) {
            return this.zzhbl;
        }
        return this.zzhdz.getIconImageUri();
    }

    @Override
    public final String getIconImageUrl() {
        if (this.zzhdz == null) {
            return this.zzhbw;
        }
        return this.zzhdz.getIconImageUrl();
    }

    @Override
    public final Uri getHiResImageUri() {
        if (this.zzhdz == null) {
            return this.zzhbm;
        }
        return this.zzhdz.getHiResImageUri();
    }

    @Override
    public final String getHiResImageUrl() {
        if (this.zzhdz == null) {
            return this.zzhbx;
        }
        return this.zzhdz.getHiResImageUrl();
    }

    @Override
    public final String getParticipantId() {
        return this.zzhfy;
    }

    @Override
    public final Player getPlayer() {
        return this.zzhdz;
    }

    @Override
    public final ParticipantResult getResult() {
        return this.zzhmq;
    }

    @Override
    public final int getCapabilities() {
        return this.zzeiu;
    }

    public final Participant freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return Arrays.hashCode(new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzarw(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public final boolean equals(Object object) {
        return ParticipantEntity.zza(this, object);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzbf.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzbf.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzbf.equal((Object)participant2.zzarw(), (Object)participant.zzarw()) && zzbf.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzbf.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzbf.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzbf.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzbf.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzbf.equal((Object)((Object)participant2.getResult()), (Object)((Object)participant.getResult())) && zzbf.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public final String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzbf.zzt((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzarw()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ParticipantEntity participantEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)participantEntity.getParticipantId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)participantEntity.getDisplayName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Parcelable)participantEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)participantEntity.getHiResImageUri(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)5, (int)participantEntity.getStatus());
        zzbcn.zza((Parcel)parcel2, (int)6, (String)participantEntity.zzhmo, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (boolean)participantEntity.isConnectedToRoom());
        zzbcn.zza((Parcel)parcel2, (int)8, (Parcelable)participantEntity.getPlayer(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)9, (int)participantEntity.zzeiu);
        zzbcn.zza((Parcel)parcel2, (int)10, (Parcelable)participantEntity.getResult(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)11, (String)participantEntity.getIconImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)12, (String)participantEntity.getHiResImageUrl(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    static final class zza
    extends zzc {
        zza() {
        }

        @Override
        public final ParticipantEntity zzl(Parcel parcel) {
            if (ParticipantEntity.zze(ParticipantEntity.zzakd()) || ParticipantEntity.zzgb((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzl(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl = parcel.readInt() > 0;
            PlayerEntity playerEntity = parcel.readInt() > 0 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(string, string2, uri, uri2, n, string5, bl, playerEntity, 7, null, null, null);
        }

        @Override
        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return ((zzc)this).zzl(parcel);
        }
    }
}

