/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.zza;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class GameRequestEntity
extends zzc
implements GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new zza();
    private final GameEntity zzhje;
    private final PlayerEntity zzhoj;
    private final byte[] zzhnp;
    private final String zzcjv;
    private final ArrayList<PlayerEntity> zzhok;
    private final int zzecy;
    private final long mCreationTimestamp;
    private final long zzhol;
    private final Bundle zzhom;
    private final int zzbyy;

    public GameRequestEntity(GameRequest gameRequest) {
        this.zzhje = new GameEntity(gameRequest.getGame());
        this.zzhoj = new PlayerEntity(gameRequest.getSender());
        this.zzcjv = gameRequest.getRequestId();
        this.zzecy = gameRequest.getType();
        this.mCreationTimestamp = gameRequest.getCreationTimestamp();
        this.zzhol = gameRequest.getExpirationTimestamp();
        this.zzbyy = gameRequest.getStatus();
        byte[] byArray = gameRequest.getData();
        if (byArray == null) {
            this.zzhnp = null;
        } else {
            this.zzhnp = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzhnp, 0, byArray.length);
        }
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        this.zzhok = new ArrayList(n);
        this.zzhom = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzhok.add((PlayerEntity)player);
            this.zzhom.putInt(string, gameRequest.getRecipientStatus(string));
        }
    }

    GameRequestEntity(GameEntity gameEntity, PlayerEntity playerEntity, byte[] byArray, String string, ArrayList<PlayerEntity> arrayList, int n, long l, long l2, Bundle bundle, int n2) {
        this.zzhje = gameEntity;
        this.zzhoj = playerEntity;
        this.zzhnp = byArray;
        this.zzcjv = string;
        this.zzhok = arrayList;
        this.zzecy = n;
        this.mCreationTimestamp = l;
        this.zzhol = l2;
        this.zzhom = bundle;
        this.zzbyy = n2;
    }

    @Override
    public final String getRequestId() {
        return this.zzcjv;
    }

    @Override
    public final Game getGame() {
        return this.zzhje;
    }

    @Override
    public final Player getSender() {
        return this.zzhoj;
    }

    @Override
    public final List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzhok);
    }

    @Override
    public final boolean isConsumed(String string) {
        return this.getRecipientStatus(string) == 1;
    }

    @Override
    public final byte[] getData() {
        return this.zzhnp;
    }

    @Override
    public final int getType() {
        return this.zzecy;
    }

    @Override
    public final long getCreationTimestamp() {
        return this.mCreationTimestamp;
    }

    @Override
    public final long getExpirationTimestamp() {
        return this.zzhol;
    }

    @Override
    public final int getRecipientStatus(String string) {
        return this.zzhom.getInt(string, 0);
    }

    @Override
    public final int getStatus() {
        return this.zzbyy;
    }

    public final GameRequest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return Arrays.hashCode(new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public final boolean equals(Object object) {
        return GameRequestEntity.zza(this, object);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzbf.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzbf.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzbf.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzbf.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzbf.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzbf.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzbf.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public final String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzbf.zzt((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GameRequestEntity gameRequestEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (Parcelable)gameRequestEntity.getGame(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (Parcelable)gameRequestEntity.getSender(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (byte[])gameRequestEntity.getData(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)gameRequestEntity.getRequestId(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)5, gameRequestEntity.getRecipients(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)7, (int)gameRequestEntity.getType());
        zzbcn.zza((Parcel)parcel2, (int)9, (long)gameRequestEntity.getCreationTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)10, (long)gameRequestEntity.getExpirationTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)11, (Bundle)gameRequestEntity.zzhom, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)12, (int)gameRequestEntity.getStatus());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }
}

