/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.zze;

public interface SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new zze();

    public String getDescription();

    public Long getPlayedTimeMillis();

    public BitmapTeleporter zzasa();

    public Bitmap getCoverImage();

    public Long getProgressValue();

    public static final class Builder {
        private String zzdmt;
        private Long zzhoq;
        private Long zzhor;
        private BitmapTeleporter zzhos;
        private Uri zzhot;

        public Builder() {
        }

        public final Builder setDescription(String string) {
            this.zzdmt = string;
            return this;
        }

        public final Builder setPlayedTimeMillis(long l) {
            this.zzhoq = l;
            return this;
        }

        public final Builder setProgressValue(long l) {
            this.zzhor = l;
            return this;
        }

        public final Builder setCoverImage(Bitmap bitmap) {
            this.zzhos = new BitmapTeleporter(bitmap);
            this.zzhot = null;
            return this;
        }

        public final Builder fromMetadata(SnapshotMetadata snapshotMetadata) {
            this.zzdmt = snapshotMetadata.getDescription();
            this.zzhoq = snapshotMetadata.getPlayedTime();
            this.zzhor = snapshotMetadata.getProgressValue();
            if (this.zzhoq == -1L) {
                this.zzhoq = null;
            }
            this.zzhot = snapshotMetadata.getCoverImageUri();
            if (this.zzhot != null) {
                this.zzhos = null;
            }
            return this;
        }

        public final SnapshotMetadataChange build() {
            return new zze(this.zzdmt, this.zzhoq, this.zzhos, this.zzhot, this.zzhor);
        }
    }
}

