/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.games.video.zzb;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;

public final class VideoConfiguration
extends zzbck {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int zzhpz;
    private final int zzhps;
    private final String zzhqa;
    private final String zzhqb;
    private final String zzhqc;
    private final String zzhqd;
    private final boolean zzhqe;

    public VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        zzbp.zzbh((boolean)VideoConfiguration.isValidQualityLevel(n, false));
        zzbp.zzbh((boolean)VideoConfiguration.isValidCaptureMode(n2, false));
        this.zzhpz = n;
        this.zzhps = n2;
        this.zzhqe = bl;
        if (n2 == 1) {
            this.zzhqb = string2;
            this.zzhqa = string;
            this.zzhqc = string3;
            this.zzhqd = string4;
            return;
        }
        zzbp.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
        zzbp.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
        zzbp.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
        zzbp.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
        this.zzhqb = null;
        this.zzhqa = null;
        this.zzhqc = null;
        this.zzhqd = null;
    }

    public final int getQualityLevel() {
        return this.zzhpz;
    }

    public final int getCaptureMode() {
        return this.zzhps;
    }

    public final String getStreamUrl() {
        return this.zzhqa;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoConfiguration videoConfiguration = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)videoConfiguration.getQualityLevel());
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)videoConfiguration.getCaptureMode());
        zzbcn.zza((Parcel)parcel2, (int)3, (String)videoConfiguration.getStreamUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)videoConfiguration.zzhqb, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (String)videoConfiguration.zzhqc, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (String)videoConfiguration.zzhqd, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (boolean)videoConfiguration.zzhqe);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int zzhpz;
        private int zzhps;
        private boolean zzhqe;
        private String zzhqa;
        private String zzhqb;
        private String zzhqc;
        private String zzhqd;

        public Builder(int n, int n2) {
            this.zzhpz = n;
            this.zzhps = n2;
            this.zzhqe = true;
            this.zzhqa = null;
            this.zzhqb = null;
            this.zzhqc = null;
            this.zzhqd = null;
        }

        public final Builder setQualityLevel(int n) {
            this.zzhpz = n;
            return this;
        }

        public final Builder setCaptureMode(int n) {
            this.zzhps = n;
            return this;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zzhpz, this.zzhps, null, null, null, null, this.zzhqe);
        }
    }
}

