/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.zzab;
import com.google.android.gms.games.internal.api.zzaf;
import com.google.android.gms.games.internal.api.zzav;
import com.google.android.gms.games.internal.api.zzaw;
import com.google.android.gms.games.internal.api.zzax;
import com.google.android.gms.games.internal.api.zzbh;
import com.google.android.gms.games.internal.api.zzbs;
import com.google.android.gms.games.internal.api.zzbt;
import com.google.android.gms.games.internal.api.zzcb;
import com.google.android.gms.games.internal.api.zzcp;
import com.google.android.gms.games.internal.api.zzcq;
import com.google.android.gms.games.internal.api.zzcu;
import com.google.android.gms.games.internal.api.zzdr;
import com.google.android.gms.games.internal.api.zzo;
import com.google.android.gms.games.internal.api.zzp;
import com.google.android.gms.games.internal.api.zzx;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.games.zze;
import com.google.android.gms.games.zzf;
import com.google.android.gms.internal.zzbvq;
import com.google.android.gms.internal.zzbvy;
import java.util.ArrayList;

@KeepForSdk
public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    static final Api.zzf<GamesClientImpl> zzdwp = new Api.zzf();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzdwq = new com.google.android.gms.games.zzb();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzhce = new com.google.android.gms.games.zzc();
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    private static Scope zzhcf = new Scope("https://www.googleapis.com/auth/games_lite");
    public static final Api<GamesOptions> API = new Api("Games.API", zzdwq, zzdwp);
    public static final Scope zzhcg = new Scope("https://www.googleapis.com/auth/games.firstparty");
    private static Api<GamesOptions> zzhch = new Api("Games.API_1P", zzhce, zzdwp);
    public static final GamesMetadata GamesMetadata = new zzx();
    public static final Achievements Achievements = new com.google.android.gms.games.internal.api.zza();
    private static zzbvq zzhci = new zzo();
    public static final Events Events = new zzp();
    public static final Leaderboards Leaderboards = new zzaf();
    public static final Invitations Invitations = new zzab();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new zzcu();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new zzbs();
    private static Multiplayer zzhcj = new zzav();
    public static final Players Players = new zzax();
    public static final Notifications Notifications = new zzaw();
    public static final Quests Quests = new zzbh();
    public static final Requests Requests = new zzbt();
    public static final Snapshots Snapshots = new zzcb();
    public static final Stats Stats = new zzcq();
    public static final Videos Videos = new zzdr();
    private static zzbvy zzhck = new zzcp();

    private Games() {
    }

    public static GamesClientImpl zzf(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true);
    }

    public static GamesClientImpl zza(GoogleApiClient googleApiClient, boolean bl) {
        zzbp.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzbp.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzb(googleApiClient, bl);
    }

    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzbp.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        if (bl2) {
            return (GamesClientImpl)googleApiClient.zza(zzdwp);
        }
        return null;
    }

    public static void setGravityForPopups(GoogleApiClient googleApiClient, int n) {
        GamesClientImpl gamesClientImpl = Games.zza(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzdd(n);
        }
    }

    public static void setViewForPopups(GoogleApiClient googleApiClient, View view) {
        zzbp.zzu((Object)view);
        GamesClientImpl gamesClientImpl = Games.zza(googleApiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzs(view);
        }
    }

    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    public static String getCurrentAccountName(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzapw();
    }

    @Deprecated
    @KeepForSdk
    public static PendingResult<GetServerAuthCodeResult> getGamesServerAuthCode(GoogleApiClient googleApiClient, String string) {
        zzbp.zzh((String)string, (Object)"Please provide a valid serverClientId");
        return googleApiClient.zze((zzm)new com.google.android.gms.games.zzd(googleApiClient, string));
    }

    public static String getAppId(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).getAppId();
    }

    public static Intent getSettingsIntent(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzaqi();
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.zze((zzm)new zze(googleApiClient));
    }

    public static int getSdkVariant(GoogleApiClient googleApiClient) {
        return Games.zza(googleApiClient, true).zzaqj();
    }

    static abstract class zzd
    extends zza<Status> {
        private zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public final /* synthetic */ Result zzb(Status status) {
            return status;
        }

        /* synthetic */ zzd(GoogleApiClient googleApiClient, com.google.android.gms.games.zzb zzb2) {
            this(googleApiClient);
        }
    }

    static abstract class zzc
    extends zza<GetServerAuthCodeResult> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zzc zzc2 = this;
            return new zzf(zzc2, status2);
        }

        /* synthetic */ zzc(GoogleApiClient googleApiClient, com.google.android.gms.games.zzb zzb2) {
            this(googleApiClient);
        }
    }

    @Deprecated
    @KeepForSdk
    public static interface GetServerAuthCodeResult
    extends Result {
        @KeepForSdk
        public String getCode();
    }

    public static abstract class zza<R extends Result>
    extends zzm<R, GamesClientImpl> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzdwp, googleApiClient);
        }
    }

    static abstract class zzb
    extends Api.zza<GamesClientImpl, GamesOptions> {
        private zzb() {
        }

        public final int getPriority() {
            return 1;
        }

        public final /* synthetic */ Api.zze zza(Context context, Looper looper, zzq zzq2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
            GamesOptions gamesOptions = (GamesOptions)object;
            zzq zzq3 = zzq2;
            Looper looper2 = looper;
            Context context2 = context;
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions.Builder(null).build();
            }
            return new GamesClientImpl(context2, looper2, zzq3, gamesOptions, connectionCallbacks2, onConnectionFailedListener2);
        }

        /* synthetic */ zzb(com.google.android.gms.games.zzb zzb2) {
            this();
        }
    }

    public static final class GamesOptions
    implements GoogleSignInOptionsExtension,
    Api.ApiOptions.Optional {
        public final boolean zzhcm;
        private boolean zzhcn;
        private int zzhco;
        private boolean zzhcp;
        private int zzhcq;
        private String zzhcr;
        private ArrayList<String> zzhcs;
        private boolean zzhct;
        public final boolean zzhcu;
        private boolean zzhcv;

        private GamesOptions(boolean bl, boolean bl2, int n, boolean bl3, int n2, String string, ArrayList<String> arrayList, boolean bl4, boolean bl5, boolean bl6) {
            this.zzhcm = bl;
            this.zzhcn = bl2;
            this.zzhco = n;
            this.zzhcp = bl3;
            this.zzhcq = n2;
            this.zzhcr = string;
            this.zzhcs = arrayList;
            this.zzhct = bl4;
            this.zzhcu = bl5;
            this.zzhcv = bl6;
        }

        public final Bundle toBundle() {
            return this.zzapm();
        }

        public final Bundle zzapm() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.zzhcm);
            bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.zzhcn);
            bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.zzhco);
            bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.zzhcp);
            bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.zzhcq);
            bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.zzhcr);
            bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.zzhcs);
            bundle.putBoolean("com.google.android.gms.games.key.requireGooglePlus", this.zzhct);
            bundle.putBoolean("com.google.android.gms.games.key.unauthenticated", this.zzhcu);
            bundle.putBoolean("com.google.android.gms.games.key.skipWelcomePopup", this.zzhcv);
            return bundle;
        }

        public static Builder builder() {
            return new Builder(null);
        }

        /* synthetic */ GamesOptions(boolean bl, boolean bl2, int n, boolean bl3, int n2, String string, ArrayList arrayList, boolean bl4, boolean bl5, boolean bl6, com.google.android.gms.games.zzb zzb2) {
            this(false, bl2, n, false, n2, null, arrayList, false, false, false);
        }

        public static final class Builder {
            private boolean zzhcm = false;
            private boolean zzhcn = true;
            private int zzhco = 17;
            private boolean zzhcp = false;
            private int zzhcq = 4368;
            private String zzhcr = null;
            private ArrayList<String> zzhcs = new ArrayList();
            private boolean zzhct = false;
            private boolean zzhcu = false;
            private boolean zzhcv = false;

            private Builder() {
            }

            public final Builder setShowConnectingPopup(boolean bl) {
                this.zzhcn = bl;
                this.zzhco = 17;
                return this;
            }

            public final Builder setShowConnectingPopup(boolean bl, int n) {
                this.zzhcn = bl;
                this.zzhco = n;
                return this;
            }

            public final Builder setSdkVariant(int n) {
                this.zzhcq = n;
                return this;
            }

            public final GamesOptions build() {
                return new GamesOptions(false, this.zzhcn, this.zzhco, false, this.zzhcq, null, this.zzhcs, false, false, false, null);
            }

            /* synthetic */ Builder(com.google.android.gms.games.zzb zzb2) {
                this();
            }
        }
    }
}

