/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.zza;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;

public final class AchievementEntity
extends zzc
implements Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new zza();
    private final String zzhdt;
    private final int zzecz;
    private final String mName;
    private final String zzdmu;
    private final Uri zzhdu;
    private final String zzhdv;
    private final Uri zzhdw;
    private final String zzhdx;
    private final int zzhdy;
    private final String zzhdz;
    private final PlayerEntity zzhea;
    private final int mState;
    private final int zzheb;
    private final String zzhec;
    private final long zzhed;
    private final long zzhee;

    public AchievementEntity(Achievement achievement) {
        this.zzhdt = achievement.getAchievementId();
        this.zzecz = achievement.getType();
        this.mName = achievement.getName();
        this.zzdmu = achievement.getDescription();
        this.zzhdu = achievement.getUnlockedImageUri();
        this.zzhdv = achievement.getUnlockedImageUrl();
        this.zzhdw = achievement.getRevealedImageUri();
        this.zzhdx = achievement.getRevealedImageUrl();
        this.zzhea = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzhed = achievement.getLastUpdatedTimestamp();
        this.zzhee = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzhdy = achievement.getTotalSteps();
            this.zzhdz = achievement.getFormattedTotalSteps();
            this.zzheb = achievement.getCurrentSteps();
            this.zzhec = achievement.getFormattedCurrentSteps();
        } else {
            this.zzhdy = 0;
            this.zzhdz = null;
            this.zzheb = 0;
            this.zzhec = null;
        }
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzhdt);
        com.google.android.gms.common.internal.zzc.zzr((Object)this.zzdmu);
    }

    AchievementEntity(String string, int n, String string2, String string3, Uri uri, String string4, Uri uri2, String string5, int n2, String string6, PlayerEntity playerEntity, int n3, int n4, String string7, long l, long l2) {
        this.zzhdt = string;
        this.zzecz = n;
        this.mName = string2;
        this.zzdmu = string3;
        this.zzhdu = uri;
        this.zzhdv = string4;
        this.zzhdw = uri2;
        this.zzhdx = string5;
        this.zzhdy = n2;
        this.zzhdz = string6;
        this.zzhea = playerEntity;
        this.mState = n3;
        this.zzheb = n4;
        this.zzhec = string7;
        this.zzhed = l;
        this.zzhee = l2;
    }

    @Override
    public final String getAchievementId() {
        return this.zzhdt;
    }

    @Override
    public final int getType() {
        return this.zzecz;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdmu;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzdmu, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getUnlockedImageUri() {
        return this.zzhdu;
    }

    @Override
    public final String getUnlockedImageUrl() {
        return this.zzhdv;
    }

    @Override
    public final Uri getRevealedImageUri() {
        return this.zzhdw;
    }

    @Override
    public final String getRevealedImageUrl() {
        return this.zzhdx;
    }

    @Override
    public final int getTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhdy;
    }

    @Override
    public final String getFormattedTotalSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhdz;
    }

    @Override
    public final void getFormattedTotalSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhdz, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Player getPlayer() {
        return this.zzhea;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    public final int getCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzheb;
    }

    @Override
    public final String getFormattedCurrentSteps() {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzhec;
    }

    @Override
    public final void getFormattedCurrentSteps(CharArrayBuffer charArrayBuffer) {
        com.google.android.gms.common.internal.zzc.zzbg((this.getType() == 1 ? 1 : 0) != 0);
        zzg.zzb((String)this.zzhec, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhed;
    }

    @Override
    public final long getXpValue() {
        return this.zzhee;
    }

    public final Achievement freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        AchievementEntity achievementEntity = this;
        int n = 0;
        int n2 = 0;
        if (achievementEntity.getType() == 1) {
            n = achievementEntity.getCurrentSteps();
            n2 = achievementEntity.getTotalSteps();
        }
        return Arrays.hashCode(new Object[]{achievementEntity.getAchievementId(), achievementEntity.getName(), achievementEntity.getType(), achievementEntity.getDescription(), achievementEntity.getXpValue(), achievementEntity.getState(), achievementEntity.getLastUpdatedTimestamp(), achievementEntity.getPlayer(), n, n2});
    }

    public final boolean equals(Object object) {
        Object object2 = object;
        AchievementEntity achievementEntity = this;
        if (object2 instanceof Achievement) {
            if (achievementEntity == object2) {
                return true;
            }
            Achievement achievement = (Achievement)object2;
            boolean bl = true;
            boolean bl2 = true;
            if (achievementEntity.getType() == 1) {
                bl = zzbf.equal((Object)achievement.getCurrentSteps(), (Object)achievementEntity.getCurrentSteps());
                bl2 = zzbf.equal((Object)achievement.getTotalSteps(), (Object)achievementEntity.getTotalSteps());
            }
            if (zzbf.equal((Object)achievement.getAchievementId(), (Object)achievementEntity.getAchievementId()) && zzbf.equal((Object)achievement.getName(), (Object)achievementEntity.getName()) && zzbf.equal((Object)achievement.getType(), (Object)achievementEntity.getType()) && zzbf.equal((Object)achievement.getDescription(), (Object)achievementEntity.getDescription()) && zzbf.equal((Object)achievement.getXpValue(), (Object)achievementEntity.getXpValue()) && zzbf.equal((Object)achievement.getState(), (Object)achievementEntity.getState()) && zzbf.equal((Object)achievement.getLastUpdatedTimestamp(), (Object)achievementEntity.getLastUpdatedTimestamp()) && zzbf.equal((Object)achievement.getPlayer(), (Object)achievementEntity.getPlayer()) && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return AchievementEntity.zza(this);
    }

    static String zza(Achievement achievement) {
        zzbh zzbh2 = zzbf.zzt((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zzbh2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zzbh2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zzbh2.toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AchievementEntity achievementEntity = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)achievementEntity.getAchievementId(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)achievementEntity.getType());
        zzbcn.zza((Parcel)parcel2, (int)3, (String)achievementEntity.getName(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (String)achievementEntity.getDescription(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (Parcelable)achievementEntity.getUnlockedImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (String)achievementEntity.getUnlockedImageUrl(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)achievementEntity.getRevealedImageUri(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (String)achievementEntity.getRevealedImageUrl(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)9, (int)achievementEntity.zzhdy);
        zzbcn.zza((Parcel)parcel2, (int)10, (String)achievementEntity.zzhdz, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)11, (Parcelable)achievementEntity.getPlayer(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)12, (int)achievementEntity.getState());
        zzbcn.zzc((Parcel)parcel2, (int)13, (int)achievementEntity.zzheb);
        zzbcn.zza((Parcel)parcel2, (int)14, (String)achievementEntity.zzhec, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)15, (long)achievementEntity.getLastUpdatedTimestamp());
        zzbcn.zza((Parcel)parcel2, (int)16, (long)achievementEntity.getXpValue());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }
}

